/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TraceDownloadStatus {
    public static final int OK = 0;
    public static final int TIMEOUT = 1;
    public static final int ERROR = 2;
    private File fDownloadedFile;
    private Throwable fException;
    private int fSeverity;
    private List<TraceDownloadStatus> fMultipleStatus;

    public TraceDownloadStatus(int severity, File file, Throwable exception) {
        this.fSeverity = severity;
        this.fDownloadedFile = file;
        this.fException = exception;
        this.fMultipleStatus = new ArrayList<TraceDownloadStatus>();
    }

    public File getDownloadedFile() {
        return this.fDownloadedFile;
    }

    public Throwable getException() {
        return this.fException;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public void setDownloadedFile(File downloadedFile) {
        this.fDownloadedFile = downloadedFile;
    }

    public void setException(Throwable exception) {
        this.fException = exception;
    }

    public void setSeverity(int severity) {
        this.fSeverity = severity;
    }

    public boolean isOk() {
        return this.fSeverity == 0;
    }

    public boolean isTimeout() {
        return this.fSeverity == 1;
    }

    public List<TraceDownloadStatus> getChildren() {
        return this.fMultipleStatus;
    }

    public void add(TraceDownloadStatus status) {
        this.fMultipleStatus.add(status);
        if (status.getSeverity() == 1) {
            this.fSeverity = 1;
            this.fException = status.getException();
        } else if (this.fSeverity == 0 && !status.isOk()) {
            this.fSeverity = status.getSeverity();
        }
    }
}

