/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractUnit;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.IncommensurableException;
import org.unitsofmeasurement.unit.UnconvertibleException;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public final class TransformedUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = -442449068482939939L;
    private final Unit<Q> parentUnit;
    private final AbstractConverter toParentUnit;

    @Override
    public UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        if (this.toParentUnit != null) {
            return this.toParentUnit.inverse();
        }
        return super.getConverterToAny(that);
    }

    public TransformedUnit(Unit<Q> parentUnit, AbstractConverter toParentUnit) {
        if (toParentUnit == AbstractConverter.IDENTITY) {
            throw new IllegalArgumentException("Identity not allowed");
        }
        this.parentUnit = parentUnit;
        this.toParentUnit = toParentUnit;
    }

    public Unit<Q> getParentUnit() {
        return this.parentUnit;
    }

    public UnitConverter toParentUnit() {
        return this.toParentUnit;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof TransformedUnit)) {
            return false;
        }
        TransformedUnit thatUnit = (TransformedUnit)that;
        return this.parentUnit.equals(thatUnit.parentUnit) && this.toParentUnit != null && this.toParentUnit.equals(thatUnit.toParentUnit);
    }

    @Override
    public int hashCode() {
        return this.parentUnit.hashCode() + (this.toParentUnit != null ? this.toParentUnit.hashCode() : 0);
    }

    @Override
    protected Unit<Q> toMetric() {
        return this.parentUnit.getSystemUnit();
    }

    @Override
    public UnitConverter getConverterToMetric() {
        return ((AbstractUnit)this.parentUnit).getConverterToMetric().concatenate((UnitConverter)this.toParentUnit);
    }

    public Unit<Q> getSystemUnit() {
        return this.toMetric();
    }
}

