/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.quantity;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.IMeasure;
import org.eclipse.uomo.units.impl.BaseQuantity;
import org.eclipse.uomo.units.impl.converter.RationalConverter;
import org.unitsofmeasurement.quantity.Time;
import org.unitsofmeasurement.unit.IncommensurableException;
import org.unitsofmeasurement.unit.UnconvertibleException;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public final class TimeAmount
extends BaseQuantity<Time>
implements Time {
    public TimeAmount(Number number, Unit<Time> unit) {
        super(number, unit);
    }

    @Override
    public AbstractUnit<Time> unit() {
        return (AbstractUnit)super.unit();
    }

    @Override
    public double doubleValue(Unit<Time> unit) {
        Unit myUnit = this.unit();
        try {
            UnitConverter converter = unit.getConverterToAny(myUnit);
            return converter.convert(this.getValue().doubleValue());
        }
        catch (UnconvertibleException e) {
            throw e;
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public long longValue(Unit<Time> unit) {
        Unit myUnit = this.unit();
        try {
            UnitConverter converter = unit.getConverterToAny(myUnit);
            return converter.convert(BigDecimal.valueOf(this.getValue().longValue()), MathContext.DECIMAL128).longValue();
        }
        catch (UnconvertibleException e) {
            throw e;
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public TimeAmount add(IMeasure<Time> that) {
        return new TimeAmount((Number)(super.getValue().doubleValue() + ((BaseQuantity)that).getValue().doubleValue()), (Unit<Time>)that.unit());
    }

    public TimeAmount subtract(IMeasure<Time> that) {
        return new TimeAmount((Number)(super.getValue().doubleValue() - ((BaseQuantity)that).getValue().doubleValue()), (Unit<Time>)that.unit());
    }

    public TimeAmount multiply(IMeasure<?> that) {
        Unit<?> unit = this.unit().multiply(that.unit());
        return new TimeAmount(this.getValue(), (Unit<Time>)unit);
    }

    public static TimeAmount valueOf(Number value, AbstractUnit<Time> unit) {
        TimeAmount amount = new TimeAmount(value, (Unit<Time>)unit);
        return amount;
    }

    public TimeAmount to(Unit<Time> unit) {
        return this.to((Unit)unit, MathContext.DECIMAL32);
    }

    public TimeAmount to(Unit<Time> unit, MathContext ctx) {
        if (this.unit().equals(unit)) {
            return this;
        }
        UnitConverter cvtr = this.unit().getConverterTo(unit);
        if (cvtr == AbstractConverter.IDENTITY) {
            return (TimeAmount)TimeAmount.of(this.getValue().intValue(), unit);
        }
        return (TimeAmount)TimeAmount.of(TimeAmount.convert(this.getValue(), cvtr, ctx).intValue(), unit);
    }

    private static Number convert(Number value, UnitConverter cvtr, MathContext ctx) {
        if (cvtr instanceof RationalConverter) {
            RationalConverter rCvtr = (RationalConverter)cvtr;
            BigInteger dividend = rCvtr.getDividend();
            BigInteger divisor = rCvtr.getDivisor();
            if (dividend.abs().compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new ArithmeticException("Multiplier overflow");
            }
            if (divisor.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new ArithmeticException("Divisor overflow");
            }
            return value.longValue() * dividend.longValue() / divisor.longValue();
        }
        if (cvtr instanceof AbstractConverter.Compound && cvtr.isLinear()) {
            AbstractConverter.Compound compound = (AbstractConverter.Compound)cvtr;
            Number firstConversion = TimeAmount.convert(value, compound.getRight(), ctx);
            Number secondConversion = TimeAmount.convert(firstConversion, compound.getLeft(), ctx);
            return secondConversion;
        }
        BigDecimal decimalValue = BigDecimal.valueOf(value.doubleValue());
        BigDecimal newValue = cvtr.convert(decimalValue, ctx);
        return newValue;
    }
}

