/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMUtil {
    private static final String XML_VERSION = "1.0";
    private static final String XML_ENCODING = "UTF-8";

    private DOMUtil() {
    }

    public static int getIndex(Node parentNode, Node child) {
        NodeList nodeList = parentNode.getChildNodes();
        int index = -1;
        int size = nodeList.getLength();
        int i = 0;
        while (i < size) {
            if (nodeList.item(i) == child) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static boolean isCommentAllowed(Node node) {
        short type = node.getNodeType();
        return type == 1 || type == 3;
    }

    public static synchronized String generateXMLString(Document doc) throws IOException {
        StringWriter stringWriter = null;
        XMLSerializer serializer = null;
        OutputFormat outputFormat = null;
        String result = null;
        serializer = new XMLSerializer();
        stringWriter = new StringWriter();
        outputFormat = new OutputFormat();
        outputFormat.setEncoding(XML_ENCODING);
        outputFormat.setVersion(XML_VERSION);
        outputFormat.setIndenting(true);
        outputFormat.setIndent(4);
        serializer.setOutputCharStream((Writer)stringWriter);
        serializer.setOutputFormat(outputFormat);
        serializer.serialize(doc);
        result = stringWriter.toString();
        stringWriter.close();
        return result;
    }

    public static synchronized String generateXMLString(DocumentFragment fragment, boolean omitXMLDeclaration) throws IOException {
        if (omitXMLDeclaration) {
            StringWriter stringWriter = null;
            XMLSerializer serializer = null;
            OutputFormat outputFormat = null;
            String result = null;
            serializer = new XMLSerializer();
            stringWriter = new StringWriter();
            outputFormat = new OutputFormat();
            outputFormat.setOmitXMLDeclaration(true);
            outputFormat.setIndenting(true);
            outputFormat.setIndent(4);
            serializer.setOutputCharStream((Writer)stringWriter);
            serializer.setOutputFormat(outputFormat);
            serializer.serialize(fragment);
            result = stringWriter.toString();
            stringWriter.close();
            return result;
        }
        DOMUtil.generateXMLString(fragment);
        return null;
    }

    public static synchronized String generateXMLString(DocumentFragment fragment) throws IOException {
        StringWriter stringWriter = null;
        XMLSerializer serializer = null;
        OutputFormat outputFormat = null;
        String result = null;
        serializer = new XMLSerializer();
        stringWriter = new StringWriter();
        outputFormat = new OutputFormat();
        outputFormat.setEncoding(XML_ENCODING);
        outputFormat.setVersion(XML_VERSION);
        outputFormat.setIndenting(true);
        outputFormat.setIndent(4);
        serializer.setOutputCharStream((Writer)stringWriter);
        serializer.setOutputFormat(outputFormat);
        serializer.serialize(fragment);
        result = stringWriter.toString();
        stringWriter.close();
        return result;
    }

    public static synchronized String generateXMLString(Element element) throws IOException {
        StringWriter stringWriter = null;
        XMLSerializer serializer = null;
        OutputFormat outputFormat = null;
        String result = null;
        serializer = new XMLSerializer();
        stringWriter = new StringWriter();
        outputFormat = new OutputFormat();
        outputFormat.setEncoding(XML_ENCODING);
        outputFormat.setVersion(XML_VERSION);
        outputFormat.setIndenting(true);
        outputFormat.setIndent(4);
        outputFormat.setOmitXMLDeclaration(true);
        serializer.setOutputCharStream((Writer)stringWriter);
        serializer.setOutputFormat(outputFormat);
        serializer.serialize(element);
        result = stringWriter.toString();
        stringWriter.close();
        return result;
    }

    public static String addNamespacePrefix(Element parent, String namespace, String basePrefix) {
        String result = DOMUtil.suggestNamespacePrefix(parent, namespace, basePrefix);
        parent.getOwnerDocument().getDocumentElement().setAttribute("xmlns:" + result, namespace);
        return result;
    }

    public static String suggestNamespacePrefix(Element parent, String namespace, String basePrefix) {
        String result = basePrefix;
        if (result == null) {
            result = "ns";
        }
        int count = 0;
        String foundNS = DOMUtil.lookupPrefixOnElement(parent, basePrefix);
        while (foundNS != null && !foundNS.equals(namespace)) {
            result = String.valueOf(basePrefix) + ++count;
        }
        return result;
    }

    public static String lookupPrefixForNamespace(Element element, String namespace) {
        String result = DOMUtil.lookupNamespaceOnElement(element, namespace);
        if (result == null) {
            if (element.getParentNode() != null && element.getParentNode() instanceof Element) {
                result = DOMUtil.lookupPrefixForNamespace((Element)element.getParentNode(), namespace);
            } else if (element.getOwnerDocument() != null && element.getOwnerDocument().getDocumentElement() != null && element.getOwnerDocument().getDocumentElement() != element) {
                result = DOMUtil.lookupPrefixForNamespace(element.getOwnerDocument().getDocumentElement(), namespace);
            }
        }
        return result;
    }

    public static String lookupPrefixForNamespace(Element parent, Element element, String namespace) {
        String result = DOMUtil.lookupNamespaceOnElement(element, namespace);
        if (result == null) {
            if (element.getParentNode() != null && element.getParentNode() instanceof Element) {
                result = DOMUtil.lookupPrefixForNamespace((Element)element.getParentNode(), namespace);
            } else if (parent != null) {
                result = DOMUtil.lookupPrefixForNamespace(parent, namespace);
            } else if (element.getOwnerDocument() != null && element.getOwnerDocument().getDocumentElement() != null) {
                result = DOMUtil.lookupPrefixForNamespace(element.getOwnerDocument().getDocumentElement(), namespace);
            }
        }
        return result;
    }

    private static String lookupNamespaceOnElement(Element element, String namespace) {
        int i = 0;
        while (i < element.getAttributes().getLength()) {
            Attr attr = (Attr)element.getAttributes().item(i);
            String name = attr.getNodeName();
            if (name.startsWith("xmlns") && namespace.equals(attr.getNodeValue())) {
                if (name.equals("xmlns")) {
                    return "";
                }
                return name.substring(6);
            }
            ++i;
        }
        return null;
    }

    public static String lookupNamespaceForPrefix(Element element, String prefix) {
        String result = DOMUtil.lookupPrefixOnElement(element, prefix);
        if (result == null && element.getParentNode() != null && element.getParentNode() instanceof Element) {
            result = DOMUtil.lookupNamespaceForPrefix((Element)element.getParentNode(), prefix);
        }
        return result;
    }

    public static String lookupPrefixOnElement(Element element, String prefix) {
        int i = 0;
        while (i < element.getAttributes().getLength()) {
            Attr attr = (Attr)element.getAttributes().item(i);
            String name = attr.getNodeName();
            if (name.startsWith("xmlns:") && name.endsWith(":" + prefix)) {
                return attr.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public static String lookupNamespaceForElement(Element node) {
        if (node.getPrefix() != null) {
            return DOMUtil.lookupNamespaceForPrefix(node, node.getPrefix());
        }
        if (node.getNodeName().indexOf(":") > 0) {
            return DOMUtil.lookupNamespaceForPrefix(node, node.getNodeName().substring(0, node.getNodeName().indexOf(":")));
        }
        return node.getNamespaceURI();
    }

    public static String lookupNamespaceForNode(Node node) {
        if (node instanceof Attr) {
            String name = node.getNodeName();
            if (name.indexOf(":") > 0) {
                return DOMUtil.lookupNamespaceForPrefix(((Attr)node).getOwnerElement(), name.substring(0, name.indexOf(":")));
            }
            return DOMUtil.lookupNamespaceForElement(((Attr)node).getOwnerElement());
        }
        if (node instanceof Element) {
            return DOMUtil.lookupNamespaceForElement((Element)node);
        }
        return null;
    }

    public static boolean hasContent(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 || node.getNodeType() == 3 || node.getNodeType() == 6 || node.getNodeType() == 5 || node.getNodeType() == 4) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    public static String getNodeLocalName(Node node) {
        String result = node.getLocalName();
        if (result == null) {
            result = node.getNodeName();
        }
        return result;
    }

    public static Element getFirstElement(Element element) {
        Node node = element.getFirstChild();
        while (node != null && !(node instanceof Element)) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    public static Element getNextElement(Element element) {
        Node node = element.getNextSibling();
        while (node != null && !(node instanceof Element)) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    public static Element getFirstElementByName(Element element, String name) {
        Node node = element.getFirstChild();
        while (!(node == null || node instanceof Element && node.getLocalName().equals(name))) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    public static Element getNextElementByName(Element element, String name) {
        Node node = element.getNextSibling();
        while (!(node == null || node instanceof Element && node.getLocalName().equals(name))) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }
}

