/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.uomo.core.IListValidator;
import org.eclipse.uomo.core.UOMoException;
import org.eclipse.uomo.core.UOMoRuntimeException;
import org.eclipse.uomo.ucum.expression.Term;
import org.eclipse.uomo.ucum.impl.UcumConverter;
import org.eclipse.uomo.ucum.model.DefinedUnit;
import org.eclipse.uomo.ucum.model.UcumModel;
import org.eclipse.uomo.ucum.model.UcumUnit;
import org.eclipse.uomo.ucum.parsers.ExpressionComposer;
import org.eclipse.uomo.ucum.parsers.ExpressionParser;
import org.eclipse.uomo.util.Registry;

public class UcumValidator
implements IListValidator<String> {
    private final UcumModel model;
    private final Registry<?> handlers;
    private List<String> result;

    public UcumValidator(UcumModel model, Registry<?> handlers) {
        this.model = model;
        this.handlers = handlers;
    }

    public List<String> validate() {
        this.result = new ArrayList<String>();
        this.checkCodes();
        this.checkUnits();
        return this.result;
    }

    private void checkCodes() {
        for (UcumUnit ucumUnit : this.model.getBaseUnits()) {
            this.checkUnitCode(ucumUnit.getCode(), true);
        }
        for (UcumUnit ucumUnit : this.model.getDefinedUnits()) {
            this.checkUnitCode(ucumUnit.getCode(), true);
        }
    }

    private void checkUnits() {
        for (DefinedUnit unit : this.model.getDefinedUnits()) {
            if (!unit.isSpecial()) {
                this.checkUnitCode(unit.getValue().getUnit(), false);
                continue;
            }
            if (this.handlers.exists(unit.getCode())) continue;
            this.result.add("No Handler for " + unit.getCode().toString());
        }
    }

    private void checkUnitCode(String code, boolean primary) {
        try {
            Term term = new ExpressionParser(this.model).parse(code);
            String c = new ExpressionComposer().compose(term);
            if (!c.equals(code)) {
                this.result.add("Round trip failed: " + code + " -> " + c);
            }
            term = new UcumConverter(this.model, this.handlers).convert(term).getUnit();
        }
        catch (UOMoRuntimeException e) {
            this.result.add(String.valueOf(code) + ": " + e.getMessage());
        }
        if (primary) {
            try {
                boolean inBrack = false;
                boolean nonDigits = false;
                int i = 0;
                while (i < code.length()) {
                    char ch = code.charAt(i);
                    if (ch == '[') {
                        if (inBrack) {
                            throw new UOMoRuntimeException("nested [");
                        }
                        inBrack = true;
                    }
                    if (ch == ']') {
                        if (!inBrack) {
                            throw new UOMoRuntimeException("] without [");
                        }
                        inBrack = false;
                    }
                    boolean bl = nonDigits = nonDigits || ch < '0' || ch > '9';
                    if (ch >= '0' && ch <= '9' && !inBrack && nonDigits) {
                        throw new UOMoException("code " + code + " is ambiguous because  it has digits outside []");
                    }
                    ++i;
                }
            }
            catch (UOMoException e) {
                this.result.add(e.getMessage());
            }
        }
    }
}

