/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.core.sockjs.impl.BaseTransport;
import org.vertx.java.core.sockjs.impl.Session;

class JsonPTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(JsonPTransport.class);

    JsonPTransport(VertxInternal vertx, RouteMatcher rm, String basePath, final Map<String, Session> sessions, final JsonObject config, final Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, config);
        String jsonpRE = basePath + "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/" + "jsonp";
        rm.getWithRegEx(jsonpRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest req) {
                String callback;
                if (log.isTraceEnabled()) {
                    log.trace("JsonP, get: " + req.uri());
                }
                if ((callback = req.params().get("callback")) == null && (callback = req.params().get("c")) == null) {
                    req.response().setStatusCode(500);
                    req.response().end("\"callback\" parameter required\n");
                    return;
                }
                String sessionID = req.params().get("param0");
                Session session = JsonPTransport.this.getSession(config.getLong("session_timeout"), config.getLong("heartbeat_period"), sessionID, sockHandler);
                session.setInfo(req.localAddress(), req.remoteAddress(), req.uri(), req.headers());
                session.register(new JsonPListener(req, session, callback));
            }
        });
        String jsonpSendRE = basePath + "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/" + "jsonp_send";
        rm.postWithRegEx(jsonpSendRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest req) {
                String sessionID;
                Session session;
                if (log.isTraceEnabled()) {
                    log.trace("JsonP, post: " + req.uri());
                }
                if ((session = (Session)sessions.get(sessionID = req.params().get("param0"))) != null && !session.isClosed()) {
                    JsonPTransport.this.handleSend(req, session);
                } else {
                    req.response().setStatusCode(404);
                    BaseTransport.setJSESSIONID(config, req);
                    req.response().end();
                }
            }
        });
    }

    private void handleSend(final HttpServerRequest req, final Session session) {
        req.bodyHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer buff) {
                boolean urlEncoded;
                String body = buff.toString();
                String ct = req.headers().get("content-type");
                if ("application/x-www-form-urlencoded".equalsIgnoreCase(ct)) {
                    urlEncoded = true;
                } else if ("text/plain".equalsIgnoreCase(ct)) {
                    urlEncoded = false;
                } else {
                    req.response().setStatusCode(500);
                    req.response().end("Invalid Content-Type");
                    return;
                }
                if (body.equals("") || urlEncoded && (!body.startsWith("d=") || body.length() <= 2)) {
                    req.response().setStatusCode(500);
                    req.response().end("Payload expected.");
                    return;
                }
                if (urlEncoded) {
                    try {
                        body = URLDecoder.decode(body, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException("No UTF-8!");
                    }
                    body = body.substring(2);
                }
                if (!session.handleMessages(body)) {
                    JsonPTransport.this.sendInvalidJSON(req.response());
                } else {
                    BaseTransport.setJSESSIONID(JsonPTransport.this.config, req);
                    req.response().headers().set("Content-Type", "text/plain; charset=UTF-8");
                    BaseTransport.setNoCacheHeaders(req);
                    req.response().end("ok");
                    if (log.isTraceEnabled()) {
                        log.trace("send handled ok");
                    }
                }
            }
        });
    }

    private class JsonPListener
    extends BaseTransport.BaseListener {
        final String callback;
        boolean headersWritten;
        boolean closed;

        JsonPListener(HttpServerRequest req, Session session, String callback) {
            super(req, session);
            this.callback = callback;
            this.addCloseHandler(req.response(), session);
        }

        @Override
        public void sendFrame(String body) {
            if (log.isTraceEnabled()) {
                log.trace("JsonP, sending frame");
            }
            if (!this.headersWritten) {
                this.req.response().setChunked(true);
                this.req.response().headers().set("Content-Type", "application/javascript; charset=UTF-8");
                BaseTransport.setNoCacheHeaders(this.req);
                BaseTransport.setJSESSIONID(JsonPTransport.this.config, this.req);
                this.headersWritten = true;
            }
            body = JsonPTransport.this.escapeForJavaScript(body);
            StringBuilder sb = new StringBuilder();
            sb.append(this.callback).append("(\"");
            sb.append(body);
            sb.append("\");\r\n");
            this.req.response().write(sb.toString());
            this.close();
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.req.response().end();
                    this.req.response().close();
                    this.closed = true;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }
}

