/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgicommand.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.kernel.osgicommand.helper.ClassLoadingHelper;
import org.eclipse.virgo.kernel.osgicommand.management.ClassLoadingSupportMBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ClassLoadingSupport
implements ClassLoadingSupportMBean {
    private BundleContext bundleContext;

    public ClassLoadingSupport(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public Map<List<String>, List<String>> getBundlesLoadingClass(String className) {
        HashMap<Bundle, Bundle> bundles = ClassLoadingHelper.getBundlesLoadingClass(this.bundleContext, className);
        HashMap<List<String>, List<String>> result = new HashMap<List<String>, List<String>>();
        for (Map.Entry entry : bundles.entrySet()) {
            Bundle loadingBundle = (Bundle)entry.getKey();
            Bundle originatingBundle = (Bundle)entry.getKey();
            result.put(this.getBundleInformation(loadingBundle), this.getBundleInformation(originatingBundle));
        }
        return result;
    }

    @Override
    public List<List<String>> getBundlesExportingPackage(String packageName) {
        Bundle[] allBundles = this.bundleContext.getBundles();
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        Bundle[] bundleArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (ClassLoadingHelper.isPackageExported(this.bundleContext, packageName, bundle)) {
                result.add(this.getBundleInformation(bundle));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public boolean tryToLoadClassFromBundle(String className, long bundleId) {
        Class<?> result = ClassLoadingHelper.tryToLoadClass(className, this.bundleContext.getBundle(bundleId));
        return result != null;
    }

    private List<String> getBundleInformation(Bundle bundle) {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(bundle != null ? "" + bundle.getBundleId() : null);
        list.add(bundle != null ? bundle.getSymbolicName() : null);
        return list;
    }
}

