/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Set;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.eclipse.gemini.web.tomcat.internal.loading.BundleClassPathURLExtractor;
import org.eclipse.gemini.web.tomcat.internal.loading.ChainedClassLoader;
import org.eclipse.gemini.web.tomcat.spi.ClassLoaderCustomizer;
import org.osgi.framework.Bundle;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWebappClassLoader
extends URLClassLoader
implements Lifecycle {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.loader");
    protected static final Log log = LogFactory.getLog(BundleWebappClassLoader.class);
    private volatile boolean started = false;
    private final ClassLoader bundleDelegatingClassLoader;
    private final ClassLoaderCustomizer classLoaderCustomizer;
    private final Bundle bundle;

    public BundleWebappClassLoader(Bundle bundle, ClassLoaderCustomizer classLoaderCustomizer) {
        super(new URL[0]);
        this.bundle = bundle;
        this.classLoaderCustomizer = classLoaderCustomizer;
        this.addBundleClassPathURLs(bundle);
        this.bundleDelegatingClassLoader = this.createClassLoaderChain(bundle);
    }

    private ChainedClassLoader createClassLoaderChain(Bundle bundle) {
        ClassLoader[] finalLoaders;
        ClassLoader[] loaders = new ClassLoader[]{BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)bundle), Context.class.getClassLoader()};
        ClassLoader[] chainExtensions = this.classLoaderCustomizer.extendClassLoaderChain(bundle);
        if (chainExtensions != null && chainExtensions.length > 0) {
            finalLoaders = new ClassLoader[loaders.length + chainExtensions.length];
            System.arraycopy(loaders, 0, finalLoaders, 0, loaders.length);
            System.arraycopy(chainExtensions, 0, finalLoaders, loaders.length, chainExtensions.length);
        } else {
            finalLoaders = loaders;
        }
        return ChainedClassLoader.create(finalLoaders);
    }

    private void addBundleClassPathURLs(Bundle bundle) {
        Set<URI> uris = BundleClassPathURLExtractor.extractBundleClassPathURLs(bundle);
        for (URI uri : uris) {
            try {
                this.addURL(uri.toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoaderCustomizer.addClassFileTransformer(transformer, this.bundle);
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.classLoaderCustomizer.createThrowawayClassLoader(this.bundle);
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public void start() throws LifecycleException {
        this.started = true;
    }

    public void stop() throws LifecycleException {
        this.clearReferences();
        this.started = false;
    }

    @Override
    public URL getResource(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResource(" + name + ")"));
        }
        URL url = null;
        url = this.bundleDelegatingClassLoader.getResource(name);
        if (url != null) {
            return url;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return super.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResources(" + name + ")"));
        }
        return this.bundleDelegatingClassLoader.getResources(name);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadClass(" + name + ", " + resolve + ")"));
        }
        Class<?> clazz = null;
        if (!this.started) {
            try {
                throw new IllegalStateException();
            }
            catch (IllegalStateException e) {
                log.info((Object)sm.getString("webappClassLoader.stopped", (Object)name), (Throwable)e);
            }
        }
        if ((clazz = this.findLoadedClass(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching the application's bundle");
        }
        try {
            clazz = this.bundleDelegatingClassLoader.loadClass(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Loading class from the delegating classloader");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        throw new ClassNotFoundException(name);
    }

    protected void clearReferences() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (driver.getClass().getClassLoader() != this) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                log.warn((Object)"SQL driver deregistration failed", (Throwable)e);
            }
        }
        IntrospectionUtils.clear();
        LogFactory.release((ClassLoader)this);
        Introspector.flushCaches();
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

