/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.quasi;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.virgo.kernel.osgi.framework.ManifestTransformer;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyDependenciesException;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiResolutionFailure;
import org.eclipse.virgo.kernel.userregion.internal.equinox.TransformedManifestProvidingBundleFileWrapper;
import org.eclipse.virgo.kernel.userregion.internal.quasi.DependencyCalculator;
import org.eclipse.virgo.kernel.userregion.internal.quasi.GenericQuasiResolutionFailure;
import org.eclipse.virgo.kernel.userregion.internal.quasi.PackageQuasiResolutionFailure;
import org.eclipse.virgo.kernel.userregion.internal.quasi.PackageUsesQuasiResolutionFailure;
import org.eclipse.virgo.kernel.userregion.internal.quasi.ResolutionFailureDetective;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiBundle;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.util.common.StringUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StandardQuasiFramework
implements QuasiFramework {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object monitor = new Object();
    private final State state;
    private final StateObjectFactory stateObjectFactory;
    private final List<StandardQuasiBundle> installedQuasiBundles = new ArrayList<StandardQuasiBundle>();
    private volatile BundleDescription[] otherBundles;
    private final ResolutionFailureDetective detective;
    private final BundleContext bundleContext;
    private final DependencyCalculator dependencyCalculator;
    private final StateHelper stateHelper;
    private final TransformedManifestProvidingBundleFileWrapper bundleTransformationHandler;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    StandardQuasiFramework(BundleContext bundleContext, State state, PlatformAdmin platformAdmin, ResolutionFailureDetective detective, Repository repository, TransformedManifestProvidingBundleFileWrapper bundleTransformationHandler) {
        this.bundleContext = bundleContext;
        this.state = state;
        this.stateObjectFactory = platformAdmin.getFactory();
        this.detective = detective;
        this.dependencyCalculator = new DependencyCalculator(platformAdmin.getFactory(), this.detective, repository, this.bundleContext);
        this.stateHelper = platformAdmin.getStateHelper();
        this.bundleTransformationHandler = bundleTransformationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuasiBundle install(URI location, BundleManifest bundleManifest) throws BundleException {
        Object object = this.monitor;
        synchronized (object) {
            StandardQuasiBundle qb = this.doInstall(location, bundleManifest);
            this.installedQuasiBundles.add(qb);
            return qb;
        }
    }

    private StandardQuasiBundle doInstall(URI location, BundleManifest bundleManifest) throws BundleException {
        try {
            Dictionary manifest = bundleManifest.toDictionary();
            String installLocation = "file".equals(location.getScheme()) ? new File(location).getAbsolutePath() : location.toString();
            BundleDescription bundleDescription = this.stateObjectFactory.createBundleDescription(this.state, manifest, installLocation, this.nextBundleId());
            this.state.addBundle(bundleDescription);
            return new StandardQuasiBundle(bundleDescription, bundleManifest, this.stateHelper);
        }
        catch (RuntimeException e) {
            throw new BundleException("Unable to read bundle at '" + location + "'", (Throwable)e);
        }
    }

    private long nextBundleId() {
        return this.dependencyCalculator.getNextBundleId();
    }

    public List<QuasiBundle> getBundles() {
        BundleDescription[] bundleDescriptions = this.state.getBundles();
        ArrayList<StandardQuasiBundle> result = new ArrayList<StandardQuasiBundle>();
        BundleDescription[] bundleDescriptionArray = bundleDescriptions;
        int n = bundleDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundleDescription = bundleDescriptionArray[n2];
            StandardQuasiBundle quasiBundle = new StandardQuasiBundle(bundleDescription, null, this.stateHelper);
            result.add(quasiBundle);
            ++n2;
        }
        return Collections.unmodifiableList(result);
    }

    public QuasiBundle getBundle(long bundleId) {
        StandardQuasiBundle quasiBundle = null;
        BundleDescription bundleDescription = this.state.getBundle(bundleId);
        if (bundleDescription != null) {
            quasiBundle = new StandardQuasiBundle(bundleDescription, null, this.stateHelper);
        }
        return quasiBundle;
    }

    public QuasiBundle getBundle(String name, Version version) {
        StandardQuasiBundle quasiBundle = null;
        BundleDescription bundleDescription = this.state.getBundle(name, version);
        if (bundleDescription != null) {
            quasiBundle = new StandardQuasiBundle(bundleDescription, null, this.stateHelper);
        }
        return quasiBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QuasiResolutionFailure> resolve() {
        Object object = this.monitor;
        synchronized (object) {
            BundleDescription[] bundles = this.getBundleDescriptionArray();
            BundleDescription[] dependencies = this.getDependencies(bundles);
            this.otherBundles = dependencies;
            List<QuasiResolutionFailure> failures = this.getFailures();
            if (!failures.isEmpty()) {
                this.otherBundles = null;
            }
            return failures;
        }
    }

    public List<QuasiResolutionFailure> diagnose(long bundleId) {
        BundleDescription bundleDescription = this.state.getBundle(bundleId);
        ResolutionFailureDetective.ResolverErrorsHolder reh = new ResolutionFailureDetective.ResolverErrorsHolder();
        String failureDescription = this.detective.generateFailureDescription(this.state, bundleDescription, reh);
        return this.processResolverErrors(reh.getResolverErrors(), new StandardQuasiBundle(bundleDescription, null, this.stateHelper), failureDescription);
    }

    private BundleDescription[] getDependencies(BundleDescription[] bundles) {
        try {
            return this.dependencyCalculator.calculateDependencies(this.state, bundles);
        }
        catch (BundleException bundleException) {
            return new BundleDescription[0];
        }
        catch (UnableToSatisfyDependenciesException unableToSatisfyDependenciesException) {
            return new BundleDescription[0];
        }
    }

    private List<QuasiResolutionFailure> getFailures() {
        ArrayList<QuasiResolutionFailure> failures = new ArrayList<QuasiResolutionFailure>();
        for (StandardQuasiBundle quasiBundle : this.installedQuasiBundles) {
            if (quasiBundle.isResolved()) continue;
            ResolutionFailureDetective.ResolverErrorsHolder reh = new ResolutionFailureDetective.ResolverErrorsHolder();
            String failureDescription = this.detective.generateFailureDescription(this.state, quasiBundle.getBundleDescription(), reh);
            failures.addAll(this.processResolverErrors(reh.getResolverErrors(), quasiBundle, failureDescription));
        }
        return failures;
    }

    private List<QuasiResolutionFailure> processResolverErrors(ResolverError[] resolverErrors, QuasiBundle quasiBundle, String failureDescription) {
        ArrayList<QuasiResolutionFailure> processedResolverErrors = new ArrayList<QuasiResolutionFailure>();
        boolean added = false;
        if (resolverErrors != null) {
            ResolverError[] resolverErrorArray = resolverErrors;
            int n = resolverErrors.length;
            int n2 = 0;
            while (n2 < n) {
                VersionConstraint unsatisfiedConstraint;
                ResolverError resolverError = resolverErrorArray[n2];
                if (resolverError.getType() == 32) {
                    unsatisfiedConstraint = resolverError.getUnsatisfiedConstraint();
                    if (unsatisfiedConstraint instanceof ImportPackageSpecification) {
                        processedResolverErrors.add(this.createPackagesUsesResolutionFailure(quasiBundle, failureDescription, unsatisfiedConstraint));
                        added = true;
                    }
                } else if (resolverError.getType() == 1 && (unsatisfiedConstraint = resolverError.getUnsatisfiedConstraint()) instanceof ImportPackageSpecification) {
                    processedResolverErrors.add(this.createPackageResolutionFailure(quasiBundle, failureDescription, unsatisfiedConstraint));
                    added = true;
                }
                ++n2;
            }
        }
        if (!added) {
            processedResolverErrors.add(new GenericQuasiResolutionFailure(quasiBundle, failureDescription));
        }
        return processedResolverErrors;
    }

    private PackageQuasiResolutionFailure createPackageResolutionFailure(QuasiBundle quasiBundle, String failureDescription, VersionConstraint unsatisfiedConstraint) {
        ImportPackageSpecification importPackageSpecification = (ImportPackageSpecification)unsatisfiedConstraint;
        String pkgName = importPackageSpecification.getName();
        org.eclipse.virgo.util.osgi.VersionRange pkgVersionRange = StandardQuasiFramework.convertVersionRange(importPackageSpecification.getVersionRange());
        String bundleSymbolicName = importPackageSpecification.getBundleSymbolicName();
        org.eclipse.virgo.util.osgi.VersionRange bundleVersionRange = StandardQuasiFramework.convertVersionRange(importPackageSpecification.getBundleVersionRange());
        this.logger.debug("Missing import: package '{}' version '{}' bundle '{}' version '{}'", new Object[]{pkgName, pkgVersionRange, bundleSymbolicName, bundleVersionRange});
        return new PackageQuasiResolutionFailure(failureDescription, quasiBundle, pkgName, pkgVersionRange, bundleSymbolicName, bundleVersionRange);
    }

    private PackageUsesQuasiResolutionFailure createPackagesUsesResolutionFailure(QuasiBundle quasiBundle, String failureDescription, VersionConstraint unsatisfiedConstraint) {
        ImportPackageSpecification importPackageSpecification = (ImportPackageSpecification)unsatisfiedConstraint;
        String pkgName = importPackageSpecification.getName();
        org.eclipse.virgo.util.osgi.VersionRange pkgVersionRange = StandardQuasiFramework.convertVersionRange(importPackageSpecification.getVersionRange());
        String bundleSymbolicName = importPackageSpecification.getBundleSymbolicName();
        org.eclipse.virgo.util.osgi.VersionRange bundleVersionRange = StandardQuasiFramework.convertVersionRange(importPackageSpecification.getBundleVersionRange());
        this.logger.debug("Uses conflict: package '{}' version '{}' bundle '{}' version '{}'", new Object[]{pkgName, pkgVersionRange, bundleSymbolicName, bundleVersionRange});
        return new PackageUsesQuasiResolutionFailure(failureDescription, quasiBundle, pkgName, pkgVersionRange, bundleSymbolicName, bundleVersionRange);
    }

    private static org.eclipse.virgo.util.osgi.VersionRange convertVersionRange(VersionRange versionRange) {
        return new org.eclipse.virgo.util.osgi.VersionRange(versionRange.toString());
    }

    private BundleDescription[] getBundleDescriptionArray() {
        int n = this.installedQuasiBundles.size();
        BundleDescription[] bd = new BundleDescription[n];
        int i = 0;
        while (i < n) {
            bd[i] = this.installedQuasiBundles.get(i).getBundleDescription();
            ++i;
        }
        return bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws BundleException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.otherBundles == null) {
                List<QuasiResolutionFailure> failures = this.resolve();
                if (!failures.isEmpty()) {
                    throw new BundleException("Commit resolution failed: '" + failures.toString() + "'");
                }
            } else {
                try {
                    Set<Long> installedQuasiBundles = this.installQuasiBundles();
                    List<Bundle> installedDependencies = this.installOtherBundles(installedQuasiBundles);
                    this.startBundles(installedDependencies);
                }
                catch (BundleException e) {
                    this.uninstallQuasiBundles();
                    throw e;
                }
            }
        }
    }

    private void startBundles(List<Bundle> bundles) throws BundleException {
        for (Bundle bundle : bundles) {
            this.startBundle(bundle);
        }
    }

    private void startBundle(Bundle bundle) throws BundleException {
        String bundleActivationPolicy;
        if (!StandardQuasiFramework.isFragmentBundle(bundle) && (bundleActivationPolicy = (String)bundle.getHeaders().get("Bundle-ActivationPolicy")) == null) {
            try {
                bundle.start();
            }
            catch (BundleException be) {
                throw new BundleException("Failed to start bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "'", (Throwable)be);
            }
        }
    }

    private static boolean isFragmentBundle(Bundle bundle) {
        String fragmentHostHeader = (String)bundle.getHeaders().get("Fragment-Host");
        return StringUtils.hasText((String)fragmentHostHeader);
    }

    /*
     * Unable to fully structure code
     */
    private List<Bundle> installOtherBundles(Set<Long> installedQuasiBundles) throws BundleException {
        installedBundles = new ArrayList<Bundle>();
        var6_3 = this.otherBundles;
        var5_4 = this.otherBundles.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            block7: {
                otherBundle = var6_3[var4_5];
                if (!installedQuasiBundles.contains(otherBundle.getBundleId())) {
                    try {
                        bundle = this.installBundleDescription(otherBundle);
                        installedBundles.add(bundle);
                        break block7;
                    }
                    catch (BundleException e) {
                        ** for (bundle : installedBundles)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            bundle.uninstall();
                        }
                        catch (BundleException be) {
                            this.logger.error("Uninstall of '{}' failed", (Object)be, (Object)bundle);
                        }
                        continue;
                    }
lbl21:
                    // 1 sources

                    throw e;
                }
            }
            ++var4_5;
        }
        return installedBundles;
    }

    private Set<Long> installQuasiBundles() throws BundleException {
        HashSet<Long> installed = new HashSet<Long>();
        for (StandardQuasiBundle quasiBundle : this.installedQuasiBundles) {
            BundleDescription description = quasiBundle.getBundleDescription();
            String location = description.getLocation();
            QuasiManifestTransformer manifestTransformer = new QuasiManifestTransformer(quasiBundle.getBundleManifest());
            this.bundleTransformationHandler.pushManifestTransformer(manifestTransformer);
            try {
                URI locationUri = new File(location).toURI();
                Bundle bundle = this.bundleContext.installBundle(locationUri.toString());
                quasiBundle.setBundle(bundle);
                installed.add(description.getBundleId());
            }
            finally {
                this.bundleTransformationHandler.popManifestTransformer();
            }
        }
        return installed;
    }

    private Bundle installBundleDescription(BundleDescription description) throws BundleException {
        String location = description.getLocation();
        String installLocation = location.startsWith("http:") ? location : new File(location).toURI().toString();
        return this.doInstallBundleInternal(installLocation);
    }

    private Bundle doInstallBundleInternal(String location) throws BundleException {
        return this.bundleContext.installBundle(location);
    }

    private void uninstallQuasiBundles() {
        for (StandardQuasiBundle quasiBundle : this.installedQuasiBundles) {
            Bundle bundle = quasiBundle.getBundle();
            if (bundle == null) continue;
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                this.logger.error("Uninstall of '{}' failed", (Object)e, (Object)quasiBundle);
            }
            quasiBundle.setBundle(null);
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiFramework");
    }

    private static final class QuasiManifestTransformer
    implements ManifestTransformer {
        private final BundleManifest bundleManifest;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        public QuasiManifestTransformer(BundleManifest bundleManifest) {
            this.bundleManifest = bundleManifest;
        }

        public BundleManifest transform(BundleManifest bundleManifest) {
            return this.bundleManifest;
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiFramework$QuasiManifestTransformer");
        }
    }
}

