/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentFamilyType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentTypeType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterForClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererClassType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererTypeType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;

public class AnnotationSearchRequestor
extends SearchRequestor {
    private final FacesConfigType facesConfig;
    private static final Set<String> ANNOATION_CANDIDATES = AnnotationSearchRequestor.ofAnnotation("javax.faces.bean.ManagedBean", "javax.faces.bean.ReferencedBean", "javax.faces.component.FacesComponent", "javax.faces.convert.FacesConverter", "javax.faces.render.FacesRenderer", "javax.faces.validator.FacesValidator", "javax.inject.Named", "javax.enterprise.inject.Model");
    private static final Set<String> SCOPED_ANNOTATION_CANDIDATES = AnnotationSearchRequestor.ofAnnotation("javax.faces.bean.NoneScoped", "javax.faces.bean.ViewScoped", "javax.faces.bean.SessionScoped", "javax.faces.bean.ApplicationScoped", "javax.faces.bean.CustomScoped");
    private static final Set<String> CDI_SCOPED_ANNOTATION_CANDIDATES = AnnotationSearchRequestor.ofAnnotation("javax.enterprise.context.RequestScoped", "javax.enterprise.context.ConversationScoped", "javax.enterprise.context.SessionScoped", "javax.enterprise.context.ApplicationScoped");

    private static Set<String> ofAnnotation(String ... annotationClasses) {
        HashSet<String> candidates = new HashSet<String>();
        String[] stringArray = annotationClasses;
        int n = annotationClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String annotationClass = stringArray[n2];
            candidates.add(annotationClass);
            candidates.add(Signature.getSimpleName((String)annotationClass));
            ++n2;
        }
        return Collections.unmodifiableSet(candidates);
    }

    AnnotationSearchRequestor(FacesConfigType facesConfig) {
        this.facesConfig = facesConfig;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        if (match.getAccuracy() != 0) {
            return;
        }
        Object element = match.getElement();
        if (!(element instanceof IType)) {
            return;
        }
        IType type = (IType)element;
        JDTBeanIntrospector beanIntrospector = JDTBeanIntrospector.forType((IType)type);
        IAnnotation[] annotations = type.getAnnotations();
        if (annotations == null) {
            return;
        }
        IAnnotation[] iAnnotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            this.processAnnotation(type, beanIntrospector, annotation);
            ++n2;
        }
    }

    private void processAnnotation(IType type, JDTBeanIntrospector beanIntrospector, IAnnotation annotation) throws CoreException {
        if (!annotation.exists()) {
            return;
        }
        String annotationType = annotation.getElementName();
        if (!this.isAnnotationCandidate(annotationType)) {
            return;
        }
        String annotationClassName = beanIntrospector.resolveFullQualifiedTypeName(annotationType);
        if (annotationClassName != null) {
            if ("javax.faces.bean.ManagedBean".equals(annotationClassName)) {
                this.addManagedBean(annotation, type, beanIntrospector);
            } else if ("javax.faces.bean.ReferencedBean".equals(annotationClassName)) {
                this.addReferencedBean(annotation, type);
            } else if ("javax.faces.component.FacesComponent".equals(annotationClassName)) {
                this.addComponent(annotation, type);
            } else if ("javax.faces.convert.FacesConverter".equals(annotationClassName)) {
                this.addConverter(annotation, type);
            } else if ("javax.faces.render.FacesRenderer".equals(annotationClassName)) {
                this.addRenderer(annotation, type);
            } else if ("javax.faces.validator.FacesValidator".equals(annotationClassName)) {
                this.addValidator(annotation, type);
            } else if ("javax.inject.Named".equals(annotationClassName)) {
                this.addCDINamedBean(annotation, beanIntrospector, type);
            } else if ("javax.enterprise.inject.Model".equals(annotationClassName)) {
                this.addCDIModelBean(type);
            }
        }
    }

    private boolean isAnnotationCandidate(String annotationType) {
        return ANNOATION_CANDIDATES.contains(annotationType);
    }

    private void addReferencedBean(IAnnotation referencedBeanAnnotation, IType beanType) throws JavaModelException {
        IMemberValuePair[] pairs = referencedBeanAnnotation.getMemberValuePairs();
        String beanNameString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("name".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    beanNameString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if (beanNameString == null && (beanNameString = beanType.getElementName()) != null && beanNameString.length() > 0) {
            StringBuffer casedName = new StringBuffer(String.valueOf(beanNameString.charAt(0)).toUpperCase());
            beanNameString = casedName.append(beanNameString.substring(1)).toString();
        }
        String beanClassName = beanType.getFullyQualifiedName();
        if (beanNameString != null && beanClassName != null) {
            ReferencedBeanType bean = FacesConfigFactory.eINSTANCE.createReferencedBeanType();
            ReferencedBeanNameType beanName = FacesConfigFactory.eINSTANCE.createReferencedBeanNameType();
            beanName.setTextContent(beanNameString);
            bean.setReferencedBeanName(beanName);
            ReferencedBeanClassType beanClass = FacesConfigFactory.eINSTANCE.createReferencedBeanClassType();
            beanClass.setTextContent(beanClassName);
            bean.setReferencedBeanClass(beanClass);
            this.facesConfig.getReferencedBean().add((Object)bean);
        }
    }

    private void addManagedBean(IAnnotation beanAnnotation, IType beanType, JDTBeanIntrospector beanIntrospector) throws JavaModelException {
        IMemberValuePair[] pairs = beanAnnotation.getMemberValuePairs();
        String beanNameString = null;
        Boolean isBeanEager = Boolean.FALSE;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("name".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    beanNameString = (String)pair.getValue();
                } else if ("eager".equals(pair.getMemberName()) && pair.getValueKind() == 8) {
                    isBeanEager = (Boolean)pair.getValue();
                }
                ++n2;
            }
        }
        if ((beanNameString == null || beanNameString.length() < 1) && (beanNameString = beanType.getElementName()) != null && beanNameString.length() > 0) {
            StringBuffer casedName = new StringBuffer(String.valueOf(beanNameString.charAt(0)).toLowerCase());
            beanNameString = casedName.append(beanNameString.substring(1)).toString();
        }
        String beanClassName = beanType.getFullyQualifiedName();
        String beanScopeString = this.processScopeAnnotations(beanType, beanIntrospector);
        if (beanNameString != null && beanClassName != null) {
            ManagedBeanType bean = FacesConfigFactory.eINSTANCE.createManagedBeanType();
            ManagedBeanNameType beanName = FacesConfigFactory.eINSTANCE.createManagedBeanNameType();
            beanName.setTextContent(beanNameString);
            bean.setManagedBeanName(beanName);
            ManagedBeanClassType beanClass = FacesConfigFactory.eINSTANCE.createManagedBeanClassType();
            beanClass.setTextContent(beanClassName);
            bean.setManagedBeanClass(beanClass);
            ManagedBeanScopeType beanScope = FacesConfigFactory.eINSTANCE.createManagedBeanScopeType();
            beanScope.setTextContent(beanScopeString);
            bean.setManagedBeanScope(beanScope);
            bean.setEager(isBeanEager.booleanValue());
            JSFAppConfigUtils.setManagedBeanSource(bean, "JSF_ANNOTATION");
            this.facesConfig.getManagedBean().add((Object)bean);
        }
    }

    private String processScopeAnnotations(IType beanType, JDTBeanIntrospector beanIntrospector) throws JavaModelException {
        String beanScopeString = "request";
        IAnnotation[] annotations = beanType.getAnnotations();
        if (annotations == null) {
            return beanScopeString;
        }
        IAnnotation[] iAnnotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String scope = this.processScopeAnnoation(beanType, beanIntrospector, annotation);
            if (scope != null) {
                beanScopeString = scope;
            }
            ++n2;
        }
        return beanScopeString;
    }

    private String processScopeAnnoation(IType beanType, JDTBeanIntrospector beanIntrospector, IAnnotation annotation) throws JavaModelException {
        IMemberValuePair[] scopePairs;
        if (!annotation.exists()) {
            return null;
        }
        String annotationType = annotation.getElementName();
        if (!this.isScopeAnnotationCandidate(annotationType)) {
            return null;
        }
        String annotationClassName = beanIntrospector.resolveFullQualifiedTypeName(annotationType);
        if (annotationClassName == null) {
            return null;
        }
        if ("javax.faces.bean.NoneScoped".equals(annotationClassName)) {
            return "none";
        }
        if ("javax.faces.bean.ViewScoped".equals(annotationClassName)) {
            return "view";
        }
        if ("javax.faces.bean.SessionScoped".equals(annotationClassName)) {
            return "session";
        }
        if ("javax.faces.bean.ApplicationScoped".equals(annotationClassName)) {
            return "application";
        }
        if ("javax.faces.bean.CustomScoped".equals(annotationClassName) && (scopePairs = annotation.getMemberValuePairs()) != null && scopePairs.length == 1 && scopePairs[0].getValueKind() == 9) {
            return (String)scopePairs[0].getValue();
        }
        return null;
    }

    private boolean isScopeAnnotationCandidate(String annotationType) {
        return SCOPED_ANNOTATION_CANDIDATES.contains(annotationType);
    }

    private void addValidator(IAnnotation validatorAnnotation, IType validatorType) throws JavaModelException {
        String validatorClassName = validatorType.getFullyQualifiedName();
        IMemberValuePair[] pairs = validatorAnnotation.getMemberValuePairs();
        String validatorIDString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("value".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    validatorIDString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if (validatorClassName != null && validatorIDString != null) {
            ValidatorType validator = FacesConfigFactory.eINSTANCE.createValidatorType();
            ValidatorClassType validatorClass = FacesConfigFactory.eINSTANCE.createValidatorClassType();
            validatorClass.setTextContent(validatorClassName);
            validator.setValidatorClass(validatorClass);
            ValidatorIdType validatorID = FacesConfigFactory.eINSTANCE.createValidatorIdType();
            validatorID.setTextContent(validatorIDString);
            validator.setValidatorId(validatorID);
            this.facesConfig.getValidator().add((Object)validator);
        }
    }

    private void addRenderer(IAnnotation rendererAnnotation, IType rendererType) throws JavaModelException {
        String rendererClassName = rendererType.getFullyQualifiedName();
        IMemberValuePair[] pairs = rendererAnnotation.getMemberValuePairs();
        String rendererTypeString = null;
        String componentFamilyString = null;
        String renderKitIDString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("rendererType".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    rendererTypeString = (String)pair.getValue();
                } else if ("componentFamily".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    componentFamilyString = (String)pair.getValue();
                } else if ("renderKitId".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    renderKitIDString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if (rendererClassName != null && rendererTypeString != null && componentFamilyString != null) {
            EList renderKits;
            RendererType renderer = FacesConfigFactory.eINSTANCE.createRendererType();
            RendererClassType rendererClass = FacesConfigFactory.eINSTANCE.createRendererClassType();
            rendererClass.setTextContent(rendererClassName);
            renderer.setRendererClass(rendererClass);
            RendererTypeType rendererTypeType = FacesConfigFactory.eINSTANCE.createRendererTypeType();
            rendererTypeType.setTextContent(rendererTypeString);
            renderer.setRendererType(rendererTypeType);
            ComponentFamilyType componentFamily = FacesConfigFactory.eINSTANCE.createComponentFamilyType();
            componentFamily.setTextContent(componentFamilyString);
            renderer.setComponentFamily(componentFamily);
            if (renderKitIDString == null) {
                renderKitIDString = "HTML_BASIC";
            }
            if ((renderKits = this.facesConfig.getRenderKit()) != null) {
                RenderKitType renderKit = null;
                int i = 0;
                int k = renderKits.size();
                while (i < k) {
                    if (((RenderKitType)renderKits.get(i)).getRenderKitId() != null && renderKitIDString.equals(((RenderKitType)renderKits.get(i)).getRenderKitId().getTextContent())) {
                        renderKit = (RenderKitType)renderKits.get(i);
                    }
                    ++i;
                }
                if (renderKit == null) {
                    renderKit = FacesConfigFactory.eINSTANCE.createRenderKitType();
                    RenderKitIdType renderKitID = FacesConfigFactory.eINSTANCE.createRenderKitIdType();
                    renderKitID.setTextContent(renderKitIDString);
                    renderKit.setRenderKitId(renderKitID);
                    renderKits.add((Object)renderKit);
                }
                renderKit.getRenderer().add((Object)renderer);
            }
        }
    }

    private void addConverter(IAnnotation converterAnnotation, IType converterType) throws JavaModelException {
        String converterClassName = converterType.getFullyQualifiedName();
        IMemberValuePair[] pairs = converterAnnotation.getMemberValuePairs();
        String converterIDString = null;
        String converterForClassString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("value".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    converterIDString = (String)pair.getValue();
                } else if ("forClass".equals(pair.getMemberName()) && pair.getValueKind() == 11) {
                    converterForClassString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if (converterClassName != null) {
            ConverterType converter = FacesConfigFactory.eINSTANCE.createConverterType();
            ConverterClassType converterClass = FacesConfigFactory.eINSTANCE.createConverterClassType();
            converterClass.setTextContent(converterClassName);
            converter.setConverterClass(converterClass);
            if (converterIDString != null) {
                ConverterIdType converterID = FacesConfigFactory.eINSTANCE.createConverterIdType();
                converterID.setTextContent(converterIDString);
                converter.setConverterId(converterID);
            }
            if (converterForClassString == null) {
                converterForClassString = "java.lang.Object";
            }
            ConverterForClassType converterForClass = FacesConfigFactory.eINSTANCE.createConverterForClassType();
            converterForClass.setTextContent(converterForClassString);
            converter.setConverterForClass(converterForClass);
            this.facesConfig.getConverter().add((Object)converter);
        }
    }

    private void addComponent(IAnnotation componentAnnotation, IType componentType) throws JavaModelException {
        String componentClassName = componentType.getFullyQualifiedName();
        IMemberValuePair[] pairs = componentAnnotation.getMemberValuePairs();
        String componentTypeString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("value".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    componentTypeString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if (componentTypeString != null && componentClassName != null) {
            ComponentType component = FacesConfigFactory.eINSTANCE.createComponentType();
            ComponentClassType componentClass = FacesConfigFactory.eINSTANCE.createComponentClassType();
            componentClass.setTextContent(componentClassName);
            component.setComponentClass(componentClass);
            ComponentTypeType componentTypeType = FacesConfigFactory.eINSTANCE.createComponentTypeType();
            componentTypeType.setTextContent(componentTypeString);
            component.setComponentType(componentTypeType);
            this.facesConfig.getComponent().add((Object)component);
        }
    }

    private void addCDINamedBean(IAnnotation beanAnnotation, JDTBeanIntrospector beanIntrospector, IType beanType) throws JavaModelException {
        IMemberValuePair[] pairs = beanAnnotation.getMemberValuePairs();
        String beanNameString = null;
        if (pairs != null) {
            IMemberValuePair[] iMemberValuePairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                if ("value".equals(pair.getMemberName()) && pair.getValueKind() == 9) {
                    beanNameString = (String)pair.getValue();
                }
                ++n2;
            }
        }
        if ((beanNameString == null || beanNameString.length() < 1) && (beanNameString = beanType.getElementName()) != null && beanNameString.length() > 0) {
            StringBuffer casedName = new StringBuffer(String.valueOf(beanNameString.charAt(0)).toLowerCase());
            beanNameString = casedName.append(beanNameString.substring(1)).toString();
        }
        String beanClassName = beanType.getFullyQualifiedName();
        String beanScopeString = this.processCDIScopeAnnotations(beanType, beanIntrospector);
        if (beanNameString != null && beanClassName != null) {
            ManagedBeanType bean = FacesConfigFactory.eINSTANCE.createManagedBeanType();
            ManagedBeanNameType beanName = FacesConfigFactory.eINSTANCE.createManagedBeanNameType();
            beanName.setTextContent(beanNameString);
            bean.setManagedBeanName(beanName);
            ManagedBeanClassType beanClass = FacesConfigFactory.eINSTANCE.createManagedBeanClassType();
            beanClass.setTextContent(beanClassName);
            bean.setManagedBeanClass(beanClass);
            ManagedBeanScopeType beanScope = FacesConfigFactory.eINSTANCE.createManagedBeanScopeType();
            beanScope.setTextContent(beanScopeString);
            bean.setManagedBeanScope(beanScope);
            bean.setEager(false);
            JSFAppConfigUtils.setManagedBeanSource(bean, "CDI_ANNOTATION");
            this.facesConfig.getManagedBean().add((Object)bean);
        }
    }

    private String processCDIScopeAnnotations(IType beanType, JDTBeanIntrospector beanIntrospector) throws JavaModelException {
        String beanScopeString = "dependent";
        IAnnotation[] annotations = beanType.getAnnotations();
        if (annotations == null) {
            return beanScopeString;
        }
        IAnnotation[] iAnnotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String scope = this.processCDIScopeAnnotation(beanType, beanIntrospector, annotation);
            if (scope != null) {
                beanScopeString = scope;
            }
            ++n2;
        }
        return beanScopeString;
    }

    private String processCDIScopeAnnotation(IType beanType, JDTBeanIntrospector beanIntrospector, IAnnotation annotation) {
        if (!annotation.exists()) {
            return null;
        }
        String annotationType = annotation.getElementName();
        if (!this.isCDIScopeAnnotationCandidate(annotationType)) {
            return null;
        }
        String annotationClassName = beanIntrospector.resolveFullQualifiedTypeName(annotationType);
        if (annotationClassName == null) {
            return null;
        }
        if ("javax.enterprise.context.RequestScoped".equals(annotationClassName)) {
            return "request";
        }
        if ("javax.enterprise.context.ConversationScoped".equals(annotationClassName)) {
            return "conversation";
        }
        if ("javax.enterprise.context.SessionScoped".equals(annotationClassName)) {
            return "session";
        }
        if ("javax.enterprise.context.ApplicationScoped".equals(annotationClassName)) {
            return "application";
        }
        return null;
    }

    private boolean isCDIScopeAnnotationCandidate(String annotationType) {
        return CDI_SCOPED_ANNOTATION_CANDIDATES.contains(annotationType);
    }

    private void addCDIModelBean(IType beanType) throws JavaModelException {
        String beanNameString = beanType.getElementName();
        if (beanNameString != null && beanNameString.length() > 0) {
            StringBuffer casedName = new StringBuffer(String.valueOf(beanNameString.charAt(0)).toLowerCase());
            beanNameString = casedName.append(beanNameString.substring(1)).toString();
        }
        String beanClassName = beanType.getFullyQualifiedName();
        String beanScopeString = "request";
        IAnnotation[] annotations = beanType.getAnnotations();
        if (annotations != null) {
            int i = 0;
            int k = annotations.length;
            while (i < k) {
                String annotationType;
                String[][] resolvedAnnotationTypes;
                if (annotations[i].exists() && (resolvedAnnotationTypes = beanType.resolveType(annotationType = annotations[i].getElementName())) != null) {
                    String resolvedAnnotationClassName = new StringBuffer(resolvedAnnotationTypes[0][0]).append('.').append(resolvedAnnotationTypes[0][1]).toString();
                    if ("javax.enterprise.context.ConversationScoped".equals(resolvedAnnotationClassName)) {
                        beanScopeString = "conversation";
                    } else if ("javax.enterprise.context.SessionScoped".equals(resolvedAnnotationClassName)) {
                        beanScopeString = "session";
                    } else if ("javax.enterprise.context.ApplicationScoped".equals(resolvedAnnotationClassName)) {
                        beanScopeString = "application";
                    }
                }
                ++i;
            }
        }
        if (beanNameString != null && beanClassName != null) {
            ManagedBeanType bean = FacesConfigFactory.eINSTANCE.createManagedBeanType();
            ManagedBeanNameType beanName = FacesConfigFactory.eINSTANCE.createManagedBeanNameType();
            beanName.setTextContent(beanNameString);
            bean.setManagedBeanName(beanName);
            ManagedBeanClassType beanClass = FacesConfigFactory.eINSTANCE.createManagedBeanClassType();
            beanClass.setTextContent(beanClassName);
            bean.setManagedBeanClass(beanClass);
            ManagedBeanScopeType beanScope = FacesConfigFactory.eINSTANCE.createManagedBeanScopeType();
            beanScope.setTextContent(beanScopeString);
            bean.setManagedBeanScope(beanScope);
            bean.setEager(false);
            JSFAppConfigUtils.setManagedBeanSource(bean, "CDI_ANNOTATION");
            this.facesConfig.getManagedBean().add((Object)bean);
        }
    }
}

