/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.TypeDeclarationTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.ColumnMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedReferenceTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.AttributeMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.CollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField2_0;
import org.eclipse.jpt.jpa.db.Table;

public final class MappingTools {
    private static final String[] VALID_BASIC_ARRAY_ELEMENT_TYPE_NAMES = new String[]{Byte.TYPE.getName(), Character.TYPE.getName(), Byte.class.getName(), Character.class.getName()};
    private static final String[] BASIC_ARRAY_TYPE_NAMES = new String[]{byte[].class.getSimpleName(), Byte[].class.getSimpleName(), char[].class.getSimpleName(), Character[].class.getSimpleName()};
    private static final String[] OTHER_VALID_BASIC_TYPE_NAMES = new String[]{String.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName()};
    private static final String[] PRIMITIVE_TYPE_NAMES = new String[]{Boolean.TYPE.getName(), Byte.TYPE.getName(), Character.TYPE.getName(), Double.TYPE.getName(), Float.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Short.TYPE.getName()};
    private static final String[] PRIMITIVE_WRAPPER_TYPE_NAMES = new String[]{Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName()};
    private static final String[] COLLECTION_TYPE_NAMES = new String[]{Collection.class.getName(), List.class.getName(), Map.class.getName(), Set.class.getName()};

    public static boolean typeIsBasic(IJavaProject javaProject, String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return false;
        }
        int arrayDepth = TypeDeclarationTools.arrayDepth((String)fullyQualifiedName);
        if (arrayDepth > 1) {
            return false;
        }
        if (arrayDepth == 1) {
            String elementTypeName = TypeDeclarationTools.elementTypeName((String)fullyQualifiedName, (int)1);
            return MappingTools.elementTypeIsValidForBasicArray(elementTypeName);
        }
        if (ClassNameTools.isVariablePrimitive((String)fullyQualifiedName)) {
            return true;
        }
        if (ClassNameTools.isVariablePrimitiveWrapper((String)fullyQualifiedName)) {
            return true;
        }
        if (MappingTools.typeIsOtherValidBasicType(fullyQualifiedName)) {
            return true;
        }
        IType type = JavaProjectTools.findType((IJavaProject)javaProject, (String)fullyQualifiedName);
        if (type == null) {
            return false;
        }
        if (TypeTools.isSerializable((IType)type)) {
            return true;
        }
        return TypeTools.isEnum((IType)type);
    }

    public static boolean elementTypeIsValidForBasicArray(String elementTypeName) {
        return ArrayTools.contains((Object[])VALID_BASIC_ARRAY_ELEMENT_TYPE_NAMES, (Object)elementTypeName);
    }

    public static boolean typeIsOtherValidBasicType(String typeName) {
        return ArrayTools.contains((Object[])OTHER_VALID_BASIC_TYPE_NAMES, (Object)typeName);
    }

    public static String buildJoinTableDefaultName(Relationship relationship) {
        if (relationship.getJpaProject().getDataSource().connectionProfileIsActive()) {
            return MappingTools.buildDbJoinTableDefaultName(relationship);
        }
        String owningTableName = relationship.getTypeMapping().getPrimaryTableName();
        if (owningTableName == null) {
            return null;
        }
        RelationshipMapping relationshipMapping = relationship.getMapping();
        if (relationshipMapping == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        String targetTableName = targetEntity.getPrimaryTableName();
        if (targetTableName == null) {
            return null;
        }
        return owningTableName + "_" + targetTableName;
    }

    private static String buildDbJoinTableDefaultName(Relationship relationship) {
        Table owningTable = relationship.getTypeMapping().getPrimaryDbTable();
        if (owningTable == null) {
            return null;
        }
        RelationshipMapping relationshipMapping = relationship.getMapping();
        if (relationshipMapping == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        Table targetTable = targetEntity.getPrimaryDbTable();
        if (targetTable == null) {
            return null;
        }
        String name = owningTable.getName() + "_" + targetTable.getName();
        return owningTable.getDatabase().convertNameToIdentifier(name);
    }

    public static String buildCollectionTableDefaultName(ElementCollectionMapping2_0 mapping) {
        Entity entity = mapping.getEntity();
        if (entity == null) {
            return null;
        }
        String owningEntityName = entity.getName();
        String attributeName = mapping.getName();
        return owningEntityName + "_" + attributeName;
    }

    public static String buildJoinColumnDefaultName(JoinColumn joinColumn, JoinColumn.ParentAdapter parentAdapter) {
        String targetColumnName;
        if (parentAdapter.getJoinColumnsSize() != 1) {
            return null;
        }
        String prefix = parentAdapter.getAttributeName();
        if (prefix == null) {
            Entity targetEntity = parentAdapter.getRelationshipTarget();
            if (targetEntity == null) {
                return null;
            }
            prefix = targetEntity.getName();
        }
        if ((targetColumnName = joinColumn.getReferencedColumnName()) == null) {
            return null;
        }
        String name = prefix + "_" + targetColumnName;
        return name;
    }

    public static String getTargetAttributeName(RelationshipMapping relationshipMapping) {
        if (relationshipMapping == null) {
            return null;
        }
        Entity targetEntity = relationshipMapping.getResolvedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        for (PersistentAttribute attribute : targetEntity.getPersistentType().getAllAttributes()) {
            if (!attribute.getMapping().isOwnedBy(relationshipMapping)) continue;
            return attribute.getName();
        }
        return null;
    }

    public static String buildJoinColumnDefaultReferencedColumnName(JoinColumn.ParentAdapter joinColumnParentAdapter) {
        if (joinColumnParentAdapter.getJoinColumnsSize() != 1) {
            return null;
        }
        Entity targetEntity = joinColumnParentAdapter.getRelationshipTarget();
        if (targetEntity == null) {
            return null;
        }
        return targetEntity.getPrimaryKeyColumnName();
    }

    public static ColumnMapping getColumnMapping(String attributeName, PersistentType persistentType) {
        if (attributeName == null || persistentType == null) {
            return null;
        }
        for (PersistentAttribute persAttribute : persistentType.getAllAttributes()) {
            if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof ColumnMapping)) continue;
            return (ColumnMapping)persAttribute.getMapping();
        }
        return null;
    }

    public static RelationshipMapping getRelationshipMapping(String attributeName, TypeMapping typeMapping) {
        if (attributeName == null || typeMapping == null) {
            return null;
        }
        for (AttributeMapping attributeMapping : typeMapping.getAllAttributeMappings()) {
            if (!attributeName.equals(attributeMapping.getName()) || !(attributeMapping instanceof RelationshipMapping)) continue;
            return (RelationshipMapping)attributeMapping;
        }
        return null;
    }

    public static void convertReferenceTableDefaultToSpecifiedJoinColumn(SpecifiedReferenceTable referenceTable) {
        SpecifiedJoinColumn defaultJoinColumn = referenceTable.getDefaultJoinColumn();
        if (defaultJoinColumn != null) {
            String columnName = defaultJoinColumn.getDefaultName();
            String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
            SpecifiedJoinColumn joinColumn = referenceTable.addSpecifiedJoinColumn();
            joinColumn.setSpecifiedName(columnName);
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    public static void convertJoinTableDefaultToSpecifiedInverseJoinColumn(SpecifiedJoinTable joinTable) {
        SpecifiedJoinColumn defaultInverseJoinColumn = joinTable.getDefaultInverseJoinColumn();
        if (defaultInverseJoinColumn != null) {
            String columnName = defaultInverseJoinColumn.getDefaultName();
            String referencedColumnName = defaultInverseJoinColumn.getDefaultReferencedColumnName();
            SpecifiedJoinColumn joinColumn = joinTable.addSpecifiedInverseJoinColumn(0);
            joinColumn.setSpecifiedName(columnName);
            joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    public static String getMetamodelFieldMapKeyTypeName(CollectionMapping2_0 mapping) {
        PersistentType targetType = mapping.getResolvedTargetType();
        String mapKey = mapping.getMapKey();
        if (mapKey == null || targetType == null) {
            String mapKeyClass = mapping.getFullyQualifiedMapKeyClass();
            return mapKeyClass != null ? mapKeyClass : MetamodelField2_0.DEFAULT_TYPE_NAME;
        }
        PersistentAttribute mapKeyAttribute = targetType.resolveAttribute(mapKey);
        if (mapKeyAttribute == null) {
            return MetamodelField2_0.DEFAULT_TYPE_NAME;
        }
        AttributeMapping2_0 mapKeyMapping = (AttributeMapping2_0)mapKeyAttribute.getMapping();
        if (mapKeyMapping == null) {
            return MetamodelField2_0.DEFAULT_TYPE_NAME;
        }
        return mapKeyMapping.getMetamodelTypeName();
    }

    public static SpecifiedColumn resolveOverriddenColumn(TypeMapping overridableTypeMapping, String attributeName) {
        if (overridableTypeMapping == null) {
            return null;
        }
        for (TypeMapping typeMapping : overridableTypeMapping.getInheritanceHierarchy()) {
            SpecifiedColumn column = typeMapping.resolveOverriddenColumn(attributeName);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    public static SpecifiedRelationship resolveOverriddenRelationship(TypeMapping overridableTypeMapping, String attributeName) {
        if (overridableTypeMapping == null) {
            return null;
        }
        for (TypeMapping typeMapping : overridableTypeMapping.getInheritanceHierarchy()) {
            SpecifiedRelationship relationship = typeMapping.resolveOverriddenRelationship(attributeName);
            if (relationship == null) continue;
            return relationship;
        }
        return null;
    }

    public static String getPrimaryKeyColumnName(Entity entity) {
        String pkColumnName = null;
        for (PersistentAttribute attribute : entity.getPersistentType().getAllAttributes()) {
            AttributeOverride attributeOverride;
            String current = attribute.getPrimaryKeyColumnName();
            if (current != null && (attributeOverride = entity.getAttributeOverrideContainer().getOverrideNamed(attribute.getName())) != null) {
                current = attributeOverride.getColumn().getName();
            }
            if (pkColumnName == null) {
                pkColumnName = current;
                continue;
            }
            if (current == null) continue;
            return null;
        }
        return pkColumnName;
    }

    public static String unqualify(String mappingName, String attributeName) {
        if (mappingName == null) {
            return null;
        }
        if (!attributeName.startsWith(mappingName)) {
            return null;
        }
        int mappingNameLength = mappingName.length();
        if (attributeName.length() <= mappingNameLength) {
            return null;
        }
        return attributeName.charAt(mappingNameLength) == '.' ? attributeName.substring(mappingNameLength + 1) : null;
    }

    public static boolean modelIsInternalSource(JpaContextModel contextModel, JavaResourceModel resourceModel) {
        IResource resource = contextModel.getResource();
        return resource != null && resource.getProject().equals((Object)contextModel.getJpaProject().getProject()) && resourceModel instanceof SourceModel;
    }

    public static Iterable<String> getBasicArrayTypeNames() {
        return ListTools.arrayList((Object[])BASIC_ARRAY_TYPE_NAMES);
    }

    public static Iterable<String> getPrimaryBasicTypeNamesWithoutPrimitives() {
        ArrayList<String> names = new ArrayList<String>();
        CollectionTools.addAll(names, (Object[])PRIMITIVE_WRAPPER_TYPE_NAMES);
        CollectionTools.addAll(names, (Object[])OTHER_VALID_BASIC_TYPE_NAMES);
        return names;
    }

    public static Iterable<String> getPrimaryBasicTypeNames() {
        ArrayList<String> names = new ArrayList<String>();
        CollectionTools.addAll(names, (Object[])PRIMITIVE_TYPE_NAMES);
        CollectionTools.addAll(names, (Object[])PRIMITIVE_WRAPPER_TYPE_NAMES);
        CollectionTools.addAll(names, (Object[])OTHER_VALID_BASIC_TYPE_NAMES);
        return names;
    }

    public static Iterable<String> getAllBasicTypeNames() {
        ArrayList<String> names = new ArrayList<String>();
        CollectionTools.addAll(names, MappingTools.getPrimaryBasicTypeNames());
        CollectionTools.addAll(names, (Object[])BASIC_ARRAY_TYPE_NAMES);
        names.add(Enum.class.getSimpleName());
        return names;
    }

    public static Iterable<String> getCollectionTypeNames() {
        ArrayList<String> names = new ArrayList<String>();
        CollectionTools.addAll(names, (Object[])COLLECTION_TYPE_NAMES);
        return names;
    }

    private MappingTools() {
        throw new UnsupportedOperationException();
    }

    public static class QualifierTransformer
    extends TransformerAdapter<String, String> {
        private final String prefix;

        public QualifierTransformer(String qualifier) {
            this.prefix = qualifier == null ? "." : qualifier + ".";
        }

        public String transform(String s) {
            return this.prefix + s;
        }
    }
}

