/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.tests.internal.platforms;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.db.tests.internal.platforms.DTPPlatformTests;

public class Oracle10gTests
extends DTPPlatformTests {
    private static final String CR = System.getProperty("line.separator");

    public Oracle10gTests(String name) {
        super(name);
    }

    @Override
    protected String getPlatformPropertiesFileName() {
        return "oracle10g.properties";
    }

    @Override
    protected String getDriverName() {
        return "Oracle 10g Thin Driver";
    }

    @Override
    protected String getDriverDefinitionID() {
        return "DriverDefn.Oracle Thin Driver";
    }

    @Override
    protected String getDriverDefinitionType() {
        return "org.eclipse.datatools.enablement.oracle.10.driverTemplate";
    }

    @Override
    protected String getDatabaseVendor() {
        return "Oracle";
    }

    @Override
    protected String getDatabaseVersion() {
        return "10";
    }

    @Override
    protected String getDriverClass() {
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    protected String getProfileName() {
        return "Oracle10g_10.1.0.4";
    }

    @Override
    protected String getProfileDescription() {
        return "Oracle10g (10.1.0.4) JDBC Profile [Test]";
    }

    @Override
    protected boolean supportsCatalogs() {
        return false;
    }

    @Override
    protected boolean executeOfflineTests() {
        return false;
    }

    public void testDatabase() throws Exception {
        if (this.connectionProfile.getUserName().toUpperCase().equals("SYS")) {
            System.out.println("skipped test: " + ((Object)((Object)this)).getClass() + '.' + this.getName());
            return;
        }
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        Schema schema = this.getDatabase().getSchemaForIdentifier(this.getUserID());
        Oracle10gTests.assertNotNull((Object)schema);
        Oracle10gTests.assertSame((Object)this.getDefaultSchema(), (Object)schema);
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testTable() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropTable("foo_baz");
        this.dropTable("baz");
        this.dropTable("foo");
        this.dropTable("bar");
        this.executeUpdate(this.buildBarDDL());
        this.executeUpdate(this.buildFooDDL());
        this.executeUpdate(this.buildBazDDL());
        this.executeUpdate(this.buildFooBazDDL());
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema = this.getDefaultSchema();
        Table fooTable = schema.getTableForIdentifier("foo");
        Oracle10gTests.assertEquals((int)3, (int)fooTable.getColumnsSize());
        Oracle10gTests.assertEquals((int)1, (int)fooTable.getPrimaryKeyColumnsSize());
        Oracle10gTests.assertEquals((int)1, (int)fooTable.getForeignKeysSize());
        Column pkColumn = fooTable.getPrimaryKeyColumn();
        Oracle10gTests.assertEquals((String)"ID", (String)pkColumn.getName());
        Column idColumn = fooTable.getColumnForIdentifier("id");
        Oracle10gTests.assertSame((Object)pkColumn, (Object)idColumn);
        Oracle10gTests.assertEquals((String)"NUMBER", (String)idColumn.getDataTypeName());
        Oracle10gTests.assertSame((Object)fooTable, (Object)idColumn.getTable());
        Oracle10gTests.assertTrue((boolean)idColumn.isPartOfPrimaryKey());
        Oracle10gTests.assertFalse((boolean)idColumn.isPartOfForeignKey());
        Oracle10gTests.assertEquals((String)"java.math.BigDecimal", (String)idColumn.getJavaTypeDeclaration());
        Column nameColumn = fooTable.getColumnForIdentifier("name");
        Oracle10gTests.assertEquals((String)"VARCHAR2", (String)nameColumn.getDataTypeName());
        Oracle10gTests.assertEquals((String)"java.lang.String", (String)nameColumn.getJavaTypeDeclaration());
        Oracle10gTests.assertFalse((boolean)nameColumn.isPartOfPrimaryKey());
        Column barColumn = fooTable.getColumnForIdentifier("bar_id");
        Oracle10gTests.assertEquals((String)"NUMBER", (String)barColumn.getDataTypeName());
        Oracle10gTests.assertTrue((boolean)barColumn.isPartOfForeignKey());
        Oracle10gTests.assertFalse((boolean)barColumn.isPartOfPrimaryKey());
        ForeignKey barFK = (ForeignKey)fooTable.getForeignKeys().iterator().next();
        Oracle10gTests.assertEquals((int)1, (int)barFK.getColumnPairsSize());
        Oracle10gTests.assertEquals((String)"BAR", (String)barFK.getAttributeName());
        Oracle10gTests.assertNull((Object)barFK.getJoinColumnAnnotationIdentifier("bar"));
        Oracle10gTests.assertEquals((String)"BAR_ID", (String)barFK.getJoinColumnAnnotationIdentifier("primaryBar"));
        Oracle10gTests.assertSame((Object)fooTable, (Object)barFK.getBaseTable());
        Oracle10gTests.assertFalse((boolean)fooTable.isPossibleJoinTable());
        Oracle10gTests.assertSame((Object)schema, (Object)fooTable.getSchema());
        Table barTable = schema.getTableForIdentifier("bar");
        Oracle10gTests.assertEquals((int)2, (int)barTable.getColumnsSize());
        Oracle10gTests.assertEquals((int)1, (int)barTable.getPrimaryKeyColumnsSize());
        Oracle10gTests.assertEquals((int)0, (int)barTable.getForeignKeysSize());
        Oracle10gTests.assertEquals((String)"ID", (String)barTable.getPrimaryKeyColumn().getName());
        Oracle10gTests.assertFalse((boolean)barTable.isPossibleJoinTable());
        Oracle10gTests.assertEquals((String)"BLOB", (String)barTable.getColumnForIdentifier("chunk").getDataTypeName());
        Oracle10gTests.assertEquals((String)"byte[]", (String)barTable.getColumnForIdentifier("chunk").getJavaTypeDeclaration());
        Oracle10gTests.assertTrue((boolean)barTable.getColumnForIdentifier("chunk").isLOB());
        Oracle10gTests.assertSame((Object)barTable, (Object)barFK.getReferencedTable());
        Table foo_bazTable = schema.getTableForIdentifier("foo_baz");
        Oracle10gTests.assertEquals((int)2, (int)foo_bazTable.getColumnsSize());
        Oracle10gTests.assertEquals((int)0, (int)foo_bazTable.getPrimaryKeyColumnsSize());
        Oracle10gTests.assertEquals((int)2, (int)foo_bazTable.getForeignKeysSize());
        Oracle10gTests.assertTrue((boolean)foo_bazTable.isPossibleJoinTable());
        Oracle10gTests.assertTrue((boolean)foo_bazTable.joinTableNameIsDefault());
        Oracle10gTests.assertTrue((boolean)foo_bazTable.getColumnForIdentifier("foo_id").isPartOfForeignKey());
        this.dropTable("foo_baz");
        this.dropTable("baz");
        this.dropTable("foo");
        this.dropTable("bar");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    private String buildBarDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE bar (").append(CR);
        sb.append("    id NUMBER(10) PRIMARY KEY,").append(CR);
        sb.append("    chunk BLOB").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildFooDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE foo (").append(CR);
        sb.append("    id NUMBER(10) PRIMARY KEY,").append(CR);
        sb.append("    name VARCHAR2(20),").append(CR);
        sb.append("    bar_id REFERENCES bar(id)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildBazDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE baz (").append(CR);
        sb.append("    id NUMBER(10) PRIMARY KEY,").append(CR);
        sb.append("    name VARCHAR2(20)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    private String buildFooBazDDL() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("CREATE TABLE foo_baz (").append(CR);
        sb.append("    foo_id NUMBER(10) REFERENCES foo(id),").append(CR);
        sb.append("    baz_id NUMBER(10) REFERENCES baz(id)").append(CR);
        sb.append(")").append(CR);
        return sb.toString();
    }

    public void testTableLookup() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropTable("test1");
        this.dropTable("TEST2");
        this.dropTable("\"test3\"");
        this.executeUpdate("CREATE TABLE test1 (id NUMBER(10), name VARCHAR2(20))");
        this.executeUpdate("CREATE TABLE TEST2 (id NUMBER(10), name VARCHAR2(20))");
        this.executeUpdate("CREATE TABLE \"test3\" (id NUMBER(10), name VARCHAR2(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema = this.getDefaultSchema();
        Table test1Table = schema.getTableForIdentifier("test1");
        Oracle10gTests.assertNotNull((Object)test1Table);
        test1Table = schema.getTableForIdentifier("TEST1");
        Oracle10gTests.assertNotNull((Object)test1Table);
        Table test2Table = schema.getTableForIdentifier("test2");
        Oracle10gTests.assertNotNull((Object)test2Table);
        test2Table = schema.getTableForIdentifier("TEST2");
        Oracle10gTests.assertNotNull((Object)test2Table);
        Table test3Table = schema.getTableForIdentifier("\"test3\"");
        Oracle10gTests.assertNotNull((Object)test3Table);
        test3Table = schema.getTableForIdentifier("test3");
        Oracle10gTests.assertNull((Object)test3Table);
        this.dropTable("test1");
        this.dropTable("TEST2");
        this.dropTable("\"test3\"");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testColumnLookup() throws Exception {
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.dropTable("test");
        this.executeUpdate("CREATE TABLE test (id NUMBER(10), name VARCHAR2(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Table table = this.getDefaultSchema().getTableForIdentifier("test");
        Oracle10gTests.assertNotNull((Object)table.getColumnForIdentifier("id"));
        Oracle10gTests.assertNotNull((Object)table.getColumnForIdentifier("name"));
        this.dropTable("test");
        this.executeUpdate("CREATE TABLE test (ID NUMBER(10), NAME VARCHAR2(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDefaultSchema().getTableForIdentifier("test");
        Oracle10gTests.assertNotNull((Object)table.getColumnForIdentifier("ID"));
        Oracle10gTests.assertNotNull((Object)table.getColumnForIdentifier("NAME"));
        this.dropTable("test");
        this.executeUpdate("CREATE TABLE test (Id NUMBER(10), Name VARCHAR2(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDefaultSchema().getTableForIdentifier("test");
        Oracle10gTests.assertNotNull((Object)table.getColumnForIdentifier("Id"));
        Oracle10gTests.assertNotNull((Object)table.getColumnForIdentifier("Name"));
        this.dropTable("test");
        this.executeUpdate("CREATE TABLE test (\"Id\" NUMBER(10), \"Name\" VARCHAR2(20))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        table = this.getDefaultSchema().getTableForIdentifier("test");
        Oracle10gTests.assertNotNull((Object)table.getColumnForIdentifier("\"Id\""));
        Oracle10gTests.assertNotNull((Object)table.getColumnForIdentifier("\"Name\""));
        this.dropTable("test");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testCrossSchemaReference() throws Exception {
        if (!this.connectionProfile.getUserName().toUpperCase().equals("SYS")) {
            System.out.println("skipped test: " + ((Object)((Object)this)).getClass() + '.' + this.getName());
            return;
        }
        this.connectionProfile.connect();
        DTPPlatformTests.TestConnectionListener listener = new DTPPlatformTests.TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.executeUpdateIgnoreErrors("DROP USER XREF_TEST2 CASCADE");
        this.executeUpdateIgnoreErrors("DROP USER XREF_TEST1 CASCADE");
        this.executeUpdate("CREATE USER XREF_TEST1 IDENTIFIED BY foo");
        this.executeUpdate("ALTER USER XREF_TEST1 QUOTA UNLIMITED ON USERS");
        this.executeUpdate("CREATE TABLE XREF_TEST1.ORG (ID NUMBER(10) PRIMARY KEY, NAME VARCHAR2(20))");
        this.executeUpdate("CREATE USER XREF_TEST2 IDENTIFIED BY foo");
        this.executeUpdate("ALTER USER XREF_TEST2 QUOTA UNLIMITED ON USERS");
        this.executeUpdate("GRANT ALL ON XREF_TEST1.ORG TO XREF_TEST2");
        this.executeUpdate("CREATE TABLE XREF_TEST2.EMP (ID NUMBER(10) PRIMARY KEY, NAME VARCHAR2(20), ORG_ID NUMBER(10) REFERENCES XREF_TEST1.ORG(ID))");
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        Schema schema1 = this.getDatabase().getSchemaNamed("XREF_TEST1");
        Oracle10gTests.assertNotNull((Object)schema1);
        Table orgTable = schema1.getTableNamed("ORG");
        Oracle10gTests.assertNotNull((Object)orgTable);
        Schema schema2 = this.getDatabase().getSchemaNamed("XREF_TEST2");
        Oracle10gTests.assertNotNull((Object)schema2);
        Table empTable = schema2.getTableNamed("EMP");
        Oracle10gTests.assertNotNull((Object)empTable);
        Oracle10gTests.assertEquals((int)1, (int)empTable.getForeignKeysSize());
        ForeignKey fk = (ForeignKey)empTable.getForeignKeys().iterator().next();
        Table refTable = fk.getReferencedTable();
        Oracle10gTests.assertNotNull((Object)refTable);
        Oracle10gTests.assertEquals((String)"ORG", (String)refTable.getName());
        Oracle10gTests.assertEquals((int)1, (int)fk.getColumnPairsSize());
        ForeignKey.ColumnPair cp = (ForeignKey.ColumnPair)fk.getColumnPairs().iterator().next();
        Column baseColumn = cp.getBaseColumn();
        Oracle10gTests.assertEquals((String)"ORG_ID", (String)baseColumn.getName());
        Column refColumn = cp.getReferencedColumn();
        Oracle10gTests.assertEquals((String)"ID", (String)refColumn.getName());
        this.executeUpdate("DROP USER XREF_TEST2 CASCADE");
        this.executeUpdate("DROP USER XREF_TEST1 CASCADE");
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    private void dropTable(String tableName) throws Exception {
        this.executeUpdateIgnoreErrors("DROP TABLE " + tableName + " CASCADE CONSTRAINTS");
    }

    protected void dumpUserObjects() throws Exception {
        this.dump("select * from user_objects");
    }
}

