/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.formatter.comment;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.ToolFactory;

public class CommentFormatterUtil {
    public static String format(int kind, String source, int offset, int length, Map preferences) {
        Assert.isNotNull((Object)source);
        Document document = new Document(source);
        try {
            int indentOffset = document.getLineOffset(document.getLineOfOffset(offset));
            int indentationLevel = CommentFormatterUtil.inferIndentationLevel(document.get(indentOffset, offset - indentOffset), CommentFormatterUtil.getTabSize(preferences));
            return CommentFormatterUtil.format(kind, source, offset, length, indentationLevel, preferences);
        }
        catch (BadLocationException x) {
            throw new RuntimeException(x);
        }
    }

    public static String format(int kind, String source, int offset, int length, int indentationLevel, Map preferences) {
        Assert.isTrue((kind == 64 || kind == 32 || kind == 16 ? 1 : 0) != 0);
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)preferences);
        Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((length <= source.length() ? 1 : 0) != 0);
        Document document = new Document(source);
        TextEdit edit = ToolFactory.createCodeFormatter((Map)preferences).format(kind, source, offset, length, indentationLevel, TextUtilities.getDefaultLineDelimiter((IDocument)document));
        try {
            if (edit != null) {
                edit.apply((IDocument)document);
            }
        }
        catch (MalformedTreeException x) {
            throw new RuntimeException(x);
        }
        catch (BadLocationException x) {
            throw new RuntimeException(x);
        }
        return document.get();
    }

    private static int inferIndentationLevel(String reference, int tabSize) {
        StringBuffer expanded = CommentFormatterUtil.expandTabs(reference, tabSize);
        int spaceWidth = 1;
        int referenceWidth = expanded.length();
        int level = referenceWidth / (tabSize * spaceWidth);
        if (referenceWidth % (tabSize * spaceWidth) > 0) {
            ++level;
        }
        return level;
    }

    private static StringBuffer expandTabs(String string, int tabSize) {
        StringBuffer expanded = new StringBuffer();
        int i = 0;
        int n = string.length();
        int chars = 0;
        while (i < n) {
            char ch = string.charAt(i);
            if (ch == '\t') {
                while (chars < tabSize) {
                    expanded.append(' ');
                    ++chars;
                }
                chars = 0;
            } else {
                expanded.append(ch);
                if (++chars >= tabSize) {
                    chars = 0;
                }
            }
            ++i;
        }
        return expanded;
    }

    private static int getTabSize(Map preferences) {
        if (preferences.containsKey("org.eclipse.wst.jsdt.core.formatter.tabulation.size")) {
            try {
                return Integer.parseInt((String)preferences.get("org.eclipse.wst.jsdt.core.formatter.tabulation.size"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 4;
    }

    public static Map createOptions(Map user) {
        Hashtable map = JavaScriptCore.getOptions();
        if (user != null) {
            for (Object key : user.keySet()) {
                Object value = user.get(key);
                map.put(key, value);
            }
        }
        return map;
    }
}

