/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.internal.core.runtime.JSRuntimeTypeRegistryReader;
import org.junit.Assert;
import org.junit.Test;

public class JSRuntimeTypeRegistryReaderTest {
    private static final String RUNTIME_TYPE_1 = "js.runtime.test.type";
    private static final String RUNTIME_TYPE_2 = "js.runtime.test.type.2";
    private static final String RUNTIME_TYPE_NAME_1 = "jsruntimetesttype";
    private static final String RUNTIME_TYPE_NAME_2 = "jsruntimetesttype2";

    private Set<String> getExpectedRuntimeTypesIds() {
        HashSet<String> s = new HashSet<String>();
        s.add(RUNTIME_TYPE_1);
        s.add(RUNTIME_TYPE_2);
        return s;
    }

    @Test
    public void test_01_RegistryReaderGetRuntimeTypes() {
        Collection runtimeTypes = JSRuntimeTypeRegistryReader.getJSRuntimeTypes();
        Set<String> expectedRuntimeTypesIds = this.getExpectedRuntimeTypesIds();
        for (IJSRuntimeType runtimeType : runtimeTypes) {
            if (runtimeType.getId().equals(RUNTIME_TYPE_1)) {
                Assert.assertEquals((Object)RUNTIME_TYPE_NAME_1, (Object)runtimeType.getName());
            } else {
                if (!runtimeType.getId().equals(RUNTIME_TYPE_2)) continue;
                Assert.assertEquals((Object)RUNTIME_TYPE_NAME_2, (Object)runtimeType.getName());
            }
            expectedRuntimeTypesIds.remove(runtimeType.getId());
        }
        Assert.assertEquals((long)0L, (long)expectedRuntimeTypesIds.size());
    }

    @Test
    public void test_02_RegistryReaderGetExistingRuntimeById() {
        IJSRuntimeType runtimeType = JSRuntimeTypeRegistryReader.getJSRuntimeType((String)RUNTIME_TYPE_1);
        Assert.assertNotNull((Object)runtimeType);
        Assert.assertEquals((Object)RUNTIME_TYPE_NAME_1, (Object)runtimeType.getName());
        runtimeType = JSRuntimeTypeRegistryReader.getJSRuntimeType((String)RUNTIME_TYPE_2);
        Assert.assertNotNull((Object)runtimeType);
        Assert.assertEquals((Object)RUNTIME_TYPE_NAME_2, (Object)runtimeType.getName());
    }

    @Test
    public void test_03_RegistryReaderGetUnexistingRuntimeById() {
        IJSRuntimeType runtimeType = JSRuntimeTypeRegistryReader.getJSRuntimeType((String)"Unexisting runtime");
        Assert.assertNull((Object)runtimeType);
    }

    @Test
    public void test_04_RegistryReaderGetUnexistingRuntimeById() {
        Collection runtimeTypeIds = JSRuntimeTypeRegistryReader.getJSRuntimeTypesIds();
        Set<String> expectedRuntimeTypesIds = this.getExpectedRuntimeTypesIds();
        Assert.assertTrue((boolean)runtimeTypeIds.containsAll(expectedRuntimeTypesIds));
    }
}

