/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.AbstractCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class StyleSheetFormatter
extends AbstractCSSSourceFormatter {
    private static StyleSheetFormatter instance;

    StyleSheetFormatter() {
    }

    @Override
    protected void formatBefore(ICSSNode node, ICSSNode child, String toAppend, StringBuffer source, IRegion exceptFor) {
        int end;
        ICSSNode prev;
        String delim = this.getLineDelimiter(node);
        ICSSNode iCSSNode = prev = child != null ? child.getPreviousSibling() : node.getLastChild();
        if (prev == null && child == null) {
            return;
        }
        int start = prev != null ? ((IndexedRegion)prev).getEndOffset() : 0;
        int n = end = child != null ? ((IndexedRegion)child).getStartOffset() : 0;
        if (start > 0 && start < end) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = null;
            if (exceptFor == null) {
                regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            } else {
                String pickupType = "DELIMITER";
                if (prev == null) {
                    pickupType = null;
                }
                regions = this.getRegions(structuredDocument, new FormatRegion(start, end - start), exceptFor, pickupType);
            }
            if (prev != null) {
                if (regions.length > 0 && !regions[0].getType().equals("COMMENT")) {
                    this.appendDelimBefore(node, regions[0], source);
                } else if (regions.length == 0) {
                    this.appendDelimBefore(node, null, source);
                }
            }
            int i = 0;
            while (i < regions.length) {
                this.appendDelimBefore(node, regions[i], source);
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                if (regions[i].getType() == "DELIMITER") {
                    this.appendDelimBefore(node, null, source);
                }
                ++i;
            }
            if (prev != null) {
                this.appendDelimBefore(node, null, source);
            }
        } else if (prev != null && child != null) {
            source.append(delim);
            source.append(delim);
        } else if (((IndexedRegion)node).getEndOffset() > 0) {
            if (prev == null) {
                IStructuredDocument structuredDocument;
                CompoundRegion[] prevRegions;
                ICSSNode next = child.getNextSibling();
                int pos = this.getChildInsertPos(node);
                if (next != null && ((IndexedRegion)next).getEndOffset() > 0) {
                    pos = ((IndexedRegion)next).getStartOffset();
                }
                if (pos != 0 && (prevRegions = this.getRegions(structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument(), new FormatRegion(0, pos), null, null)) != null && prevRegions.length > 0) {
                    this.appendDelimBefore(node, null, source);
                }
            } else if (child == null) {
                int pos;
                if (start > 0 && start <= ((IndexedRegion)node).getEndOffset()) {
                    this.appendDelimBefore(node, null, source);
                } else if (start <= 0 && (pos = this.getChildInsertPos(node)) < ((IndexedRegion)node).getEndOffset()) {
                    this.appendDelimBefore(node, null, source);
                }
            }
        }
    }

    @Override
    protected void formatBefore(ICSSNode node, ICSSNode child, IRegion region, String toAppend, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || StyleSheetFormatter.needS(outside[0])) {
                this.appendDelimBefore(node, regions[i], source);
            }
            source.append(this.decoratedRegion(regions[i], 0, stgy));
            ++i;
        }
        if (StyleSheetFormatter.needS(outside[1]) && ((IndexedRegion)child).getStartOffset() == region.getOffset() + region.getLength()) {
            this.appendDelimBefore(node, null, source);
        }
    }

    @Override
    protected void formatPost(ICSSNode node, StringBuffer source) {
        int start;
        int end = ((IndexedRegion)node).getEndOffset();
        int n = start = node.getLastChild() != null && ((IndexedRegion)node.getLastChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getLastChild()).getEndOffset() : this.getChildInsertPos(node);
        if (end > 0 && start < end) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                this.appendDelimBefore(node, regions[i], source);
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
            if (regions != null && regions.length > 0 && regions[regions.length - 1].getType() == "CDC" || node.getOwnerDocument().getModel().getStyleSheetType() == "embeddedCSS") {
                this.appendDelimBefore(node, null, source);
            }
        } else {
            if (node.getOwnerDocument().getModel() != null && node.getOwnerDocument().getModel().getStyleSheetType() == "embeddedCSS") {
                this.appendDelimBefore(node, null, source);
            }
            return;
        }
    }

    @Override
    protected void formatPost(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || StyleSheetFormatter.needS(outside[0])) {
                this.appendDelimBefore(node, regions[i], source);
            }
            source.append(this.decoratedRegion(regions[i], 0, stgy));
            ++i;
        }
    }

    @Override
    protected void formatPre(ICSSNode node, StringBuffer source) {
        int end;
        int start = ((IndexedRegion)node).getStartOffset();
        int n = end = node.getFirstChild() != null && ((IndexedRegion)node.getFirstChild()).getEndOffset() > 0 ? ((IndexedRegion)node.getFirstChild()).getStartOffset() : this.getChildInsertPos(node);
        if (end > 0) {
            CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                if (i != 0 || regions[i].getType() == "CDO" || node.getOwnerDocument().getModel().getStyleSheetType() == "embeddedCSS") {
                    this.appendDelimBefore(node, regions[i], source);
                }
                source.append(this.decoratedRegion(regions[i], 0, stgy));
                ++i;
            }
            if (node.getLastChild() != null && (source.length() > 0 || node.getOwnerDocument().getModel().getStyleSheetType() == "embeddedCSS")) {
                this.appendDelimBefore(node, null, source);
            }
        } else if (node.getOwnerDocument().getModel() != null && node.getOwnerDocument().getModel().getStyleSheetType() == "embeddedCSS") {
            this.appendDelimBefore(node, null, source);
        } else {
            return;
        }
    }

    @Override
    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || StyleSheetFormatter.needS(outside[0]) || regions[i].getType() == "CDO" || node.getOwnerDocument().getModel().getStyleSheetType() == "embeddedCSS") {
                this.appendDelimBefore(node, regions[i], source);
            }
            source.append(this.decoratedRegion(regions[i], 0, stgy));
            ++i;
        }
        if (StyleSheetFormatter.needS(outside[1]) && this.isIncludesPreEnd(node, region) && (source.length() > 0 || node.getOwnerDocument().getModel().getStyleSheetType() == "embeddedCSS")) {
            String delim = this.getLineDelimiter(node);
            source.append(delim);
        }
    }

    @Override
    public int getChildInsertPos(ICSSNode node) {
        int n = ((IndexedRegion)node).getEndOffset();
        if (n > 0) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            IStructuredDocumentRegion flatNode = structuredDocument.getRegionAtCharacterOffset(n - 1);
            ITextRegion region = flatNode.getRegionAtCharacterOffset(n - 1);
            RegionIterator it = new RegionIterator(flatNode, region);
            while (it.hasPrev()) {
                ITextRegion reg = it.prev();
                if (reg.getType() != "CDC") continue;
                return it.getStructuredDocumentRegion().getStartOffset(reg);
            }
            return n;
        }
        return -1;
    }

    public static synchronized StyleSheetFormatter getInstance() {
        if (instance == null) {
            instance = new StyleSheetFormatter();
        }
        return instance;
    }
}

