/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.dom;

import junit.framework.TestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMImplementationTests
extends TestCase {
    public void testCreateDocumentEmpty() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        Document document = model.createDocument(null, null, null);
        DOMImplementationTests.assertNull((String)"The document should be empty", (Object)document.getFirstChild());
    }

    public void testCreateDocumentNoDocumentType() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        Document document = model.createDocument("http://eclipse.org", "foo:bar", null);
        Node node = document.getFirstChild();
        DOMImplementationTests.assertNotNull((String)"Document should not be empty", (Object)node);
        DOMImplementationTests.assertEquals((String)"Element qualified name is not equal", (String)"foo:bar", (String)node.getNodeName());
        DOMImplementationTests.assertEquals((String)"Element namespace URI is not equal", (String)"http://eclipse.org", (String)node.getNamespaceURI());
    }

    public void testCreateDocumentUsedDoctype() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        DocumentType doctype = model.createDocumentType("bar", "publicTest", "systemTest");
        IDOMDocument document = model.getDocument();
        document.appendChild((Node)doctype);
        try {
            model.createDocument("http://eclipse.org", "foo:bar", doctype);
        }
        catch (DOMException e) {
            DOMImplementationTests.assertEquals((String)"Wrong DOMExcetion thrown", (short)4, (short)e.code);
            return;
        }
        DOMImplementationTests.fail((String)"Reusing the doctype from another document should have caused an exception");
    }

    public void testCreateDocument() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        DocumentType doctype = model.createDocumentType("bar", "publicTest", "systemTest");
        Document document = model.createDocument("http://eclipse.org", "foo:bar", doctype);
        DOMImplementationTests.assertEquals((String)"Document's doctype was not properly set", (Object)doctype, (Object)document.getDoctype());
        DOMImplementationTests.assertEquals((String)"Document owner node is not set properly", (Object)document, (Object)doctype.getOwnerDocument());
        Element node = document.getDocumentElement();
        DOMImplementationTests.assertNotNull((String)"Document should not be empty", (Object)node);
        DOMImplementationTests.assertEquals((String)"Element qualified name is not equal", (String)"foo:bar", (String)node.getNodeName());
        DOMImplementationTests.assertEquals((String)"Element namespace URI is not equal", (String)"http://eclipse.org", (String)node.getNamespaceURI());
    }

    public void testCreateDocumentIllegalChar() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        char[] illegalTest = new char[]{'`', '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '=', '+', ';', '\'', '\"', ',', '\\', '/', '<', '>', '[', ']', '{', '}', ' '};
        int i = 0;
        while (i < illegalTest.length) {
            block6: {
                try {
                    model.createDocument("http://eclipse.org", "foo:" + illegalTest[i], null);
                }
                catch (DOMException e) {
                    DOMImplementationTests.assertEquals((String)"Did not receive the correct DOMException", (short)5, (short)e.code);
                    break block6;
                }
                DOMImplementationTests.fail((String)("Illegal character [" + illegalTest[i] + "] allowed in document element qualified name"));
            }
            ++i;
        }
        String[] illegalNames = new String[]{" ", "f oo:bar", "foo: bar", "foo:bar ", ""};
        int i2 = 0;
        while (i2 < illegalNames.length) {
            block7: {
                try {
                    model.createDocument("http://eclipse.org", illegalNames[i2], null);
                }
                catch (DOMException e) {
                    DOMImplementationTests.assertEquals((String)("Did not receive the correct DOMException for [" + illegalNames[i2] + "]"), (short)5, (short)e.code);
                    break block7;
                }
                DOMImplementationTests.fail((String)("Illegal character [" + illegalNames[i2] + "] allowed in document element qualified name"));
            }
            ++i2;
        }
    }

    public void testCreateDocumentIllegalNamespace() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        try {
            model.createDocument(null, "foo:bar", null);
        }
        catch (DOMException e) {
            DOMImplementationTests.assertEquals((String)"Did not receive the correct DOMException", (short)14, (short)e.code);
            return;
        }
        DOMImplementationTests.fail((String)"No exceptions for illegal input");
    }

    public void testCreateDocumentNamespaceWithNoQualifiedName() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        try {
            model.createDocument("http://eclipse.org", null, null);
        }
        catch (DOMException e) {
            DOMImplementationTests.assertEquals((String)"Did not receive the correct DOMException", (short)14, (short)e.code);
            return;
        }
        DOMImplementationTests.fail((String)"No exceptions for illegal input");
    }

    public void testCreateDocumentLegalNamespaceXML() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        try {
            model.createDocument("http://www.w3.org/XML/1998/namespace", "xml:bar", null);
        }
        catch (DOMException dOMException) {
            DOMImplementationTests.fail((String)"xml prefix is allowed for the namespace http://www.w3.org/XML/1998/namespace");
        }
    }

    public void testCreateDocumentIllegalNamespaceXML() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        try {
            model.createDocument("http://eclipse.org", "xml:bar", null);
        }
        catch (DOMException e) {
            DOMImplementationTests.assertEquals((String)"Did not receive the correct DOMException", (short)14, (short)e.code);
            return;
        }
        DOMImplementationTests.fail((String)"No exceptions for illegal input");
    }

    public void testCreateDocumentMalformedQualifiedNames() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        String[] names = new String[]{"foo:", "foo:.", "foo:-", "foo:bar:baz"};
        int i = 0;
        while (i < names.length) {
            block3: {
                try {
                    model.createDocument("http://eclipse.org", names[i], null);
                }
                catch (DOMException e) {
                    DOMImplementationTests.assertEquals((String)("Did not receive the correct DOMException for [" + names[i] + "]"), (short)14, (short)e.code);
                    break block3;
                }
                DOMImplementationTests.fail((String)("Malformd qualified name [" + names[i] + "]"));
            }
            ++i;
        }
    }

    public void testCreateDocumentWellformedQualifiedNames() {
        DOMModelImpl model = (DOMModelImpl)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        String[] names = new String[]{"bar", "foo:bar"};
        int i = 0;
        while (i < names.length) {
            try {
                model.createDocument("http://eclipse.org", names[i], null);
            }
            catch (DOMException dOMException) {
                DOMImplementationTests.fail((String)("[" + names[i] + "] flagged as an invalid qualified name"));
            }
            ++i;
        }
    }
}

