/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.java.search.JSPIndexManager;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;

public class IndexWorkspaceJob
extends Job {
    static final boolean DEBUG;
    private IContentType fContentTypeJSP = null;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspindexmanager");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public IndexWorkspaceJob() {
        super(JSPCoreMessages.JSPIndexManager_0);
        this.setPriority(30);
        this.setSystem(true);
    }

    IContentType getJspContentType() {
        if (this.fContentTypeJSP == null) {
            this.fContentTypeJSP = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP);
        }
        return this.fContentTypeJSP;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        long start;
        IStatus status;
        block10: {
            status = Status.OK_STATUS;
            if (monitor.isCanceled()) {
                this.setCanceledState();
                return Status.CANCEL_STATUS;
            }
            if (DEBUG) {
                System.out.println(" ^ IndexWorkspaceJob started: ");
            }
            start = System.currentTimeMillis();
            try {
                try {
                    JSPFileVisitor visitor = new JSPFileVisitor(monitor);
                    ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)visitor, 2);
                    JSPIndexManager.getInstance().indexFiles(visitor.getFiles());
                }
                catch (CoreException e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            {
                Object var6_9 = null;
                if (monitor == null) break block10;
            }
            monitor.done();
        }
        long finish = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println(" ^ IndexWorkspaceJob finished\n   total time running: " + (finish - start));
        }
        return status;
    }

    void setCanceledState() {
        JSPIndexManager.getInstance().setIndexState(4);
    }

    private class JSPFileVisitor
    implements IResourceProxyVisitor {
        private List files = new ArrayList();
        IProgressMonitor fInnerMonitor = null;

        public JSPFileVisitor(IProgressMonitor monitor) {
            this.fInnerMonitor = monitor;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IFile file;
            if (this.fInnerMonitor != null && this.fInnerMonitor.isCanceled()) {
                IndexWorkspaceJob.this.setCanceledState();
                return false;
            }
            if (JSPSearchSupport.getInstance().isCanceled()) {
                IndexWorkspaceJob.this.setCanceledState();
                return false;
            }
            if (proxy.getType() == 1 && IndexWorkspaceJob.this.getJspContentType().isAssociatedWith(proxy.getName()) && (file = (IFile)proxy.requestResource()).exists()) {
                if (DEBUG) {
                    System.out.println("(+) IndexWorkspaceJob adding file: " + file.getName());
                }
                this.files.add(file);
                this.fInnerMonitor.subTask(proxy.getName());
                return false;
            }
            return true;
        }

        public final IFile[] getFiles() {
            return this.files.toArray(new IFile[this.files.size()]);
        }
    }
}

