/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.taglib;

import com.ibm.icu.util.StringTokenizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.Document;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.util.DocumentProvider;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITagDirRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecordEvent;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.util.JarUtilities;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ProjectDescription {
    static boolean _debugIndexCreation = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indexcreation"));
    static boolean _debugIndexTime = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indextime"));
    private static final String WEB_INF = "WEB-INF";
    private static final IPath WEB_INF_PATH = new Path("WEB-INF");
    private static final String BUILDPATH_PROJECT = "BUILDPATH_PROJECT";
    private static final String WEB_XML = "web.xml";
    private static final String SAVE_FORMAT_VERSION = "Tag Library Index 1.0.1";
    private static final String BUILDPATH_DIRTY = "BUILDPATH_DIRTY";
    Hashtable fClasspathJars;
    boolean fBuildPathIsDirty = false;
    Set fClasspathProjects = null;
    Hashtable fClasspathReferences;
    Hashtable fImplicitReferences;
    Hashtable fJARReferences;
    IProject fProject;
    Hashtable fTagDirReferences;
    Hashtable fTLDReferences;
    IResourceDeltaVisitor fVisitor;
    Hashtable fWebXMLReferences;
    private long time0;
    private String fSaveStateFilename;

    ProjectDescription(IProject project, String saveStateFile) {
        this.fProject = project;
        this.fSaveStateFilename = saveStateFile;
        this.fClasspathJars = new Hashtable(0);
        this.fJARReferences = new Hashtable(0);
        this.fTagDirReferences = new Hashtable(0);
        this.fTLDReferences = new Hashtable(0);
        this.fWebXMLReferences = new Hashtable(0);
        this.fImplicitReferences = new Hashtable(0);
        this.fClasspathReferences = new Hashtable(0);
        this.fClasspathProjects = new HashSet();
        this.restoreReferences();
    }

    private Collection _getJSP11AndWebXMLJarReferences(Collection allJARs) {
        ArrayList<JarRecord> collection = new ArrayList<JarRecord>(allJARs.size());
        Iterator i = allJARs.iterator();
        while (i.hasNext()) {
            JarRecord record = (JarRecord)i.next();
            if (!record.has11TLD && !record.isMappedInWebXML) continue;
            collection.add(record);
        }
        return collection;
    }

    void addBuildPathReferences(Map references, List projectsProcessed, boolean exportedOnly) {
        this.ensureUpTodate();
        Enumeration keys = this.fClasspathReferences.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            URLRecord urlRecord = (URLRecord)this.fClasspathReferences.get(key);
            if (exportedOnly) {
                if (!urlRecord.isExported) continue;
                references.put(key, urlRecord);
                continue;
            }
            references.put(key, urlRecord);
        }
        IProject[] buildpathProjects = this.fClasspathProjects.toArray(new IProject[this.fClasspathProjects.size()]);
        int i = 0;
        while (i < buildpathProjects.length) {
            if (!projectsProcessed.contains(buildpathProjects[i]) && buildpathProjects[i].isAccessible()) {
                projectsProcessed.add(buildpathProjects[i]);
                ProjectDescription description = TaglibIndex._instance.createDescription(buildpathProjects[i]);
                description.addBuildPathReferences(references, projectsProcessed, true);
                Map[] rootReferences = description.fImplicitReferences.values().toArray(new Map[description.fImplicitReferences.size()]);
                int j = 0;
                while (j < rootReferences.length) {
                    Iterator implicitRecords = rootReferences[j].values().iterator();
                    while (implicitRecords.hasNext()) {
                        ITaglibRecord record = (ITaglibRecord)implicitRecords.next();
                        if (record.getRecordType() != 1 || ((ITLDRecord)record).getURI() == null) continue;
                        references.put(((ITLDRecord)record).getURI(), record);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void clear() {
        this.fClasspathJars = new Hashtable(0);
        this.fJARReferences = new Hashtable(0);
        this.fTagDirReferences = new Hashtable(0);
        this.fTLDReferences = new Hashtable(0);
        this.fWebXMLReferences = new Hashtable(0);
        this.fImplicitReferences = new Hashtable(0);
        this.fClasspathReferences = new Hashtable(0);
    }

    private ITaglibRecord createCatalogRecord(ICatalogEntry catalogEntry) {
        return this.createCatalogRecord(catalogEntry.getKey(), catalogEntry.getURI());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITaglibRecord createCatalogRecord(String uri, String urlString) {
        JarRecord record = null;
        if (urlString.toLowerCase(Locale.US).endsWith(".jar") && urlString.startsWith("file:")) {
            String fileLocation = null;
            try {
                URL url = new URL(urlString);
                fileLocation = url.getFile();
            }
            catch (MalformedURLException malformedURLException) {}
            if (fileLocation == null) return record;
            JarRecord jarRecord = this.createJARRecord(fileLocation);
            String[] entries = JarUtilities.getEntryNames((String)fileLocation);
            int jEntry = 0;
            while (true) {
                if (jEntry >= entries.length) {
                    if (!jarRecord.has11TLD) return record;
                    if (!_debugIndexCreation) return jarRecord;
                    Logger.log(1, "created catalog record for " + urlString + "@" + jarRecord.getLocation());
                    return jarRecord;
                }
                if (entries[jEntry].endsWith(".tld") && entries[jEntry].equals("META-INF/taglib.tld")) {
                    jarRecord.has11TLD = true;
                    InputStream contents = JarUtilities.getInputStream((String)fileLocation, (String)entries[jEntry]);
                    if (contents != null) {
                        TaglibInfo info = this.extractInfo(fileLocation, contents);
                        info.uri = uri;
                        jarRecord.info = info;
                    }
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                }
                ++jEntry;
            }
        }
        URL url = null;
        ByteArrayInputStream cachedContents = null;
        InputStream tldStream = null;
        try {
            url = new URL(urlString);
            URLConnection connection = url.openConnection();
            connection.setDefaultUseCaches(false);
            tldStream = connection.getInputStream();
        }
        catch (Exception e1) {
            Logger.logException("Exception reading TLD contributed to the XML Catalog", e1);
        }
        if (tldStream == null) return record;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = new byte[2048];
        try {
            try {
                while (true) {
                    int c;
                    if ((c = tldStream.read(bytes)) < 0) {
                        cachedContents = new ByteArrayInputStream(buffer.toByteArray());
                    }
                    buffer.write(bytes, 0, c);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var10_20 = null;
            try {
                tldStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_21 = null;
        }
        try {}
        catch (IOException iOException) {}
        tldStream.close();
        URLRecord urlRecord = null;
        TaglibInfo info = this.extractInfo(urlString, cachedContents);
        if (info != null) {
            info.uri = uri;
            urlRecord = new URLRecord();
            urlRecord.info = info;
            urlRecord.baseLocation = urlString;
            urlRecord.url = url;
        }
        try {
            cachedContents.close();
            return urlRecord;
        }
        catch (IOException iOException) {}
        return urlRecord;
    }

    private JarRecord createJARRecord(IResource jar) {
        return this.createJARRecord(jar.getLocation().toString());
    }

    private JarRecord createJARRecord(String fileLocation) {
        JarRecord record = new JarRecord();
        record.location = new Path(fileLocation);
        record.urlRecords = new ArrayList(0);
        record.info = new TaglibInfo();
        return record;
    }

    TagDirRecord createTagdirRecord(IResource tagFile) {
        IContainer tagdir = tagFile.getParent();
        String tagdirLocation = tagdir.getFullPath().toString();
        TagDirRecord record = (TagDirRecord)this.fTagDirReferences.get(tagdirLocation);
        if (record == null) {
            record = new TagDirRecord();
            record.location = tagdir.getFullPath();
            if (tagdir.getName().equals("tags")) {
                record.shortName = "tags";
            } else {
                IPath tagdirPath = tagdir.getFullPath();
                String[] segments = tagdirPath.segments();
                int i = 1;
                while (record.shortName == null && i < segments.length) {
                    if (segments[i - 1].equals(WEB_INF) && segments[i].equals("tags")) {
                        IPath tagdirLocalPath = tagdirPath.removeFirstSegments(i + 1);
                        record.shortName = tagdirLocalPath.toString().replace('/', '-');
                    }
                    ++i;
                }
            }
        }
        return record;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TLDRecord createTLDRecord(IResource tld) {
        TLDRecord record = new TLDRecord();
        record.path = tld.getFullPath();
        InputStream contents = null;
        try {
            try {
                if (tld.getLocation() != null) {
                    contents = ((IFile)tld).getContents(true);
                    String basePath = tld.getFullPath().toString();
                    TaglibInfo info = this.extractInfo(basePath, contents);
                    if (info != null) {
                        record.info = info;
                    }
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (contents == null) throw throwable;
                contents.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return record;
        }
        if (contents == null) return record;
        contents.close();
        return record;
    }

    private void ensureUpTodate() {
        if (this.fBuildPathIsDirty) {
            this.indexClasspath();
            this.fBuildPathIsDirty = false;
        }
    }

    private TaglibInfo extractInfo(String basePath, InputStream tldContents) {
        TaglibInfo info = new TaglibInfo();
        if (tldContents != null) {
            DocumentProvider provider = new DocumentProvider();
            provider.setInputStream(tldContents);
            provider.setValidating(false);
            provider.setRootElementName("taglib");
            provider.setBaseReference(basePath);
            Node child = provider.getRootElement();
            if (child == null || child.getNodeType() != 1 || !child.getNodeName().equals("taglib")) {
                return null;
            }
            child = child.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    if (child.getNodeName().equals("uri")) {
                        info.uri = this.getTextContents(child);
                    } else if (child.getNodeName().equals("short-name") || child.getNodeName().equals("shortname")) {
                        info.shortName = this.getTextContents(child);
                    } else if (child.getNodeName().equals("description") || child.getNodeName().equals("info")) {
                        info.description = this.getTextContents(child);
                    } else if (child.getNodeName().equals("jsp-version") || child.getNodeName().equals("jspversion")) {
                        try {
                            info.jspVersion = Float.parseFloat(this.getTextContents(child));
                        }
                        catch (NumberFormatException numberFormatException) {
                            info.jspVersion = 1.0f;
                        }
                    } else if (child.getNodeName().equals("tlib-version") || child.getNodeName().equals("tlibversion")) {
                        info.tlibVersion = this.getTextContents(child);
                    } else if (child.getNodeName().equals("small-icon")) {
                        info.smallIcon = this.getTextContents(child);
                    } else if (child.getNodeName().equals("large-icon")) {
                        info.largeIcon = this.getTextContents(child);
                    }
                }
                child = child.getNextSibling();
            }
        }
        return info;
    }

    synchronized List getAvailableTaglibRecords(IPath path) {
        this.ensureUpTodate();
        HashSet implicitReferences = new HashSet(this.getImplicitReferences(path.toString()).values());
        ArrayList<Object> records = new ArrayList<Object>(this.fTLDReferences.size() + this.fTagDirReferences.size() + this.fJARReferences.size() + this.fWebXMLReferences.size());
        records.addAll(this.fTLDReferences.values());
        records.addAll(this.fTagDirReferences.values());
        records.addAll(this._getJSP11AndWebXMLJarReferences(this.fJARReferences.values()));
        records.addAll(implicitReferences);
        HashMap buildPathReferences = new HashMap();
        ArrayList<IProject> projectsProcessed = new ArrayList<IProject>(this.fClasspathProjects.size() + 1);
        projectsProcessed.add(this.fProject);
        this.addBuildPathReferences(buildPathReferences, projectsProcessed, false);
        records.addAll(buildPathReferences.values());
        ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        if (defaultCatalog != null) {
            ICatalogEntry[] entries = defaultCatalog.getCatalogEntries();
            int entry = 0;
            while (entry < entries.length) {
                ITaglibRecord record = this.createCatalogRecord(entries[entry]);
                records.add(record);
                ++entry;
            }
            INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
            int nextCatalog = 0;
            while (nextCatalog < nextCatalogs.length) {
                ICatalog catalog = nextCatalogs[nextCatalog].getReferencedCatalog();
                ICatalogEntry[] entries2 = catalog.getCatalogEntries();
                int entry2 = 0;
                while (entry2 < entries2.length) {
                    ITaglibRecord record;
                    String uri = entries2[entry2].getURI();
                    if (uri != null && ((uri = uri.toLowerCase(Locale.US)).endsWith(".jar") || uri.endsWith(".tld")) && (record = this.createCatalogRecord(entries2[entry2])) != null) {
                        records.add(record);
                    }
                    ++entry2;
                }
                ++nextCatalog;
            }
        }
        return records;
    }

    Hashtable getImplicitReferences(String path) {
        String localRoot = this.getLocalRoot(path);
        Hashtable implicitReferences = (Hashtable)this.fImplicitReferences.get(localRoot);
        if (implicitReferences == null) {
            implicitReferences = new Hashtable(1);
            this.fImplicitReferences.put(localRoot, implicitReferences);
        }
        return implicitReferences;
    }

    IPath getLocalRoot(IPath basePath) {
        IFile[] files;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)basePath);
        if (file == null && basePath.segmentCount() > 1) {
            file = workspaceRoot.getFolder(basePath);
        }
        if (file != null && !file.exists() && basePath.segmentCount() > 1) {
            file = workspaceRoot.getFile(basePath);
        }
        if (file == null && basePath.segmentCount() == 1) {
            file = workspaceRoot.getProject(basePath.segment(0));
        }
        if (file == null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(basePath)).length > 0) {
            file = files[0];
        }
        while (file != null) {
            IFolder webinf;
            IContainer folder = null;
            folder = (file.getType() & 2) != 0 ? (IContainer)file : file.getParent();
            if (folder != null && (folder.getType() & 8) == 0 && (webinf = folder.getFolder(WEB_INF_PATH)) != null && webinf.exists()) {
                return folder.getFullPath();
            }
            file = file.getParent();
        }
        return this.fProject.getFullPath();
    }

    private String getLocalRoot(String basePath) {
        return this.getLocalRoot((IPath)new Path(basePath)).toString();
    }

    private String getTextContents(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    IResourceDeltaVisitor getVisitor() {
        if (this.fVisitor == null) {
            this.fVisitor = new DeltaVisitor();
        }
        return this.fVisitor;
    }

    void handleElementChanged(IJavaElementDelta delta) {
        if (this.fBuildPathIsDirty) {
            return;
        }
        IJavaElement element = delta.getElement();
        if (element.getElementType() == 3 && ((IPackageFragmentRoot)element).isArchive()) {
            IFile file;
            this.time0 = System.currentTimeMillis();
            String libPath = null;
            int taglibRecordEventKind = -1;
            if ((delta.getFlags() & 0x40) > 0) {
                taglibRecordEventKind = 1;
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(element.getPath());
                libPath = file.exists() ? file.getLocation().toString() : element.getPath().toString();
            } else if ((delta.getFlags() & 0x80) > 0) {
                taglibRecordEventKind = 2;
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(element.getPath());
                libPath = file.getLocation() != null ? file.getLocation().toString() : element.getPath().toString();
            } else if ((delta.getFlags() & 0x8000) > 0) {
                taglibRecordEventKind = 4;
                file = ResourcesPlugin.getWorkspace().getRoot().getFile(element.getPath());
                libPath = file.exists() ? file.getLocation().toString() : element.getPath().toString();
            }
            if (libPath != null) {
                boolean fragmentisExported = true;
                try {
                    IClasspathEntry rawClasspathEntry = ((IPackageFragmentRoot)element).getRawClasspathEntry();
                    if (rawClasspathEntry != null) {
                        fragmentisExported = rawClasspathEntry.isExported();
                    }
                }
                catch (JavaModelException e) {
                    Logger.logException("Problem handling build path entry for " + element.getPath(), e);
                }
                this.updateClasspathLibrary(libPath, taglibRecordEventKind, fragmentisExported);
            }
            if (_debugIndexTime) {
                Logger.log(1, "processed build path delta for " + this.fProject.getName() + "(" + element.getPath() + ") in " + (System.currentTimeMillis() - this.time0) + "ms");
            }
        }
    }

    void index() {
        this.time0 = System.currentTimeMillis();
        this.fTLDReferences.clear();
        this.fJARReferences.clear();
        this.fTagDirReferences.clear();
        this.fWebXMLReferences.clear();
        try {
            this.fProject.accept((IResourceProxyVisitor)new Indexer(), 0);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (_debugIndexTime) {
            Logger.log(1, "indexed " + this.fProject.getName() + " contents in " + (System.currentTimeMillis() - this.time0) + "ms");
        }
    }

    void indexClasspath() {
        if (_debugIndexTime) {
            this.time0 = System.currentTimeMillis();
        }
        this.fClasspathProjects.clear();
        this.fClasspathReferences.clear();
        this.fClasspathJars.clear();
        IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
        if (javaProject.exists()) {
            this.indexClasspath(javaProject);
        }
        if (_debugIndexTime) {
            Logger.log(1, "indexed " + this.fProject.getName() + " classpath in " + (System.currentTimeMillis() - this.time0) + "ms");
        }
    }

    private void indexClasspath(IClasspathEntry entry) {
        switch (entry.getEntryKind()) {
            case 5: {
                IClasspathContainer container = (IClasspathContainer)entry;
                IClasspathEntry[] containedEntries = container.getClasspathEntries();
                int i = 0;
                while (i < containedEntries.length) {
                    this.indexClasspath(containedEntries[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                IPath libPath = entry.getPath();
                if (this.fClasspathJars.containsKey(libPath.toString())) break;
                if (libPath.toFile().exists()) {
                    this.updateClasspathLibrary(libPath.toString(), 1, entry.isExported());
                    break;
                }
                IFile libFile = ResourcesPlugin.getWorkspace().getRoot().getFile(libPath);
                if (libFile == null || !libFile.exists()) break;
                this.updateClasspathLibrary(libFile.getLocation().toString(), 1, entry.isExported());
                break;
            }
            case 2: {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment());
                if (project == null) break;
                this.fClasspathProjects.add(project);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                IPath libPath = JavaCore.getResolvedVariablePath((IPath)entry.getPath());
                if (libPath == null) break;
                File file = new File(libPath.toOSString());
                if (file.exists() && !file.isDirectory()) {
                    this.updateClasspathLibrary(libPath.toString(), 1, entry.isExported());
                    break;
                }
                IFile jarFile = ResourcesPlugin.getWorkspace().getRoot().getFile(libPath);
                if (!jarFile.isAccessible() || jarFile.getType() != 1 || jarFile.getLocation() == null) break;
                String jarPathString = jarFile.getLocation().toString();
                this.updateClasspathLibrary(jarPathString, 1, entry.isExported());
            }
        }
    }

    private void indexClasspath(IJavaProject javaProject) {
        if (javaProject == null) {
            return;
        }
        IProject project = javaProject.getProject();
        if (project.equals((Object)this.fProject)) {
            try {
                IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < entries.length) {
                    this.indexClasspath(entries[i]);
                    ++i;
                }
            }
            catch (JavaModelException e) {
                Logger.logException("Error searching Java Build Path + (" + this.fProject.getName() + ") for tag libraries", e);
            }
        }
    }

    private String readTextofChild(Node node, String childName) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(childName)) {
                return this.getTextContents(child);
            }
            ++i;
        }
        return "";
    }

    void removeJAR(IResource jar) {
        JarRecord record;
        if (_debugIndexCreation) {
            Logger.log(1, "removing records for JAR " + jar.getFullPath());
        }
        if ((record = (JarRecord)this.fJARReferences.remove(jar.getFullPath().toString())) != null) {
            URLRecord[] records = record.getURLRecords().toArray(new URLRecord[0]);
            int i = 0;
            while (i < records.length) {
                TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(records[i], 2));
                this.getImplicitReferences(jar.getFullPath().toString()).remove(records[i].getURI());
                ++i;
            }
            if (record.has11TLD) {
                TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, 2));
            }
        }
    }

    void removeTagDir(IResource tagFile) {
    }

    void removeTLD(IResource tld) {
        TLDRecord record;
        if (_debugIndexCreation) {
            Logger.log(1, "removing record for " + tld.getFullPath());
        }
        if ((record = (TLDRecord)this.fTLDReferences.remove(tld.getFullPath())) != null) {
            if (record.getURI() != null) {
                this.getImplicitReferences(tld.getFullPath().toString()).remove(record.getURI());
            }
            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, 2));
        }
    }

    void removeWebXML(IResource webxml) {
        WebXMLRecord record;
        if (_debugIndexCreation) {
            Logger.log(1, "removing records for " + webxml.getFullPath());
        }
        if ((record = (WebXMLRecord)this.fWebXMLReferences.remove(webxml.getLocation().toString())) != null) {
            TLDRecord[] records = record.getTLDRecords().toArray(new TLDRecord[0]);
            int i = 0;
            while (i < records.length) {
                if (_debugIndexCreation) {
                    Logger.log(1, "removed record for " + records[i].getURI() + "@" + records[i].path);
                }
                this.getImplicitReferences(webxml.getFullPath().toString()).remove(records[i].getURI());
                TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(records[i], 2));
                ++i;
            }
        }
    }

    ITaglibRecord resolve(String basePath, String reference) {
        ICatalog catalog;
        this.ensureUpTodate();
        ITaglibRecord record = null;
        String path = null;
        path = reference.startsWith("/") ? String.valueOf(this.getLocalRoot(basePath)) + reference : URIHelper.normalize((String)reference, (String)basePath, (String)this.getLocalRoot(basePath));
        if (record == null && (record = (ITaglibRecord)this.fJARReferences.get(path)) instanceof JarRecord && !((JarRecord)record).has11TLD) {
            record = null;
        }
        if (record == null) {
            record = (ITaglibRecord)this.fTLDReferences.get(path);
        }
        if (record == null) {
            record = (ITaglibRecord)this.getImplicitReferences(basePath).get(reference);
        }
        if (record == null) {
            record = (ITaglibRecord)this.fTagDirReferences.get(path);
        }
        if (record == null) {
            record = (ITaglibRecord)this.fClasspathReferences.get(reference);
        }
        if (record == null) {
            HashMap buildPathReferences = new HashMap();
            ArrayList<IProject> projectsProcessed = new ArrayList<IProject>(this.fClasspathProjects.size() + 1);
            projectsProcessed.add(this.fProject);
            this.addBuildPathReferences(buildPathReferences, projectsProcessed, false);
            record = (ITaglibRecord)buildPathReferences.get(reference);
        }
        if (record == null && (catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog()) != null) {
            String resolvedString = null;
            try {
                resolvedString = catalog.resolveSystem(reference);
                if (resolvedString == null || resolvedString.trim().length() == 0) {
                    resolvedString = catalog.resolveURI(reference);
                }
                if (resolvedString == null || resolvedString.trim().length() == 0) {
                    resolvedString = catalog.resolvePublic(reference, basePath);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
            if (resolvedString != null && resolvedString.trim().length() > 0) {
                record = this.createCatalogRecord(reference, resolvedString);
            }
        }
        if (record == null && this.fProject.getFullPath().toString().equals(this.getLocalRoot(basePath))) {
            WebXMLRecord[] webxmls = this.fWebXMLReferences.values().toArray(new WebXMLRecord[0]);
            int i = 0;
            while (i < webxmls.length) {
                if (record == null) {
                    record = (ITaglibRecord)this.getImplicitReferences(webxmls[i].path.toString()).get(reference);
                }
                ++i;
            }
        }
        return record;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreReferences() {
        block44: {
            if (TaglibIndex.ENABLED == false) return;
            this.index();
            restored = false;
            savedState = new File(this.fSaveStateFilename);
            if (!savedState.exists()) break block44;
            reader = null;
            try {
                try {
                    block46: {
                        block43: {
                            this.time0 = System.currentTimeMillis();
                            reader = new InputStreamReader((InputStream)new FileInputStream(savedState), "utf16");
                            buffer = new StringBuffer();
                            array = new char[2048];
                            charsRead = 0;
                            while (true) {
                                block45: {
                                    if ((charsRead = reader.read(array)) != -1) break block45;
                                    doc = new Document();
                                    doc.set(buffer.toString());
                                    lines = doc.getNumberOfLines();
                                    if (lines <= 0) break block43;
                                    line = doc.getLineInformation(0);
                                    lineText = doc.get(line.getOffset(), line.getLength());
                                    libraryRecord = null;
                                    if (!"Tag Library Index 1.0.1".equals(lineText.trim())) break;
                                    workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                                    i = 1;
                                    if (true) ** GOTO lbl161
                                }
                                if (charsRead <= 0) continue;
                                buffer.append(array, 0, charsRead);
                            }
                            Logger.log(1, "Tag Library Index: different cache format found, was \"" + lineText + "\", supports \"" + "Tag Library Index 1.0.1" + "\", reindexing");
                            break block46;
                        }
                        if (ProjectDescription._debugIndexTime && restored) {
                            Logger.log(2, "no lines in (no cache file?) " + this.fSaveStateFilename);
                        }
                    }
lbl38:
                    // 2 sources

                    while (ProjectDescription._debugIndexTime && restored) {
                        Logger.log(1, "time spent reloading " + this.fProject.getName() + " build path: " + (System.currentTimeMillis() - this.time0));
                    }
                    ** GOTO lbl-1000
                }
                catch (Exception e) {
                    restored = false;
                    if (ProjectDescription._debugIndexTime) {
                        Logger.log(1, "failure reloading " + this.fProject.getName() + " build path index", e);
                    }
                    ** GOTO lbl-1000
                }
                do {
                    block47: {
                        block49: {
                            block48: {
                                if (!(toker = new StringTokenizer(lineText = doc.get((line = doc.getLineInformation(i)).getOffset(), line.getLength()), "|")).hasMoreTokens()) break block47;
                                tokenType = toker.nextToken();
                                if (!"JAR".equalsIgnoreCase(tokenType)) break block48;
                                has11TLD = Boolean.valueOf(toker.nextToken());
                                exported = Boolean.valueOf(toker.nextToken());
                                libraryLocation = toker.nextToken();
                                if (true) ** GOTO lbl72
                            }
                            if (!"URL".equalsIgnoreCase(tokenType)) break block49;
                            exported = Boolean.valueOf(toker.nextToken());
                            urlString = toker.nextToken();
                            if (true) ** GOTO lbl106
                        }
                        if ("BUILDPATH_PROJECT".equalsIgnoreCase(tokenType)) {
                            projectName = toker.nextToken();
                            if (Path.ROOT.isValidSegment(projectName) && (project = workspaceRoot.getProject(projectName)) != null) {
                                this.fClasspathProjects.add(project);
                            }
                            break block47;
                        } else if ("BUILDPATH_DIRTY".equalsIgnoreCase(tokenType)) {
                            this.fBuildPathIsDirty = Boolean.valueOf(toker.nextToken());
                        }
                        break block47;
                        do {
                            libraryLocation = String.valueOf(libraryLocation) + "|" + toker.nextToken();
lbl72:
                            // 2 sources

                        } while (toker.hasMoreTokens());
                        libraryLocation = libraryLocation.trim();
                        if (libraryRecord != null) {
                            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(libraryRecord, 1));
                        }
                        libraryRecord = this.createJARRecord(libraryLocation);
                        libraryRecord.has11TLD = has11TLD;
                        libraryRecord.isExported = exported;
                        if (has11TLD && (contents = JarUtilities.getInputStream((String)libraryLocation, (String)"META-INF/taglib.tld")) != null) {
                            info = this.extractInfo(libraryLocation, contents);
                            if (info != null && info.uri != null && info.uri.length() > 0) {
                                urlRecord = new URLRecord();
                                urlRecord.info = info;
                                urlRecord.isExported = exported;
                                urlRecord.baseLocation = libraryLocation;
                                try {
                                    urlRecord.url = new URL("jar:file:" + libraryLocation + "!/" + "META-INF/taglib.tld");
                                    libraryRecord.urlRecords.add(urlRecord);
                                    this.fClasspathReferences.put(urlRecord.getURI(), urlRecord);
                                    if (ProjectDescription._debugIndexCreation) {
                                        Logger.log(1, "created record for " + urlRecord.getURI() + "@" + urlRecord.getURL());
                                    }
                                }
                                catch (MalformedURLException e) {
                                    Logger.logException(e);
                                }
                            }
                            try {
                                contents.close();
                            }
                            catch (IOException v0) {}
                        }
                        this.fClasspathJars.put(libraryLocation, libraryRecord);
                        break block47;
                        do {
                            urlString = String.valueOf(urlString) + "|" + toker.nextToken();
lbl106:
                            // 2 sources

                        } while (toker.hasMoreTokens());
                        urlString = urlString.trim();
                        urlRecord = new URLRecord();
                        urlRecord.url = new URL(urlString);
                        urlRecord.isExported = exported;
                        urlRecord.baseLocation = libraryRecord.location.toString();
                        libraryRecord.urlRecords.add(urlRecord);
                        cachedContents = null;
                        tldStream = null;
                        try {
                            connection = urlRecord.url.openConnection();
                            connection.setDefaultUseCaches(false);
                            tldStream = connection.getInputStream();
                        }
                        catch (IOException e1) {
                            Logger.logException(e1);
                        }
                        byteArrayOutput = new ByteArrayOutputStream();
                        bytes = new byte[2048];
                        try {
                            try {
                                while (true) {
                                    if ((c = tldStream.read(bytes)) < 0) {
                                        cachedContents = new ByteArrayInputStream(byteArrayOutput.toByteArray());
                                    }
                                    byteArrayOutput.write(bytes, 0, c);
                                }
                            }
                            catch (IOException v1) {}
                        }
                        catch (Throwable var25_32) {
                            var24_31 = null;
                            try {
                                tldStream.close();
                                throw var25_32;
                            }
                            catch (IOException v2) {}
                            throw var25_32;
                        }
                        {
                            var24_31 = null;
                        }
                        try {}
                        catch (IOException v3) {}
                        tldStream.close();
                        info = this.extractInfo(urlRecord.url.toString(), cachedContents);
                        if (info != null) {
                            urlRecord.info = info;
                        }
                        try {
                            cachedContents.close();
                        }
                        catch (IOException v4) {}
                        this.fClasspathReferences.put(urlRecord.getURI(), urlRecord);
                    }
                    if (libraryRecord != null) {
                        TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(libraryRecord, 1));
                    }
                    ++i;
lbl161:
                    // 2 sources

                } while (i < lines);
                restored = true;
                ** GOTO lbl38
            }
            catch (Throwable var27_33) {
                var26_34 = null;
                if (reader == null) throw var27_33;
                try {
                    reader.close();
                    throw var27_33;
                }
                catch (IOException v5) {}
                throw var27_33;
            }
lbl-1000:
            // 3 sources

            {
                var26_35 = null;
                if (reader == null) break block44;
            }
            try {}
            catch (IOException v6) {}
            reader.close();
        }
        if (restored != false) return;
        this.setBuildPathIsDirty();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void saveReferences() {
        this.time0 = System.currentTimeMillis();
        Writer writer = null;
        try {
            try {
                Enumeration jars;
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.fSaveStateFilename), "utf16");
                writer.write(SAVE_FORMAT_VERSION);
                writer.write(10);
                writer.write("BUILDPATH_DIRTY|" + this.fBuildPathIsDirty);
                writer.write(10);
                IProject[] projects = this.fClasspathProjects.toArray(new IProject[0]);
                int i = 0;
                while (true) {
                    if (i >= projects.length) {
                        jars = this.fClasspathJars.keys();
                        break;
                    }
                    writer.write(BUILDPATH_PROJECT);
                    writer.write("|");
                    writer.write(projects[i].getName());
                    writer.write(10);
                    ++i;
                }
                while (jars.hasMoreElements()) {
                    String jarPath = jars.nextElement().toString();
                    JarRecord jarRecord = (JarRecord)this.fClasspathJars.get(jarPath);
                    writer.write("JAR|");
                    writer.write(Boolean.toString(jarRecord.has11TLD));
                    writer.write(124);
                    writer.write(Boolean.toString(jarRecord.isExported));
                    writer.write(124);
                    writer.write(jarPath);
                    writer.write(10);
                    Iterator i2 = jarRecord.urlRecords.iterator();
                    while (i2.hasNext()) {
                        URLRecord urlRecord = (URLRecord)i2.next();
                        writer.write("URL|");
                        writer.write(String.valueOf(urlRecord.isExported));
                        writer.write("|");
                        writer.write(urlRecord.getURL().toExternalForm());
                        writer.write(10);
                    }
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (Exception exception) {}
        if (writer != null) {
            writer.close();
        }
        if (!_debugIndexTime) return;
        Logger.log(1, "time spent saving index for " + this.fProject.getName() + ": " + (System.currentTimeMillis() - this.time0));
    }

    void setBuildPathIsDirty() {
        this.fBuildPathIsDirty = true;
        if (_debugIndexCreation) {
            Logger.log(1, "marked build path dirty for " + this.fProject.getName() + ": " + (System.currentTimeMillis() - this.time0));
        }
    }

    void updateClasspathLibrary(String libraryLocation, int deltaKind, boolean isExported) {
        int i;
        JarRecord libraryRecord = null;
        if ((deltaKind == 2 || deltaKind == 4) && (libraryRecord = (JarRecord)this.fClasspathJars.remove(libraryLocation)) != null) {
            IURLRecord[] urlRecords = libraryRecord.urlRecords.toArray(new IURLRecord[0]);
            i = 0;
            while (i < urlRecords.length) {
                this.fClasspathReferences.remove(urlRecords[i].getURI());
                ++i;
            }
        }
        if (deltaKind == 1 || deltaKind == 4) {
            String[] entries = JarUtilities.getEntryNames((String)libraryLocation);
            libraryRecord = this.createJARRecord(libraryLocation);
            libraryRecord.isExported = isExported;
            this.fClasspathJars.put(libraryLocation, libraryRecord);
            i = 0;
            while (i < entries.length) {
                if (entries[i].endsWith(".tld")) {
                    InputStream contents;
                    if (entries[i].equals("META-INF/taglib.tld")) {
                        libraryRecord.has11TLD = true;
                    }
                    if ((contents = JarUtilities.getInputStream((String)libraryLocation, (String)entries[i])) != null) {
                        TaglibInfo info = this.extractInfo(libraryLocation, contents);
                        if (info != null && info.uri != null && info.uri.length() > 0) {
                            URLRecord urlRecord = new URLRecord();
                            urlRecord.info = info;
                            urlRecord.baseLocation = libraryLocation;
                            try {
                                urlRecord.isExported = isExported;
                                urlRecord.url = new URL("jar:file:" + libraryLocation + "!/" + entries[i]);
                                libraryRecord.urlRecords.add(urlRecord);
                                this.fClasspathReferences.put(urlRecord.getURI(), urlRecord);
                                if (_debugIndexCreation) {
                                    Logger.log(1, "created record for " + urlRecord.getURI() + "@" + urlRecord.getURL());
                                }
                            }
                            catch (MalformedURLException e) {
                                Logger.logException(e);
                            }
                        }
                        try {
                            contents.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ++i;
            }
        }
        if (libraryRecord != null) {
            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(libraryRecord, deltaKind));
        }
    }

    void updateJAR(IResource jar, int deltaKind) {
        if (_debugIndexCreation) {
            Logger.log(1, "creating records for JAR " + jar.getFullPath());
        }
        String jarLocationString = jar.getLocation().toString();
        String[] entries = JarUtilities.getEntryNames((IResource)jar);
        JarRecord jarRecord = this.createJARRecord(jar);
        this.fJARReferences.put(jar.getFullPath().toString(), jarRecord);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].endsWith(".tld")) {
                InputStream contents;
                if (entries[i].equals("META-INF/taglib.tld")) {
                    jarRecord.has11TLD = true;
                }
                if ((contents = JarUtilities.getInputStream((IResource)jar, (String)entries[i])) != null) {
                    TaglibInfo info = this.extractInfo(jarLocationString, contents);
                    if (info != null && info.uri != null && info.uri.length() > 0) {
                        URLRecord record = new URLRecord();
                        record.info = info;
                        record.baseLocation = jarLocationString;
                        try {
                            record.url = new URL("jar:file:" + jarLocationString + "!/" + entries[i]);
                            jarRecord.urlRecords.add(record);
                            this.getImplicitReferences(jar.getFullPath().toString()).put(record.getURI(), record);
                            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, 1));
                            if (_debugIndexCreation) {
                                Logger.log(1, "created record for " + record.getURI() + "@" + record.getURL());
                            }
                        }
                        catch (MalformedURLException e) {
                            Logger.logException(e);
                        }
                    }
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    Logger.log(204, String.valueOf(this.getClass().getName()) + "could not read resource " + jar.getFullPath());
                }
            }
            ++i;
        }
        if (jarRecord.has11TLD) {
            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(jarRecord, deltaKind));
        }
    }

    void updateTagDir(IResource tagFile, int deltaKind) {
    }

    void updateTLD(IResource tld, int deltaKind) {
        if (_debugIndexCreation) {
            Logger.log(1, "creating record for " + tld.getFullPath());
        }
        TLDRecord record = this.createTLDRecord(tld);
        this.fTLDReferences.put(tld.getFullPath().toString(), record);
        if (record.getURI() != null) {
            this.getImplicitReferences(tld.getFullPath().toString()).put(record.getURI(), record);
        }
        TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, deltaKind));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateWebXML(IResource webxml, int deltaKind) {
        block20: {
            if (webxml.getType() != 1) {
                return;
            }
            webxmlContents = null;
            document = null;
            try {
                try {
                    webxmlContents = ((IFile)webxml).getContents(true);
                    provider = new DocumentProvider();
                    provider.setInputStream(webxmlContents);
                    provider.setValidating(false);
                    provider.setRootElementName("web-app");
                    provider.setBaseReference(webxml.getParent().getFullPath().toString());
                    document = provider.getDocument(false);
                }
                catch (CoreException e) {
                    Logger.log(204, "", e);
                }
            }
            catch (Throwable var7_7) {
                var6_9 = null;
                if (webxmlContents == null) throw var7_7;
                try {
                    webxmlContents.close();
                    throw var7_7;
                }
                catch (IOException v0) {}
                throw var7_7;
            }
            {
                var6_10 = null;
                if (webxmlContents == null) break block20;
            }
            try {}
            catch (IOException v1) {}
            webxmlContents.close();
        }
        if (document == null) {
            return;
        }
        if (ProjectDescription._debugIndexCreation) {
            Logger.log(1, "creating records for " + webxml.getFullPath());
        }
        webxmlRecord = new WebXMLRecord();
        webxmlRecord.path = webxml.getFullPath();
        this.fWebXMLReferences.put(webxmlRecord.getWebXML().toString(), webxmlRecord);
        taglibs = document.getElementsByTagName("taglib");
        iTaglib = 0;
        while (iTaglib < taglibs.getLength()) {
            block21: {
                block23: {
                    block22: {
                        taglibUri = this.readTextofChild(taglibs.item(iTaglib), "taglib-uri").trim();
                        taglibLocation = this.readTextofChild(taglibs.item(iTaglib), "taglib-location").trim();
                        path = null;
                        path = taglibLocation.startsWith("/") != false ? new Path(String.valueOf(this.getLocalRoot(webxml.getFullPath().toString())) + taglibLocation) : new Path(URIHelper.normalize((String)taglibLocation, (String)webxml.getFullPath().toString(), (String)this.getLocalRoot(webxml.getFullPath().toString())));
                        if (path.segmentCount() <= 1 || !(resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)).isAccessible()) break block21;
                        record /* !! */  = null;
                        if (!resource.getFileExtension().equalsIgnoreCase("jar")) break block22;
                        jarRecord = this.createJARRecord((IResource)resource);
                        entries = JarUtilities.getEntryNames((IResource)resource);
                        jEntry = 0;
                        if (true) ** GOTO lbl73
                    }
                    record /* !! */  = tldRecord = this.createTLDRecord((IResource)resource);
                    tldRecord.info.uri = taglibUri;
                    if (ProjectDescription._debugIndexCreation) {
                        Logger.log(1, "created web.xml record for " + taglibUri + "@" + tldRecord.getPath());
                    }
                    break block23;
                    do {
                        if (entries[jEntry].endsWith(".tld")) {
                            if (entries[jEntry].equals("META-INF/taglib.tld")) {
                                jarRecord.has11TLD = true;
                            }
                            if ((contents = JarUtilities.getInputStream((IResource)resource, (String)entries[jEntry])) != null) {
                                jarRecord.info = info = this.extractInfo(resource.getFullPath().toString(), contents);
                            }
                            try {
                                contents.close();
                            }
                            catch (IOException v2) {}
                        }
                        ++jEntry;
lbl73:
                        // 2 sources

                    } while (jEntry < entries.length);
                    record /* !! */  = jarRecord;
                    jarRecord.info.uri = taglibUri;
                    jarRecord.isMappedInWebXML = true;
                    if (ProjectDescription._debugIndexCreation) {
                        Logger.log(1, "created web.xml record for " + taglibUri + "@" + jarRecord.getLocation());
                    }
                }
                webxmlRecord.tldRecords.add(record /* !! */ );
                this.getImplicitReferences(webxml.getFullPath().toString()).put(taglibUri, record /* !! */ );
                TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record /* !! */ , deltaKind));
            }
            ++iTaglib;
        }
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (resource.getName().endsWith(".tld")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeTLD(resource);
                    } else {
                        ProjectDescription.this.updateTLD(resource, delta.getKind());
                    }
                } else if (resource.getName().endsWith(".jar")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeJAR(resource);
                    } else {
                        ProjectDescription.this.updateJAR(resource, delta.getKind());
                    }
                } else if (resource.getName().endsWith(".tag") || resource.getName().endsWith(".tagx")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeTagDir(resource);
                    } else {
                        ProjectDescription.this.updateTagDir(resource, delta.getKind());
                    }
                } else if (resource.getName().equals(ProjectDescription.WEB_XML) && resource.getParent().getName().equals(ProjectDescription.WEB_INF)) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeWebXML(resource);
                    } else {
                        ProjectDescription.this.updateWebXML(resource, delta.getKind());
                    }
                }
            }
            return resource.getName().length() != 0 && resource.getName().charAt(0) != '.';
        }
    }

    class Indexer
    implements IResourceProxyVisitor {
        Indexer() {
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            String name;
            if (proxy.getType() == 1) {
                if (proxy.getName().endsWith(".tld")) {
                    ProjectDescription.this.updateTLD(proxy.requestResource(), 1);
                } else if (proxy.getName().endsWith(".jar")) {
                    ProjectDescription.this.updateJAR(proxy.requestResource(), 1);
                } else if (proxy.getName().endsWith(".tag") || proxy.getName().endsWith(".tagx")) {
                    ProjectDescription.this.updateTagDir(proxy.requestResource(), 1);
                } else if (proxy.getName().equals(ProjectDescription.WEB_XML) && proxy.requestResource().getParent().getName().equals(ProjectDescription.WEB_INF)) {
                    ProjectDescription.this.updateWebXML(proxy.requestResource(), 1);
                }
            }
            return (name = proxy.getName()).length() != 0 && name.charAt(0) != '.';
        }
    }

    static class JarRecord
    implements IJarRecord {
        boolean has11TLD;
        boolean isMappedInWebXML;
        TaglibInfo info;
        IPath location;
        List urlRecords;
        boolean isExported = true;

        JarRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JarRecord)) {
                return false;
            }
            return ((JarRecord)obj).location.equals((Object)this.location) && ((JarRecord)obj).has11TLD == this.has11TLD;
        }

        public IPath getLocation() {
            return this.location;
        }

        public int getRecordType() {
            return 2;
        }

        public String getShortName() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        public String getURI() {
            if (this.info == null) {
                return null;
            }
            return this.info.uri;
        }

        public List getURLRecords() {
            return this.urlRecords;
        }

        public String toString() {
            return "JarRecord: " + this.location + " <-> " + this.urlRecords;
        }
    }

    static class TLDRecord
    implements ITLDRecord {
        TaglibInfo info;
        IPath path;

        TLDRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TLDRecord)) {
                return false;
            }
            return ((TLDRecord)obj).path.equals((Object)this.path) && ((TLDRecord)obj).getURI().equals(this.getURI());
        }

        public IPath getPath() {
            return this.path;
        }

        public int getRecordType() {
            return 1;
        }

        public String getShortName() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        public String getURI() {
            if (this.info == null) {
                return null;
            }
            return this.info.uri;
        }

        public String toString() {
            return "TLDRecord: " + this.getURI() + " <-> " + this.path;
        }
    }

    static class TagDirRecord
    implements ITagDirRecord {
        IPath location;
        String shortName;
        List tags = new ArrayList(0);

        TagDirRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TagDirRecord)) {
                return false;
            }
            return ((TagDirRecord)obj).location.equals((Object)this.location);
        }

        public IPath getLocation() {
            return this.location;
        }

        public int getRecordType() {
            return 8;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String[] getTags() {
            return this.tags.toArray(new String[this.tags.size()]);
        }

        public String toString() {
            return "TagdirRecord: " + this.location + " <-> " + this.shortName;
        }
    }

    static class TaglibInfo {
        String description;
        float jspVersion;
        String largeIcon;
        String shortName;
        String smallIcon;
        String tlibVersion;
        String uri;

        public String toString() {
            return "TaglibInfo|" + this.shortName + "|" + this.tlibVersion + "|" + this.smallIcon + "|" + this.largeIcon + "|" + this.jspVersion + "|" + this.uri + "|" + this.description;
        }
    }

    class TaglibRecordEvent
    implements ITaglibRecordEvent {
        ITaglibRecord fTaglibRecord = null;
        int fType = -1;

        TaglibRecordEvent(ITaglibRecord record, int type) {
            this.fTaglibRecord = record;
            this.fType = type;
        }

        public ITaglibRecord getTaglibRecord() {
            return this.fTaglibRecord;
        }

        public int getType() {
            return this.fType;
        }

        public String toString() {
            String string = this.fTaglibRecord.toString();
            switch (this.fType) {
                case 1: {
                    string = " ADDED (" + string + ")";
                    break;
                }
                case 4: {
                    string = " CHANGED (" + string + ")";
                    break;
                }
                case 2: {
                    string = " REMOVED (" + string + ")";
                    break;
                }
                default: {
                    string = " other:" + this.fType + " (" + string + ")";
                }
            }
            return string;
        }
    }

    static class URLRecord
    implements IURLRecord {
        String baseLocation;
        TaglibInfo info;
        URL url;
        boolean isExported = true;

        public boolean equals(Object obj) {
            if (!(obj instanceof URLRecord)) {
                return false;
            }
            return ((URLRecord)obj).baseLocation.equals(this.baseLocation) && ((URLRecord)obj).url.equals(this.url);
        }

        public String getBaseLocation() {
            return this.baseLocation;
        }

        public int getRecordType() {
            return 4;
        }

        public String getShortName() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        public String getURI() {
            if (this.info == null) {
                return "";
            }
            return this.info.uri;
        }

        public URL getURL() {
            return this.url;
        }

        public String toString() {
            return "URLRecord: " + this.baseLocation + " <-> " + this.getURI();
        }
    }

    static class WebXMLRecord {
        TaglibInfo info;
        IPath path;
        List tldRecords = new ArrayList(0);

        WebXMLRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WebXMLRecord)) {
                return false;
            }
            return ((WebXMLRecord)obj).path.equals((Object)this.path);
        }

        public String getPrefix() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        public List getTLDRecords() {
            return this.tldRecords;
        }

        public IPath getWebXML() {
            return this.path;
        }

        public String toString() {
            return "WebXMLRecord: " + this.path + " " + this.tldRecords;
        }
    }
}

