/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.datamodel.ProjectMigratorDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.IWorkspaceRunnableWithStatus;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class ModuleMigratorManager {
    private static HashMap managerCache = new HashMap();
    private static HashSet migrated = new HashSet();
    private boolean migrating;

    public static ModuleMigratorManager getManager(IProject proj) {
        ModuleMigratorManager manager = (ModuleMigratorManager)managerCache.get(proj);
        if (manager == null) {
            manager = new ModuleMigratorManager();
            managerCache.put(proj, manager);
        }
        return manager;
    }

    private void migrateComponentsIfNecessary(IProject project, boolean multiComps) {
        this.setupAndMigrateComponentProject(project);
    }

    private void setupAndMigrateComponentProject(IProject proj) {
        migrated.add(proj);
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new ProjectMigratorDataModelProvider());
        dm.setStringProperty("IProjectMigratorDataModelProperties.PROJECT_NAME", proj.getName());
        try {
            dm.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public synchronized void migrateOldMetaData(IProject aProject, final boolean multiComps) throws CoreException {
        this.migrating = true;
        IWorkspaceRunnableWithStatus workspaceRunnable = new IWorkspaceRunnableWithStatus((IAdaptable)aProject){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor pm) throws CoreException {
                IProject aProj = (IProject)this.getInfo();
                try {
                    if (aProj.isAccessible() && ModuleCoreNature.isFlexibleProject(aProj)) {
                        if (aProj.findMember(".wtpmodules") != null) {
                            ModuleMigratorManager.this.moveOldMetaDataFile(aProj);
                        }
                        if (this.needsComponentMigration(aProj, multiComps)) {
                            ModuleMigratorManager.this.migrateComponentsIfNecessary(aProj, multiComps);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    ModuleMigratorManager.this.migrating = false;
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                ModuleMigratorManager.this.migrating = false;
            }

            private boolean needsComponentMigration(IProject aProj, boolean multiComps2) throws CoreException {
                boolean needs = true;
                if (multiComps2) {
                    return needs && multiComps2;
                }
                return aProj.findMember(StructureEdit.MODULE_META_FILE_NAME) == null && aProj.findMember(".settings/.component") == null || ProjectFacetsManager.create((IProject)aProj) == null && needs;
            }
        };
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)workspaceRunnable, null, 1, null);
    }

    private void moveMetaDataFile(IProject project) {
        IResource oldfile = project.findMember(".wtpmodules");
        if (oldfile != null && oldfile.exists()) {
            try {
                IFolder settingsFolder = project.getFolder(".settings");
                if (!settingsFolder.exists()) {
                    settingsFolder.create(true, true, null);
                }
                oldfile.move((IPath)new Path(StructureEdit.MODULE_META_FILE_NAME), true, null);
            }
            catch (CoreException e) {
                Platform.getLog((Bundle)ModulecorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.wst.common.modulecore", 4, e.getMessage(), (Throwable)e));
            }
        }
    }

    private void moveOldMetaDataFile(IProject project) {
        try {
            this.moveMetaDataFile(project);
            IFolder depFolder = project.getFolder(".deployables");
            if (depFolder.exists()) {
                depFolder.delete(true, null);
            }
            project.refreshLocal(2, null);
        }
        catch (Exception exception) {}
    }

    public boolean isMigrating() {
        return this.migrating;
    }
}

