/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraph;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.internal.util.IModuleConstants;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class DependencyGraphManager {
    private static DependencyGraphManager INSTANCE = null;
    private static final String MANIFEST_URI = "META-INF/MANIFEST.MF";
    private HashMap wtpModuleTimeStamps = null;
    private HashMap manifestTimeStamps = null;
    private long modStamp = System.currentTimeMillis();

    private DependencyGraphManager() {
    }

    public static final synchronized DependencyGraphManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DependencyGraphManager();
        }
        return INSTANCE;
    }

    public void construct(IProject project) {
        if (project != null && project.isAccessible() && this.getComponentFile(project) != null) {
            this.constructIfNecessary();
        }
    }

    private IResource getComponentFile(IProject project) {
        IResource componentFile = project.findMember((IPath)IModuleConstants.COMPONENT_FILE_PATH);
        if (componentFile == null) {
            componentFile = project.findMember((IPath)IModuleConstants.R1_MODULE_META_FILE_PATH);
        }
        return componentFile;
    }

    private void constructIfNecessary() {
        if (this.metadataChanged()) {
            this.buildDependencyGraph();
        }
    }

    private boolean metadataChanged() {
        return this.moduleTimeStampsChanged() || this.manifestTimeStampsChanged();
    }

    private boolean manifestTimeStampsChanged() {
        HashMap workspaceTimeStamps = this.collectManifestTimeStamps();
        return !this.timestampsMatch(this.getManifestTimeStamps(), workspaceTimeStamps);
    }

    private HashMap getManifestTimeStamps() {
        if (this.manifestTimeStamps == null) {
            this.manifestTimeStamps = new HashMap();
        }
        return this.manifestTimeStamps;
    }

    private HashMap collectManifestTimeStamps() {
        HashMap<IProject, Long> timeStamps = new HashMap<IProject, Long>();
        IProject[] projects = ProjectUtilities.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IFile manifestFile = null;
            if (projects[i] != null && projects[i].isAccessible() && (manifestFile = this.getTimeStampFile(projects[i])) != null && manifestFile.exists() && ComponentCore.createComponent(projects[i]) != null) {
                Long currentTimeStamp = new Long(manifestFile.getModificationStamp());
                timeStamps.put(projects[i], currentTimeStamp);
            }
            ++i;
        }
        return timeStamps;
    }

    private IFile getTimeStampFile(IProject p) {
        IVirtualComponent component = ComponentCore.createComponent(p);
        if (component == null) {
            return null;
        }
        if (component.isBinary()) {
            return ((VirtualArchiveComponent)component).getUnderlyingWorkbenchFile();
        }
        try {
            IFile file = ComponentUtilities.findFile(component, (IPath)new Path(MANIFEST_URI));
            if (file != null) {
                return file;
            }
        }
        catch (CoreException ce) {
            Logger.getLogger().log((Throwable)ce);
        }
        return null;
    }

    private boolean moduleTimeStampsChanged() {
        HashMap workspaceTimeStamps = this.collectModuleTimeStamps();
        return !this.timestampsMatch(this.getWtpModuleTimeStamps(), workspaceTimeStamps);
    }

    private boolean timestampsMatch(HashMap savedTimeStamps, HashMap workspaceTimeStamps) {
        return savedTimeStamps.equals(workspaceTimeStamps);
    }

    private HashMap collectModuleTimeStamps() {
        HashMap<IProject, Long> timeStamps = new HashMap<IProject, Long>();
        IProject[] projects = ProjectUtilities.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IResource wtpModulesFile;
            if (projects[i] != null && projects[i].isAccessible() && (wtpModulesFile = this.getComponentFile(projects[i])) != null && wtpModulesFile.exists() && ComponentCore.createComponent(projects[i]) != null) {
                Long currentTimeStamp = new Long(wtpModulesFile.getModificationStamp());
                timeStamps.put(projects[i], currentTimeStamp);
            }
            ++i;
        }
        return timeStamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDependencyGraph() {
        ArrayList referencesToAdd = new ArrayList();
        ArrayList<IProject> componentProjects = new ArrayList<IProject>();
        IProject[] projects = ProjectUtilities.getAllProjects();
        int k = 0;
        while (k < projects.length) {
            IVirtualComponent component;
            if (projects[k].isAccessible() && this.getComponentFile(projects[k]) != null && (component = ComponentCore.createComponent(projects[k])) != null) {
                referencesToAdd.addAll(this.getDependencyReferences(component));
                componentProjects.add(projects[k]);
            }
            ++k;
        }
        DependencyGraphManager dependencyGraphManager = this;
        synchronized (dependencyGraphManager) {
            this.cleanDependencyGraph();
            Iterator iter = componentProjects.iterator();
            while (iter.hasNext()) {
                IProject proj = (IProject)iter.next();
                this.addTimeStamp(proj);
            }
            int i = 0;
            while (i < referencesToAdd.size()) {
                DependencyReference ref = (DependencyReference)referencesToAdd.get(i);
                if (ref.targetProject != null && ref.componentProject != null && !ref.targetProject.equals((Object)ref.componentProject)) {
                    DependencyGraph.getInstance().addReference(ref.targetProject, ref.componentProject);
                }
                ++i;
            }
        }
    }

    private List getDependencyReferences(IVirtualComponent component) {
        ArrayList<DependencyReference> refs = new ArrayList<DependencyReference>();
        IProject componentProject = component.getProject();
        IVirtualReference[] depRefs = component.getReferences();
        int i = 0;
        while (i < depRefs.length) {
            IVirtualComponent targetComponent = depRefs[i].getReferencedComponent();
            if (targetComponent != null) {
                IProject targetProject = targetComponent.getProject();
                refs.add(new DependencyReference(targetProject, componentProject));
            }
            ++i;
        }
        return refs;
    }

    private boolean addTimeStamp(IProject project) {
        IResource wtpModulesFile = this.getComponentFile(project);
        if (wtpModulesFile == null) {
            return false;
        }
        Long currentTimeStamp = new Long(wtpModulesFile.getModificationStamp());
        this.getWtpModuleTimeStamps().put(project, currentTimeStamp);
        IFile manifestFile = this.getTimeStampFile(project);
        if (manifestFile == null) {
            return false;
        }
        currentTimeStamp = new Long(manifestFile.getModificationStamp());
        this.getManifestTimeStamps().put(project, currentTimeStamp);
        return true;
    }

    private void cleanDependencyGraph() {
        DependencyGraph.getInstance().clear();
        this.getWtpModuleTimeStamps().clear();
        this.getManifestTimeStamps().clear();
        this.setModStamp(System.currentTimeMillis());
    }

    private HashMap getWtpModuleTimeStamps() {
        if (this.wtpModuleTimeStamps == null) {
            this.wtpModuleTimeStamps = new HashMap();
        }
        return this.wtpModuleTimeStamps;
    }

    public DependencyGraph getDependencyGraph() {
        this.constructIfNecessary();
        return DependencyGraph.getInstance();
    }

    public void forceRefresh() {
        this.buildDependencyGraph();
    }

    public long getModStamp() {
        return this.modStamp;
    }

    private void setModStamp(long modStamp) {
        this.modStamp = modStamp;
    }

    public boolean checkIfStillValid(long timeStamp) {
        return this.getModStamp() == timeStamp && !this.metadataChanged();
    }

    public boolean checkIfModuleTimeStampsStillValid(long timeStamp) {
        return this.getModStamp() == timeStamp && !this.moduleTimeStampsChanged();
    }

    private class DependencyReference {
        public IProject componentProject;
        public IProject targetProject;

        public DependencyReference(IProject target, IProject component) {
            this.componentProject = component;
            this.targetProject = target;
        }
    }
}

