/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.other;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.StructuredDocumentToTextAdapter;

public class StyledTextContentSpec
implements TextChangeListener {
    static String contentClassName;
    static int failCount;
    static int errorCount;
    Class contentClass = null;
    StyledTextContent contentInstance = null;
    int verify = 0;
    Method currentMethod = null;
    boolean failed = false;
    StyledText widget = null;
    Shell shell = null;

    static {
        failCount = 0;
        errorCount = 0;
    }

    public void assertWithMessage(String message, boolean condition) {
        System.out.print("\t" + this.currentMethod.getName() + " " + message);
        if (!condition) {
            this.fail(message);
        } else {
            System.out.println(" passed");
        }
    }

    public void fail(String message) {
        this.failed = true;
        System.out.println(" FAILED");
        ++failCount;
    }

    public StyledTextContent getContentInstance() {
        this.contentInstance.setText("");
        this.widget.setContent(this.contentInstance);
        ((StructuredDocumentToTextAdapter)this.contentInstance).setWidget(this.widget);
        return this.contentInstance;
    }

    public static String getTestText() {
        return "This is the first line.\r\nThis is the second line.\r\nThis is the third line.\r\nThis is the fourth line.\r\nThis is the fifth line.\r\n\r\nThis is the first line again.\r\nThis is the second line again.\r\nThis is the third line again.\r\nThis is the fourth line again.\r\nThis is the fifth line again.\r\n\r\nThis is the first line once again.\r\nThis is the second line once again.\r\nThis is the third line once again.\r\nThis is the fourth line once again.\r\nThis is the fifth line once again.";
    }

    public static void main(String[] args) {
        StyledTextContentSpec spec = new StyledTextContentSpec();
        if (args.length <= 0) {
            MessageBox box = new MessageBox(StyledTextContentSpec.getDisplay().getActiveShell(), 1);
            box.setMessage("Content class must be specified as an execution argument.");
            box.open();
            return;
        }
        contentClassName = args[0];
        spec.run();
        System.out.println();
        System.out.println(String.valueOf(failCount) + " TEST FAILURES.");
        System.out.println(String.valueOf(errorCount) + " UNEXPECTED ERRORS.");
    }

    private static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public void run() {
        if (contentClassName.equals("")) {
            MessageBox box = new MessageBox(StyledTextContentSpec.getDisplay().getActiveShell(), 1);
            box.setMessage("Content class must be specified as an execution argument.");
            box.open();
            return;
        }
        if (this.contentClass == null) {
            try {
                this.contentClass = Class.forName(contentClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                MessageBox box = new MessageBox(StyledTextContentSpec.getDisplay().getActiveShell(), 1);
                box.setMessage("Content class:\n" + contentClassName + "\nnot found");
                box.open();
                return;
            }
        }
        try {
            this.contentInstance = (StyledTextContent)this.contentClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            MessageBox box = new MessageBox(StyledTextContentSpec.getDisplay().getActiveShell(), 1);
            box.setMessage("Unable to access content class:\n" + contentClassName);
            box.open();
            return;
        }
        catch (InstantiationException instantiationException) {
            MessageBox box = new MessageBox(StyledTextContentSpec.getDisplay().getActiveShell(), 1);
            box.setMessage("Unable to instantiate content class:\n" + contentClassName);
            box.open();
            return;
        }
        Class<?> clazz = this.getClass();
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            this.setUp();
            this.currentMethod = methods[i];
            this.failed = false;
            try {
                if (this.currentMethod.getName().startsWith("test_")) {
                    System.out.println();
                    System.out.println(String.valueOf(this.currentMethod.getName()) + "...");
                    this.currentMethod.invoke((Object)this, new Object[0]);
                    if (!this.failed) {
                        System.out.println("PASSED.");
                    } else {
                        System.out.println("FAILED");
                    }
                }
            }
            catch (InvocationTargetException ex) {
                System.out.println("\t" + this.currentMethod.getName() + " ERROR ==> " + ex.getTargetException().toString());
                System.out.println("FAILED");
                ++errorCount;
            }
            catch (Exception ex) {
                System.out.println("\t" + this.currentMethod.getName() + " ERROR ==> " + ex.toString());
                System.out.println("FAILED");
                ++errorCount;
            }
            if (this.verify != 0) {
                this.verify = 0;
                this.contentInstance.removeTextChangeListener((TextChangeListener)this);
            }
            this.tearDown();
            ++i;
        }
    }

    protected void setUp() {
        this.shell = new Shell();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.shell.setSize(500, 300);
        this.shell.setLayout((Layout)layout);
        this.widget = new StyledText((Composite)this.shell, 2818);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.widget.setLayoutData((Object)spec);
        this.shell.open();
    }

    protected void tearDown() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.shell = null;
    }

    public void test_Delete() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\r");
        content.replaceTextRange(6, 2, "");
        String newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":1a:", newText.equals("This\nia test\r"));
        this.assertWithMessage(":1b:", content.getLine(0).equals("This"));
        this.assertWithMessage(":1c:", content.getLine(1).equals("ia test"));
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 9, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":2a:", newText.equals("This\n\r"));
        this.assertWithMessage(":2b:", content.getLineCount() == 3);
        this.assertWithMessage(":2c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":2d:", content.getLine(1).equals(""));
        this.assertWithMessage(":2e:", content.getLine(2).equals(""));
        content.setText("This\nis a test\nline 3\nline 4");
        content.replaceTextRange(21, 7, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":3a:", newText.equals("This\nis a test\nline 3"));
        this.assertWithMessage(":3b:", content.getLineCount() == 3);
        this.assertWithMessage(":3c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":3d:", content.getLine(1).equals("is a test"));
        this.assertWithMessage(":3e:", content.getLine(2).equals("line 3"));
        content.setText("This\nis a test\nline 3\nline 4");
        content.replaceTextRange(0, 5, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":4a:", newText.equals("is a test\nline 3\nline 4"));
        this.assertWithMessage(":4b:", content.getLineCount() == 3);
        this.assertWithMessage(":4c:", content.getLine(0).equals("is a test"));
        this.assertWithMessage(":4d:", content.getLine(1).equals("line 3"));
        this.assertWithMessage(":4e:", content.getLine(2).equals("line 4"));
        content.replaceTextRange(16, 7, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":4f:", newText.equals("is a test\nline 3"));
        this.assertWithMessage(":4g:", content.getLine(0).equals("is a test"));
        this.assertWithMessage(":4h:", content.getLine(1).equals("line 3"));
        content.replaceTextRange(9, 7, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":4i:", newText.equals("is a test"));
        this.assertWithMessage(":4j:", content.getLine(0).equals("is a test"));
        content.replaceTextRange(1, 8, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":4k:", newText.equals("i"));
        this.assertWithMessage(":4l:", content.getLine(0).equals("i"));
        content.replaceTextRange(0, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":4m:", newText.equals(""));
        this.assertWithMessage(":4n:", content.getLine(0).equals(""));
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 9, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":5a:", newText.equals("This\n\r"));
        this.assertWithMessage(":5b:", content.getLineCount() == 3);
        this.assertWithMessage(":5c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":5d:", content.getLine(1).equals(""));
        this.assertWithMessage(":5e:", content.getLine(2).equals(""));
        content.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        content.replaceTextRange(4, 8, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":6a:", newText.equals("L1\r\nL4\r\n"));
        this.assertWithMessage(":6b:", content.getLineCount() == 3);
        this.assertWithMessage(":6c:", content.getLine(0).equals("L1"));
        this.assertWithMessage(":6d:", content.getLine(1).equals("L4"));
        this.assertWithMessage(":6e:", content.getLine(2).equals(""));
        content.setText("\nL1\r\nL2");
        content.replaceTextRange(0, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":7a:", newText.equals("L1\r\nL2"));
        this.assertWithMessage(":7b:", content.getLineCount() == 2);
        this.assertWithMessage(":7c:", content.getLine(0).equals("L1"));
        this.assertWithMessage(":7d:", content.getLine(1).equals("L2"));
        content.setText("\nL1\r\nL2\r\n");
        content.replaceTextRange(7, 2, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":8a:", newText.equals("\nL1\r\nL2"));
        this.assertWithMessage(":8b:", content.getLineCount() == 3);
        this.assertWithMessage(":8c:", content.getLine(0).equals(""));
        this.assertWithMessage(":8d:", content.getLine(1).equals("L1"));
        this.assertWithMessage(":8e:", content.getLine(2).equals("L2"));
        content.setText("\nLine 1\nLine 2\n");
        content.replaceTextRange(0, 7, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":9a:", newText.equals("\nLine 2\n"));
        this.assertWithMessage(":9b:", content.getLineCount() == 3);
        this.assertWithMessage(":9c:", content.getLine(0).equals(""));
        this.assertWithMessage(":9d:", content.getLine(1).equals("Line 2"));
        this.assertWithMessage(":9e:", content.getLine(2).equals(""));
        content.setText("Line 1\nLine 2\n");
        content.replaceTextRange(6, 8, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":10a:", newText.equals("Line 1"));
        this.assertWithMessage(":10b:", content.getLineCount() == 1);
        this.assertWithMessage(":10c:", content.getLine(0).equals("Line 1"));
        content.setText("Line one is short\r\nLine 2 is a longer line\r\nLine 3\n");
        content.replaceTextRange(12, 17, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":11a:", newText.equals("Line one is a longer line\r\nLine 3\n"));
        this.assertWithMessage(":11b:", content.getLineCount() == 3);
        this.assertWithMessage(":11c:", content.getLine(0).equals("Line one is a longer line"));
        this.assertWithMessage(":11d:", content.getLine(1).equals("Line 3"));
        this.assertWithMessage(":11e:", content.getLine(2).equals(""));
    }

    public void test_Empty() {
        StyledTextContent content = this.getContentInstance();
        this.assertWithMessage(":1a:", content.getLineCount() == 1);
        this.assertWithMessage(":1b:", content.getLine(0).equals(""));
        content.setText("test");
        content.replaceTextRange(0, 4, "");
        this.assertWithMessage(":2a:", content.getLineCount() == 1);
        this.assertWithMessage(":2b:", content.getLine(0).equals(""));
    }

    public void test_Insert() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\r");
        content.replaceTextRange(0, 0, "test\n ");
        String newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":1a:", newText.equals("test\n This\nis a test\r"));
        this.assertWithMessage(":1b:", content.getLineCount() == 4);
        this.assertWithMessage(":1c:", content.getLine(0).equals("test"));
        this.assertWithMessage(":1d:", content.getLine(1).equals(" This"));
        this.assertWithMessage(":1e:", content.getLine(2).equals("is a test"));
        this.assertWithMessage(":1f:", content.getLine(3).equals(""));
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 0, "*** ");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":2a:", newText.equals("This\n*** is a test\r"));
        this.assertWithMessage(":2b:", content.getLineCount() == 3);
        this.assertWithMessage(":2c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":2d:", content.getLine(1).equals("*** is a test"));
        this.assertWithMessage(":2e:", content.getLine(2).equals(""));
        content.setText("Line 1\r\nLine 2");
        content.replaceTextRange(0, 0, "\r");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":3a:", newText.equals("\rLine 1\r\nLine 2"));
        this.assertWithMessage(":3b:", content.getLineCount() == 3);
        this.assertWithMessage(":3c:", content.getLine(0).equals(""));
        this.assertWithMessage(":3d:", content.getLine(1).equals("Line 1"));
        this.assertWithMessage(":3e:", content.getLine(2).equals("Line 2"));
        content.replaceTextRange(9, 0, "\r");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":3f:", newText.equals("\rLine 1\r\n\rLine 2"));
        this.assertWithMessage(":3g:", content.getLineCount() == 4);
        this.assertWithMessage(":3h:", content.getLine(0).equals(""));
        this.assertWithMessage(":3i:", content.getLine(1).equals("Line 1"));
        this.assertWithMessage(":3j:", content.getLine(2).equals(""));
        this.assertWithMessage(":3k:", content.getLine(3).equals("Line 2"));
        content.setText("This\nis a test\r");
        content.replaceTextRange(0, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":4a:", newText.equals("\nThis\nis a test\r"));
        this.assertWithMessage(":4b:", content.getLineCount() == 4);
        this.assertWithMessage(":4c:", content.getLine(0).equals(""));
        this.assertWithMessage(":4d:", content.getLine(1).equals("This"));
        this.assertWithMessage(":4e:", content.getLine(2).equals("is a test"));
        this.assertWithMessage(":4f:", content.getLine(3).equals(""));
        content.setText("This\nis a test\r");
        content.replaceTextRange(7, 0, "\r\nnewLine");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":5a:", newText.equals("This\nis\r\nnewLine a test\r"));
        this.assertWithMessage(":5b:", content.getLineCount() == 4);
        this.assertWithMessage(":5c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":5d:", content.getLine(1).equals("is"));
        this.assertWithMessage(":5e:", content.getLine(2).equals("newLine a test"));
        this.assertWithMessage(":5f:", content.getLine(3).equals(""));
        content.setText("");
        content.replaceTextRange(0, 0, "This\nis\r\nnewLine a test\r");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":6a:", newText.equals("This\nis\r\nnewLine a test\r"));
        this.assertWithMessage(":6b:", content.getLineCount() == 4);
        this.assertWithMessage(":6c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":6d:", content.getLine(1).equals("is"));
        this.assertWithMessage(":6e:", content.getLine(2).equals("newLine a test"));
        this.assertWithMessage(":6f:", content.getLine(3).equals(""));
        content.setText("This");
        content.replaceTextRange(4, 0, "\n ");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":7a:", newText.equals("This\n "));
        this.assertWithMessage(":7b:", content.getLineCount() == 2);
        this.assertWithMessage(":7c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":7d:", content.getLine(1).equals(" "));
        content.setText("This\n");
        content.replaceTextRange(5, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":7e:", newText.equals("This\n\n"));
        this.assertWithMessage(":7f:", content.getLineCount() == 3);
        this.assertWithMessage(":7g:", content.getLine(0).equals("This"));
        this.assertWithMessage(":7h:", content.getLine(1).equals(""));
        this.assertWithMessage(":7i:", content.getLine(2).equals(""));
        content.setText("This");
        content.replaceTextRange(0, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":8a:", newText.equals("\nThis"));
        this.assertWithMessage(":8b:", content.getLineCount() == 2);
        this.assertWithMessage(":8c:", content.getLine(0).equals(""));
        this.assertWithMessage(":8d:", content.getLine(1).equals("This"));
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 0, "*** ");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":9a:", newText.equals("This\n*** is a test\r"));
        this.assertWithMessage(":9b:", content.getLineCount() == 3);
        this.assertWithMessage(":9c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":9d:", content.getLine(1).equals("*** is a test"));
        this.assertWithMessage(":9e:", content.getLine(2).equals(""));
        content.setText("This\n");
        content.replaceTextRange(5, 0, "line");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":10a:", newText.equals("This\nline"));
        this.assertWithMessage(":10b:", content.getLineCount() == 2);
        this.assertWithMessage(":10c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":10d:", content.getLine(1).equals("line"));
        this.assertWithMessage(":10e:", content.getLineAtOffset(8) == 1);
        this.assertWithMessage(":10f:", content.getLineAtOffset(9) == 1);
        content.setText("This\n");
        content.replaceTextRange(0, 0, "line\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":11a:", newText.equals("line\nThis\n"));
        this.assertWithMessage(":11b:", content.getLineCount() == 3);
        this.assertWithMessage(":11c:", content.getLine(0).equals("line"));
        this.assertWithMessage(":11d:", content.getLine(1).equals("This"));
        this.assertWithMessage(":11e:", content.getLineAtOffset(5) == 1);
        content.setText("Line 1\r\nLine 2\r\nLine 3");
        content.replaceTextRange(0, 0, "\r");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":12a:", newText.equals("\rLine 1\r\nLine 2\r\nLine 3"));
        this.assertWithMessage(":12b:", content.getLineCount() == 4);
        this.assertWithMessage(":12c:", content.getLine(0).equals(""));
        this.assertWithMessage(":12d:", content.getLine(1).equals("Line 1"));
        this.assertWithMessage(":12e:", content.getLine(2).equals("Line 2"));
        this.assertWithMessage(":12f:", content.getLine(3).equals("Line 3"));
        content.setText("Line 1\nLine 2\nLine 3");
        content.replaceTextRange(7, 0, "Line1a\nLine1b\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":13a:", newText.equals("Line 1\nLine1a\nLine1b\nLine 2\nLine 3"));
        this.assertWithMessage(":13b:", content.getLineCount() == 5);
        this.assertWithMessage(":13c:", content.getLine(0).equals("Line 1"));
        this.assertWithMessage(":13d:", content.getLine(1).equals("Line1a"));
        this.assertWithMessage(":13e:", content.getLine(2).equals("Line1b"));
        this.assertWithMessage(":13f:", content.getLine(3).equals("Line 2"));
        this.assertWithMessage(":13g:", content.getLine(4).equals("Line 3"));
        content.setText("Line 1\nLine 2\nLine 3");
        content.replaceTextRange(11, 0, "l1a");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":14a:", newText.equals("Line 1\nLinel1a 2\nLine 3"));
        this.assertWithMessage(":14b:", content.getLineCount() == 3);
        this.assertWithMessage(":14c:", content.getLine(0).equals("Line 1"));
        this.assertWithMessage(":14d:", content.getLine(1).equals("Linel1a 2"));
        this.assertWithMessage(":14e:", content.getLine(2).equals("Line 3"));
        content.setText("Line 1\nLine 2 is a very long line that spans many words\nLine 3");
        content.replaceTextRange(19, 0, "very, very, ");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":15a:", newText.equals("Line 1\nLine 2 is a very, very, very long line that spans many words\nLine 3"));
        this.assertWithMessage(":15b:", content.getLineCount() == 3);
        this.assertWithMessage(":15c:", content.getLine(0).equals("Line 1"));
        this.assertWithMessage(":15d:", content.getLine(1).equals("Line 2 is a very, very, very long line that spans many words"));
        this.assertWithMessage(":15e:", content.getLine(2).equals("Line 3"));
    }

    public void test_Line_Conversion() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\rrepeat\nend\r");
        this.assertWithMessage(":1a:", content.getLineCount() == 5);
        this.assertWithMessage(":1b:", content.getLine(0).equals("This"));
        this.assertWithMessage(":1c:", content.getOffsetAtLine(0) == 0);
        this.assertWithMessage(":1d:", content.getLine(1).equals("is a test"));
        this.assertWithMessage(":1e:", content.getLineAtOffset(4) == 0);
        this.assertWithMessage(":1f:", content.getOffsetAtLine(1) == 5);
        this.assertWithMessage(":1g:", content.getLine(2).equals("repeat"));
        this.assertWithMessage(":1h:", content.getOffsetAtLine(2) == 15);
        this.assertWithMessage(":1i:", content.getLine(3).equals("end"));
        this.assertWithMessage(":1j:", content.getOffsetAtLine(3) == 22);
        this.assertWithMessage(":1k:", content.getLine(4).equals(""));
        this.assertWithMessage(":1l:", content.getOffsetAtLine(4) == 26);
        content.setText("This\r\nis a test");
        this.assertWithMessage(":2a:", content.getLineCount() == 2);
        this.assertWithMessage(":2b:", content.getLine(1).equals("is a test"));
        this.assertWithMessage(":2c:", content.getLineAtOffset(4) == 0);
        this.assertWithMessage(":2d:", content.getLineAtOffset(5) == 0);
        content.setText("This\r\nis a test\r");
        this.assertWithMessage(":3a:", content.getLineCount() == 3);
        this.assertWithMessage(":3b:", content.getLine(1).equals("is a test"));
        this.assertWithMessage(":3c:", content.getLineAtOffset(15) == 1);
        content.setText("\r\n");
        this.assertWithMessage(":4a:", content.getLineCount() == 2);
        this.assertWithMessage(":4b:", content.getLine(0).equals(""));
        this.assertWithMessage(":4c:", content.getLine(1).equals(""));
        this.assertWithMessage(":4d:", content.getLineAtOffset(0) == 0);
        this.assertWithMessage(":4e:", content.getLineAtOffset(1) == 0);
        this.assertWithMessage(":4f:", content.getLineAtOffset(2) == 1);
        content.setText("\r\n\n\r\r\n");
        this.assertWithMessage(":5a:", content.getLineCount() == 5);
        this.assertWithMessage(":5b:", content.getLine(0).equals(""));
        this.assertWithMessage(":5c:", content.getOffsetAtLine(0) == 0);
        this.assertWithMessage(":5d:", content.getLine(1).equals(""));
        this.assertWithMessage(":5e:", content.getOffsetAtLine(1) == 2);
        this.assertWithMessage(":5f:", content.getLine(2).equals(""));
        this.assertWithMessage(":5g:", content.getOffsetAtLine(2) == 3);
        this.assertWithMessage(":5h:", content.getLine(3).equals(""));
        this.assertWithMessage(":5i:", content.getOffsetAtLine(3) == 4);
        this.assertWithMessage(":5j:", content.getLine(4).equals(""));
        this.assertWithMessage(":5k:", content.getOffsetAtLine(4) == 6);
        content.setText("test\r\rtest2\r\r");
        this.assertWithMessage(":6a:", content.getLineCount() == 5);
        this.assertWithMessage(":6b:", content.getLine(0).equals("test"));
        this.assertWithMessage(":6c:", content.getOffsetAtLine(0) == 0);
        this.assertWithMessage(":6d:", content.getLine(1).equals(""));
        this.assertWithMessage(":6e:", content.getOffsetAtLine(1) == 5);
        this.assertWithMessage(":6f:", content.getLine(2).equals("test2"));
        this.assertWithMessage(":6g:", content.getOffsetAtLine(2) == 6);
        this.assertWithMessage(":6h:", content.getLine(3).equals(""));
        this.assertWithMessage(":6i:", content.getOffsetAtLine(3) == 12);
        this.assertWithMessage(":6j:", content.getLine(4).equals(""));
        this.assertWithMessage(":6k:", content.getOffsetAtLine(4) == 13);
    }

    public void test_Line_To_Offset() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\rrepeat\nend\r");
        this.assertWithMessage(":1a:", content.getOffsetAtLine(0) == 0);
        this.assertWithMessage(":1b:", content.getOffsetAtLine(1) == 5);
        this.assertWithMessage(":1c:", content.getOffsetAtLine(2) == 15);
        this.assertWithMessage(":1d:", content.getOffsetAtLine(3) == 22);
        this.assertWithMessage(":1e:", content.getOffsetAtLine(4) == 26);
        content.setText("This\r\nis a test");
        this.assertWithMessage(":2a:", content.getOffsetAtLine(0) == 0);
        this.assertWithMessage(":2b:", content.getOffsetAtLine(1) == 6);
        content.setText("\r\n");
        this.assertWithMessage(":3a:", content.getOffsetAtLine(0) == 0);
        this.assertWithMessage(":3b:", content.getOffsetAtLine(1) == 2);
        content.setText("\r\n\n\r\r\n");
        this.assertWithMessage(":4a:", content.getOffsetAtLine(0) == 0);
        this.assertWithMessage(":4b:", content.getOffsetAtLine(1) == 2);
        this.assertWithMessage(":4c:", content.getOffsetAtLine(2) == 3);
        this.assertWithMessage(":4d:", content.getOffsetAtLine(3) == 4);
        this.assertWithMessage(":4e:", content.getOffsetAtLine(4) == 6);
        content.setText("\r\ntest\r\n");
        this.assertWithMessage(":5a:", content.getOffsetAtLine(0) == 0);
        this.assertWithMessage(":5b:", content.getOffsetAtLine(1) == 2);
        this.assertWithMessage(":5c:", content.getOffsetAtLine(2) == 8);
    }

    public void test_Offset_To_Line() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\rrepeat\nend\r");
        this.assertWithMessage(":1a:", content.getLineAtOffset(0) == 0);
        this.assertWithMessage(":1b:", content.getLineAtOffset(3) == 0);
        this.assertWithMessage(":1c:", content.getLineAtOffset(4) == 0);
        this.assertWithMessage(":1d:", content.getLineAtOffset(25) == 3);
        this.assertWithMessage(":1e:", content.getLineAtOffset(26) == 4);
        content.setText("This\r\nis a test");
        this.assertWithMessage(":2a:", content.getLineAtOffset(5) == 0);
        this.assertWithMessage(":2b:", content.getLineAtOffset(6) == 1);
        this.assertWithMessage(":2c:", content.getLineAtOffset(10) == 1);
        content.setText("\r\n");
        this.assertWithMessage(":3a:", content.getLineAtOffset(0) == 0);
        this.assertWithMessage(":3b:", content.getLineAtOffset(1) == 0);
        this.assertWithMessage(":3c:", content.getLineAtOffset(2) == 1);
        content.setText("\r\n\n\r\r\n");
        this.assertWithMessage(":4a:", content.getLineAtOffset(0) == 0);
        this.assertWithMessage(":4b:", content.getLineAtOffset(1) == 0);
        this.assertWithMessage(":4c:", content.getLineAtOffset(2) == 1);
        this.assertWithMessage(":4d:", content.getLineAtOffset(3) == 2);
        this.assertWithMessage(":4e:", content.getLineAtOffset(4) == 3);
        this.assertWithMessage(":4f:", content.getLineAtOffset(5) == 3);
        this.assertWithMessage(":4g:", content.getLineAtOffset(6) == 4);
        content.setText("\r\n\r\n");
        this.assertWithMessage(":5a:", content.getLineAtOffset(0) == 0);
        this.assertWithMessage(":5b:", content.getLineAtOffset(1) == 0);
        this.assertWithMessage(":5c:", content.getLineAtOffset(2) == 1);
        this.assertWithMessage(":5d:", content.getLineAtOffset(3) == 1);
        this.assertWithMessage(":5e:", content.getLineAtOffset(4) == 2);
        content.setText("\r\r\r\n\r\n");
        this.assertWithMessage(":6a:", content.getLineAtOffset(0) == 0);
        this.assertWithMessage(":6b:", content.getLineAtOffset(1) == 1);
        this.assertWithMessage(":6c:", content.getLineAtOffset(2) == 2);
        this.assertWithMessage(":6d:", content.getLineAtOffset(4) == 3);
        content.setText("");
        this.assertWithMessage(":7a:", content.getLineAtOffset(0) == 0);
        content = this.getContentInstance();
        this.assertWithMessage(":8a:", content.getLineAtOffset(0) == 0);
    }

    public void test_Replace() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 4, "a");
        String newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":1a:", newText.equals("This\na test\r"));
        this.assertWithMessage(":1b:", content.getLineCount() == 3);
        this.assertWithMessage(":1c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":1d:", content.getLine(1).equals("a test"));
        this.assertWithMessage(":1e:", content.getLine(2).equals(""));
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 2, "was");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":2a:", newText.equals("This\nwas a test\r"));
        this.assertWithMessage(":2b:", content.getLineCount() == 3);
        this.assertWithMessage(":2c:", content.getLine(0).equals("This"));
        this.assertWithMessage(":2d:", content.getLine(1).equals("was a test"));
        this.assertWithMessage(":2e:", content.getLine(2).equals(""));
        content.setText("This is a test\r");
        content.replaceTextRange(5, 2, "was");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":3a:", newText.equals("This was a test\r"));
        this.assertWithMessage(":3b:", content.getLineCount() == 2);
        this.assertWithMessage(":3c:", content.getLine(0).equals("This was a test"));
        this.assertWithMessage(":3d:", content.getLineAtOffset(15) == 0);
        content.setText("Line 1\nLine 2\nLine 3");
        content.replaceTextRange(0, 7, "La\nLb\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":4a:", newText.equals("La\nLb\nLine 2\nLine 3"));
        this.assertWithMessage(":4b:", content.getLine(0).equals("La"));
        this.assertWithMessage(":4c:", content.getLine(1).equals("Lb"));
        this.assertWithMessage(":4d:", content.getLine(2).equals("Line 2"));
        this.assertWithMessage(":4e:", content.getLine(3).equals("Line 3"));
        content.setText(StyledTextContentSpec.getTestText());
        newText = content.getTextRange(0, content.getCharCount());
        int start = content.getOffsetAtLine(6);
        int end = content.getOffsetAtLine(11);
        content.replaceTextRange(start, end - start, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":5a:", content.getLineCount() == 12);
        this.assertWithMessage(":5a:", content.getLine(5).equals(""));
        this.assertWithMessage(":5a:", content.getLine(6).equals(""));
        start = content.getOffsetAtLine(7);
        content.replaceTextRange(start, content.getCharCount() - start, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":5a:", content.getLineCount() == 8);
        this.assertWithMessage(":5a:", content.getLine(5).equals(""));
        this.assertWithMessage(":5a:", content.getLine(6).equals(""));
        this.assertWithMessage(":5a:", content.getLine(7).equals(""));
    }

    public void test_Special_Cases() {
        StyledTextContent content = this.getContentInstance();
        this.assertWithMessage(":0a:", content.getLineCount() == 1);
        this.assertWithMessage(":0b:", content.getOffsetAtLine(0) == 0);
        content.setText("This is the input/output text component.");
        content.replaceTextRange(0, 0, "\n");
        this.assertWithMessage(":1a:", content.getLine(0).equals(""));
        content.replaceTextRange(1, 0, "\n");
        this.assertWithMessage(":1b:", content.getLine(0).equals(""));
        content.replaceTextRange(2, 0, "\n");
        this.assertWithMessage(":1c:", content.getLine(0).equals(""));
        content.replaceTextRange(3, 0, "\n");
        this.assertWithMessage(":1d:", content.getLine(0).equals(""));
        content.replaceTextRange(4, 0, "\n");
        this.assertWithMessage(":1e:", content.getLine(0).equals(""));
        content.replaceTextRange(5, 0, "\n");
        this.assertWithMessage(":1f:", content.getLine(0).equals(""));
        content.replaceTextRange(6, 0, "\n");
        this.assertWithMessage(":1g:", content.getLine(0).equals(""));
        content.replaceTextRange(7, 0, "\n");
        this.assertWithMessage(":1h:", content.getLine(0).equals(""));
        content.setText("This is the input/output text component.");
        content.replaceTextRange(0, 0, "\n");
        String newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":2a:", newText.equals("\nThis is the input/output text component."));
        this.assertWithMessage(":2b:", content.getLine(0).equals(""));
        this.assertWithMessage(":2c:", content.getLine(1).equals("This is the input/output text component."));
        content.replaceTextRange(1, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":2d:", newText.equals("\n\nThis is the input/output text component."));
        this.assertWithMessage(":2e:", content.getLine(0).equals(""));
        this.assertWithMessage(":2f:", content.getLine(1).equals(""));
        this.assertWithMessage(":2g:", content.getLine(2).equals("This is the input/output text component."));
        content.replaceTextRange(2, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":3a:", newText.equals("\n\n\nThis is the input/output text component."));
        this.assertWithMessage(":3b:", content.getLine(0).equals(""));
        this.assertWithMessage(":3c:", content.getLine(1).equals(""));
        this.assertWithMessage(":3d:", content.getLine(2).equals(""));
        this.assertWithMessage(":3e:", content.getLine(3).equals("This is the input/output text component."));
        content.replaceTextRange(3, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":3f:", newText.equals("\n\n\n\nThis is the input/output text component."));
        this.assertWithMessage(":3g:", content.getLine(0).equals(""));
        this.assertWithMessage(":3h:", content.getLine(1).equals(""));
        this.assertWithMessage(":3i:", content.getLine(2).equals(""));
        this.assertWithMessage(":3j:", content.getLine(3).equals(""));
        this.assertWithMessage(":3k:", content.getLine(4).equals("This is the input/output text component."));
        content.replaceTextRange(3, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":4a:", newText.equals("\n\n\nThis is the input/output text component."));
        this.assertWithMessage(":4b:", content.getLine(0).equals(""));
        this.assertWithMessage(":4c:", content.getLine(1).equals(""));
        this.assertWithMessage(":4d:", content.getLine(2).equals(""));
        this.assertWithMessage(":4e:", content.getLine(3).equals("This is the input/output text component."));
        content.replaceTextRange(2, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":4f:", newText.equals("\n\nThis is the input/output text component."));
        this.assertWithMessage(":4g:", content.getLine(0).equals(""));
        this.assertWithMessage(":4h:", content.getLine(1).equals(""));
        this.assertWithMessage(":4i:", content.getLine(2).equals("This is the input/output text component."));
        content.replaceTextRange(2, 0, "a");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":5a:", newText.equals("\n\naThis is the input/output text component."));
        this.assertWithMessage(":5b:", content.getLine(0).equals(""));
        this.assertWithMessage(":5c:", content.getLine(1).equals(""));
        this.assertWithMessage(":5d:", content.getLine(2).equals("aThis is the input/output text component."));
        content.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        content.replaceTextRange(0, 3, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":5e:", newText.equals("\nL2\r\nL3\r\nL4\r\n"));
        this.assertWithMessage(":5f:", content.getLineCount() == 5);
        this.assertWithMessage(":5g:", content.getLine(0).equals(""));
        this.assertWithMessage(":5h:", content.getLine(1).equals("L2"));
        this.assertWithMessage(":5i:", content.getLine(2).equals("L3"));
        this.assertWithMessage(":5j:", content.getLine(3).equals("L4"));
        this.assertWithMessage(":5k:", content.getLine(4).equals(""));
        content.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        content.replaceTextRange(3, 1, "test\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":6a:", newText.equals("L1\rtest\nL2\r\nL3\r\nL4\r\n"));
        this.assertWithMessage(":6b:", content.getLineCount() == 6);
        this.assertWithMessage(":6c:", content.getLine(0).equals("L1"));
        this.assertWithMessage(":6d:", content.getLine(1).equals("test"));
        this.assertWithMessage(":6e:", content.getLine(2).equals("L2"));
        this.assertWithMessage(":6f:", content.getLine(3).equals("L3"));
        this.assertWithMessage(":6g:", content.getLine(4).equals("L4"));
        this.assertWithMessage(":6h:", content.getLine(5).equals(""));
        content.setText("abc\r\ndef");
        content.replaceTextRange(1, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":7a:", newText.equals("ac\r\ndef"));
        this.assertWithMessage(":7b:", content.getLineCount() == 2);
        this.assertWithMessage(":7c:", content.getLine(0).equals("ac"));
        this.assertWithMessage(":7d:", content.getLine(1).equals("def"));
        content.replaceTextRange(1, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":7e:", newText.equals("a\r\ndef"));
        this.assertWithMessage(":7f:", content.getLineCount() == 2);
        this.assertWithMessage(":7g:", content.getLine(0).equals("a"));
        this.assertWithMessage(":7h:", content.getLine(1).equals("def"));
        content.replaceTextRange(1, 2, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":7i:", newText.equals("adef"));
        this.assertWithMessage(":7j:", content.getLineCount() == 1);
        this.assertWithMessage(":7k:", content.getLine(0).equals("adef"));
        content.replaceTextRange(1, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":7l:", newText.equals("aef"));
        this.assertWithMessage(":7m:", content.getLineCount() == 1);
        this.assertWithMessage(":7n:", content.getLine(0).equals("aef"));
        content.replaceTextRange(1, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":7o:", newText.equals("af"));
        this.assertWithMessage(":7p:", content.getLineCount() == 1);
        this.assertWithMessage(":7q:", content.getLine(0).equals("af"));
        content.setText("abc");
        content.replaceTextRange(0, 1, "1");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":8a:", content.getLineCount() == 1);
        this.assertWithMessage(":8b:", newText.equals("1bc"));
        this.assertWithMessage(":8c:", content.getLine(0).equals("1bc"));
        content.replaceTextRange(0, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":8d:", newText.equals("\n1bc"));
        this.assertWithMessage(":8e:", content.getLineCount() == 2);
        this.assertWithMessage(":8f:", content.getLine(0).equals(""));
        this.assertWithMessage(":8g:", content.getLine(1).equals("1bc"));
        content = this.getContentInstance();
        content.replaceTextRange(0, 0, "a");
        content.setText("package test;\n/* Line 1\n * Line 2\n */\npublic class SimpleClass {\n}");
        content.replaceTextRange(14, 23, "\t/*Line 1\n\t * Line 2\n\t */");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertWithMessage(":9a:", newText.equals("package test;\n\t/*Line 1\n\t * Line 2\n\t */\npublic class SimpleClass {\n}"));
        this.assertWithMessage(":9b:", content.getLineCount() == 6);
        this.assertWithMessage(":9c:", content.getLine(0).equals("package test;"));
        this.assertWithMessage(":9d:", content.getLine(1).equals("\t/*Line 1"));
        this.assertWithMessage(":9e:", content.getLine(2).equals("\t * Line 2"));
        this.assertWithMessage(":9f:", content.getLine(3).equals("\t */"));
        this.assertWithMessage(":9g:", content.getLine(4).equals("public class SimpleClass {"));
        this.assertWithMessage(":9h:", content.getLine(5).equals("}"));
    }

    public void test_Text_Changed_Event() {
        StyledTextContent content = this.getContentInstance();
        content.addTextChangeListener((TextChangeListener)this);
        this.verify = 1;
        content.setText("testing");
        content.replaceTextRange(0, 0, "\n");
        this.verify = 2;
        content.setText("\n\n");
        content.replaceTextRange(0, 2, "a");
        this.verify = 3;
        content.setText("a");
        content.replaceTextRange(0, 1, "\n\n");
        this.verify = 5;
        content.setText("Line 1\r\nLine 2");
        content.replaceTextRange(0, 0, "\r");
        this.verify = 6;
        content.setText("This\nis a test\nline 3\nline 4");
        content.replaceTextRange(21, 7, "");
        this.verify = 7;
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 9, "");
        this.verify = 8;
        content.setText("\nL1\r\nL2\r\n");
        content.replaceTextRange(7, 2, "");
        this.verify = 9;
        content.setText("L1\r\n");
        content.replaceTextRange(2, 2, "test");
        this.verify = 0;
        content.removeTextChangeListener((TextChangeListener)this);
    }

    public void textChanged(TextChangedEvent event) {
    }

    public void textChanging(TextChangingEvent event) {
        switch (this.verify) {
            case 1: {
                this.assertWithMessage(":1a:", event.replaceLineCount == 0);
                this.assertWithMessage(":1b:", event.newLineCount == 1);
                break;
            }
            case 2: {
                this.assertWithMessage(":2a:", event.replaceLineCount == 2);
                this.assertWithMessage(":2b:", event.newLineCount == 0);
                break;
            }
            case 3: {
                this.assertWithMessage(":3a:", event.replaceLineCount == 0);
                this.assertWithMessage(":3b:", event.newLineCount == 2);
                break;
            }
            case 4: {
                this.assertWithMessage(":4a:", event.replaceLineCount == 0);
                this.assertWithMessage(":4b:", event.newLineCount == 1);
                break;
            }
            case 5: {
                this.assertWithMessage(":5a:", event.replaceLineCount == 0);
                this.assertWithMessage(":5b:", event.newLineCount == 1);
                break;
            }
            case 6: {
                this.assertWithMessage(":6a:", event.replaceLineCount == 1);
                this.assertWithMessage(":6b:", event.newLineCount == 0);
                break;
            }
            case 8: {
                this.assertWithMessage(":8a:", event.replaceLineCount == 1);
                this.assertWithMessage(":8b:", event.newLineCount == 0);
                break;
            }
            case 9: {
                this.assertWithMessage(":9a:", event.replaceLineCount == 1);
                this.assertWithMessage(":9b:", event.newLineCount == 0);
                break;
            }
            case 10: {
                this.assertWithMessage(":10a:", event.replaceLineCount == 0);
                this.assertWithMessage(":10b:", event.newLineCount == 0);
                break;
            }
            case 11: {
                this.assertWithMessage(":11a:", event.replaceLineCount == 0);
                this.assertWithMessage(":11b:", event.newLineCount == 0);
                break;
            }
            case 12: {
                this.assertWithMessage(":12a:", event.replaceLineCount == 0);
                this.assertWithMessage(":12b:", event.newLineCount == 0);
                break;
            }
            case 13: {
                this.assertWithMessage(":13a:", event.replaceLineCount == 0);
                this.assertWithMessage(":13b:", event.newLineCount == 0);
                break;
            }
            case 14: {
                this.assertWithMessage(":14a:", event.replaceLineCount == 0);
                this.assertWithMessage(":14b:", event.newLineCount == 1);
                break;
            }
            case 15: {
                this.assertWithMessage(":15a:", event.replaceLineCount == 1);
                this.assertWithMessage(":15b:", event.newLineCount == 2);
                break;
            }
            case 16: {
                this.assertWithMessage(":16a:", event.replaceLineCount == 0);
                this.assertWithMessage(":16b:", event.newLineCount == 1);
                break;
            }
            case 17: {
                this.assertWithMessage(":17a:", event.replaceLineCount == 0);
                this.assertWithMessage(":17b:", event.newLineCount == 2);
                break;
            }
            case 18: {
                this.assertWithMessage(":18a:", event.replaceLineCount == 0);
                this.assertWithMessage(":18b:", event.newLineCount == 1);
                break;
            }
            case 19: {
                this.assertWithMessage(":19a:", event.replaceLineCount == 0);
                this.assertWithMessage(":19b:", event.newLineCount == 4);
                break;
            }
            case 20: {
                this.assertWithMessage(":20a:", event.replaceLineCount == 0);
                this.assertWithMessage(":20b:", event.newLineCount == 2);
            }
        }
    }

    public void textSet(TextChangedEvent event) {
    }
}

