/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.contentdescription;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.IContentDescriptionForJSP;
import org.eclipse.jst.jsp.ui.tests.document.UnzippedProjectTester;

public class TestContentDescription
extends UnzippedProjectTester {
    public void testNoXMLPIWithJSPSyntax() {
        HashMap<QualifiedName, String> expectedProperties = new HashMap<QualifiedName, String>();
        expectedProperties.put(IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE, "text/xml");
        expectedProperties.put(IContentDescription.CHARSET, "UTF-8");
        this.doTestContentDescription("/content-description/PurchaseOrder-no-XMLPI-jsp-syntax.jsp", expectedProperties);
    }

    public void testWithXMLPIWithJSPSyntax() {
        HashMap<QualifiedName, String> expectedProperties = new HashMap<QualifiedName, String>();
        expectedProperties.put(IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE, "text/xml");
        expectedProperties.put(IContentDescription.CHARSET, "UTF-8");
        this.doTestContentDescription("/content-description/PurchaseOrder-with-XMLPI-jsp-syntax.jsp", expectedProperties);
    }

    public void testWithXMLPIWithXMLSyntax() {
        HashMap<QualifiedName, String> expectedProperties = new HashMap<QualifiedName, String>();
        expectedProperties.put(IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE, "text/xml");
        expectedProperties.put(IContentDescription.CHARSET, "UTF-8");
        this.doTestContentDescription("/content-description/PurchaseOrder-with-XMLPI-xml-syntax.jsp", expectedProperties);
    }

    public void testJSPWithHTMLOutput() {
        HashMap<QualifiedName, String> expectedProperties = new HashMap<QualifiedName, String>();
        expectedProperties.put(IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE, "text/html");
        this.doTestContentDescription("/content-description/html.jsp", expectedProperties);
    }

    public void testJSPWithXHTMLOutput() {
        HashMap<QualifiedName, String> expectedProperties = new HashMap<QualifiedName, String>();
        expectedProperties.put(IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE, "text/xhtml");
        this.doTestContentDescription("/content-description/xhtml.jsp", expectedProperties);
    }

    public void testJSPWithXMLOutput() {
        HashMap<QualifiedName, String> expectedProperties = new HashMap<QualifiedName, String>();
        expectedProperties.put(IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE, "text/xml");
        this.doTestContentDescription("/content-description/xml.jsp", expectedProperties);
    }

    private void doTestContentDescription(String filePath, HashMap expectedProperties) {
        IContentDescription desc = this.getContentDescription(filePath);
        TestContentDescription.assertNotNull((String)("couldn't get IContentDescription for file:[" + filePath + "]"), (Object)desc);
        Object[] keys = expectedProperties.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            Object expected = expectedProperties.get(keys[i]);
            Object detected = desc.getProperty((QualifiedName)keys[i]);
            TestContentDescription.assertEquals((String)"unexpected property value", expected, (Object)detected);
            ++i;
        }
    }

    private IContentDescription getContentDescription(String filePath) {
        if (filePath == null) {
            return null;
        }
        InputStream in = null;
        try {
            IFile wsFile = FileBuffers.getWorkspaceFileAtLocation((IPath)new Path(filePath));
            if (wsFile != null && wsFile.exists()) {
                in = wsFile.getContents();
            } else {
                File sFile = FileBuffers.getSystemFileAtLocation((IPath)new Path(filePath));
                if (sFile != null && sFile.exists()) {
                    in = new FileInputStream(sFile);
                }
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            Logger.logException((Throwable)e);
        }
        TestContentDescription.assertNotNull(in);
        return this.getContentDescription(in);
    }

    /*
     * Exception decompiling
     */
    private IContentDescription getContentDescription(InputStream in) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 72->75)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

