/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.eclipse.wst.wsdl.util.WSDLParser;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LocationTrackingTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new LocationTrackingTest(){

            protected void runTest() {
                this.testTracksLocation();
            }
        });
        return suite;
    }

    public void testTracksLocation() {
        try {
            String fileName = String.valueOf(WSDLTestsPlugin.getInstallURL()) + "/samples/LoadStoreCompare/LoadAndPrintTest.wsdl";
            Definition definition = DefinitionLoader.load(fileName, true, true);
            Assert.assertNotNull((Object)definition);
            Assert.assertTrue((boolean)(definition.eResource() instanceof WSDLResourceImpl));
            Element definitionElement = definition.getElement();
            LocationTrackingTest.assertEquals((int)1, (int)WSDLParser.getStartLine((Node)definitionElement));
            Types types = definition.getETypes();
            Element typesElement = types.getElement();
            LocationTrackingTest.assertEquals((int)4, (int)WSDLParser.getStartLine((Node)typesElement));
            EList typesExtensibilityElements = types.getEExtensibilityElements();
            LocationTrackingTest.assertEquals((int)1, (int)typesExtensibilityElements.size());
            XSDSchemaExtensibilityElement schemaExtension = (XSDSchemaExtensibilityElement)typesExtensibilityElements.get(0);
            XSDSchema schema = schemaExtension.getSchema();
            Element schemaElement = schema.getElement();
            LocationTrackingTest.assertEquals((int)5, (int)XSDParser.getStartLine((Node)schemaElement));
            XSDElementDeclaration requestElementDeclaration = schema.resolveElementDeclaration("NewOperationRequest");
            Element requestElement = requestElementDeclaration.getElement();
            LocationTrackingTest.assertEquals((int)7, (int)XSDParser.getStartLine((Node)requestElement));
            EList services = definition.getEServices();
            LocationTrackingTest.assertEquals((int)1, (int)services.size());
            Service service = (Service)services.get(0);
            Element serviceElement = service.getElement();
            LocationTrackingTest.assertEquals((int)42, (int)WSDLParser.getStartLine((Node)serviceElement));
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }
}

