/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeNode;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRootAdapter;
import org.eclipse.wst.common.componentcore.internal.util.IPathProvider;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public class ResourceTreeRoot
extends ResourceTreeNode {
    private final WorkbenchComponent module;
    private ResourceTreeResourceListener listener;
    private ResourcePathListener pathListener;

    public static ResourceTreeRoot getSourceResourceTreeRoot(WorkbenchComponent aModule) {
        ResourceTreeRootAdapter resourceTreeAdapter = (ResourceTreeRootAdapter)ExtendedEcoreUtil.getAdapter((EObject)aModule, (List)aModule.eAdapters(), (Object)ResourceTreeRootAdapter.SOURCE_ADAPTER_TYPE);
        if (resourceTreeAdapter != null) {
            return resourceTreeAdapter.getResourceTreeRoot();
        }
        resourceTreeAdapter = new ResourceTreeRootAdapter(0);
        aModule.eAdapters().add((Object)resourceTreeAdapter);
        return resourceTreeAdapter.getResourceTreeRoot();
    }

    public static ResourceTreeRoot getDeployResourceTreeRoot(WorkbenchComponent aModule) {
        ResourceTreeRootAdapter resourceTreeAdapter = (ResourceTreeRootAdapter)ExtendedEcoreUtil.getAdapter((EObject)aModule, (List)aModule.eAdapters(), (Object)ResourceTreeRootAdapter.DEPLOY_ADAPTER_TYPE);
        if (resourceTreeAdapter != null) {
            return resourceTreeAdapter.getResourceTreeRoot();
        }
        resourceTreeAdapter = new ResourceTreeRootAdapter(1);
        aModule.eAdapters().add((Object)resourceTreeAdapter);
        return resourceTreeAdapter.getResourceTreeRoot();
    }

    public ResourceTreeRoot(WorkbenchComponent aModule, IPathProvider aPathProvider) {
        super("/", null, aPathProvider);
        this.module = aModule;
        this.init();
    }

    private void init() {
        this.module.eAdapters().add((Object)this.getResourceTreeListenerAdapter());
        EList moduleResources = this.module.getResources();
        ComponentResource moduleResource = null;
        int i = 0;
        while (i < moduleResources.size()) {
            moduleResource = (ComponentResource)moduleResources.get(i);
            this.addChild(moduleResource);
            ++i;
        }
    }

    protected ResourceTreeResourceListener getResourceTreeListenerAdapter() {
        if (this.listener == null) {
            this.listener = new ResourceTreeResourceListener();
        }
        return this.listener;
    }

    protected ResourcePathListener getResourcePathListenerAdapter() {
        if (this.pathListener == null) {
            this.pathListener = new ResourcePathListener();
        }
        return this.pathListener;
    }

    public ComponentResource[] findModuleResources(URI aURI) {
        Path path = new Path(aURI.toString());
        try {
            if (ModuleURIUtil.ensureValidFullyQualifiedPlatformURI(aURI, false)) {
                path = path.removeFirstSegments(1);
            }
        }
        catch (UnresolveableURIException unresolveableURIException) {}
        return this.findModuleResources((IPath)path, 0);
    }

    private class ResourceTreeResourceListener
    extends AdapterImpl {
        private ResourceTreeResourceListener() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == ComponentcorePackage.eINSTANCE.getWorkbenchComponent_Resources()) {
                ComponentResource resource = null;
                switch (msg.getEventType()) {
                    case 3: {
                        resource = (ComponentResource)msg.getNewValue();
                        if (resource == null) break;
                        resource.eAdapters().add((Object)ResourceTreeRoot.this.getResourcePathListenerAdapter());
                        break;
                    }
                    case 5: {
                        List newValues = (List)msg.getNewValue();
                        int i = 0;
                        while (i < newValues.size()) {
                            resource = (ComponentResource)newValues.get(i);
                            resource.eAdapters().add((Object)ResourceTreeRoot.this.getResourcePathListenerAdapter());
                            ++i;
                        }
                        break;
                    }
                    case 4: {
                        resource = (ComponentResource)msg.getOldValue();
                        if (resource == null) break;
                        resource.eAdapters().remove((Object)ResourceTreeRoot.this.getResourcePathListenerAdapter());
                        ResourceTreeRoot.this.removeChild(resource);
                        break;
                    }
                    case 6: {
                        List removedValues = (List)msg.getOldValue();
                        if (removedValues == null) break;
                        int i = 0;
                        while (i < removedValues.size()) {
                            resource = (ComponentResource)removedValues.get(i);
                            resource.eAdapters().remove((Object)ResourceTreeRoot.this.getResourcePathListenerAdapter());
                            ResourceTreeRoot.this.removeChild(resource);
                            ++i;
                        }
                        break;
                    }
                }
            }
        }
    }

    private class ResourcePathListener
    extends AdapterImpl {
        private ResourcePathListener() {
        }

        public void setTarget(Notifier newTarget) {
            ComponentResource resource;
            if (newTarget instanceof ComponentResource && (resource = (ComponentResource)newTarget) != null && ResourceTreeRoot.this.getPathProvider().getPath(resource) != null) {
                ResourceTreeRoot.this.addChild(resource);
            }
            super.setTarget(newTarget);
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == ResourceTreeRoot.this.getPathProvider().getFeature()) {
                ComponentResource resource = (ComponentResource)msg.getNotifier();
                switch (msg.getEventType()) {
                    case 1: {
                        IPath newPath;
                        IPath oldPath = (IPath)msg.getOldValue();
                        if (oldPath != null) {
                            ResourceTreeRoot.this.removeChild(oldPath, resource);
                        }
                        if ((newPath = (IPath)msg.getNewValue()) == null) break;
                        ResourceTreeRoot.this.addChild(resource);
                    }
                }
            }
        }
    }
}

