/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDAttributeDeclaration;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapterImpl;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.html.core.internal.HTMLCoreMessages;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class JSPActionValidator
extends JSPValidator {
    private int fSeverityMissingRequiredAttribute = 1;
    private int fSeverityUnknownAttribute = 2;
    private IValidator fMessageOriginator;
    private HashSet fTaglibPrefixes = new HashSet();
    private boolean fIsELIgnored = false;
    static /* synthetic */ Class class$0;

    public JSPActionValidator() {
        this.fMessageOriginator = this;
    }

    public JSPActionValidator(IValidator validator) {
        this.fMessageOriginator = validator;
    }

    private boolean checkRuntimeValue(IDOMAttr a) {
        ITextRegion value = a.getValueRegion();
        if (value instanceof ITextRegionContainer) {
            Iterator it = ((ITextRegionContainer)value).getRegions().iterator();
            while (it.hasNext()) {
                String type = ((ITextRegion)it.next()).getType();
                if (type != "JSP_EL_OPEN") continue;
                return true;
            }
        }
        return false;
    }

    private boolean isElIgnored(IPath path, IStructuredModel model) {
        String directiveIsELIgnored;
        if (DeploymentDescriptorPropertyCache.getInstance().getJSPVersion(path) < 2.0f) {
            return true;
        }
        IDOMDocument iDOMDocument = ((IDOMModel)model).getDocument();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((directiveIsELIgnored = ((PageDirectiveAdapterImpl)iDOMDocument.getAdapterFor((Object)clazz)).getElIgnored()) != null) {
            return Boolean.valueOf(directiveIsELIgnored);
        }
        DeploymentDescriptorPropertyCache.PropertyGroup[] groups = DeploymentDescriptorPropertyCache.getInstance().getPropertyGroups(path);
        if (groups.length > 0) {
            return groups[0].isELignored();
        }
        return false;
    }

    private void checkRequiredAttributes(IDOMElement element, CMNamedNodeMap attrMap, IReporter reporter, IFile file, IStructuredDocument document, IStructuredDocumentRegion documentRegion) {
        Iterator it = attrMap.iterator();
        CMAttributeDeclaration attr = null;
        while (it.hasNext()) {
            Attr a;
            attr = (CMAttributeDeclaration)it.next();
            if (attr.getUsage() != 2 || (a = element.getAttributeNode(attr.getAttrName())) != null) continue;
            String msgText = NLS.bind((String)HTMLCoreMessages.Undefined_attribute_name___ERROR_, (Object)attr.getAttrName());
            JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityMissingRequiredAttribute, msgText, (IResource)file);
            int start = element.getStartOffset();
            int length = element.getStartEndOffset() - start;
            int lineNo = document.getLineOfOffset(start);
            message.setLineNo(lineNo);
            message.setOffset(start);
            message.setLength(length);
            reporter.addMessage(this.fMessageOriginator, (IMessage)message);
        }
    }

    private boolean checkUnknownAttributes(IDOMElement element, CMNamedNodeMap cmAttrs, IReporter reporter, IFile file, IStructuredDocument document, IStructuredDocumentRegion documentRegion) {
        boolean foundjspattribute = false;
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            IDOMAttr attr;
            Attr a = (Attr)attrs.item(i);
            CMAttributeDeclaration adec = (CMAttributeDeclaration)cmAttrs.getNamedItem(a.getName());
            if (adec == null) {
                if (!this.hasJSPRegion(((IDOMNode)a).getNameRegion())) {
                    String msgText = NLS.bind((String)HTMLCoreMessages.Undefined_attribute_name___ERROR_, (Object)a.getName());
                    JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, this.fSeverityUnknownAttribute, msgText, (IResource)file);
                    int start = ((IDOMAttr)a).getNameRegionStartOffset();
                    int length = ((IDOMAttr)a).getNameRegionEndOffset() - start;
                    int lineNo = document.getLineOfOffset(start);
                    message.setLineNo(lineNo);
                    message.setOffset(start);
                    message.setLength(length);
                    reporter.addMessage(this.fMessageOriginator, (IMessage)message);
                } else {
                    foundjspattribute = true;
                }
            } else if (adec instanceof TLDAttributeDeclaration && !Boolean.valueOf(((TLDAttributeDeclaration)adec).getRtexprvalue()).booleanValue() && this.checkRuntimeValue(attr = (IDOMAttr)a) && !this.fIsELIgnored) {
                String msg = NLS.bind((String)HTMLCoreMessages.Invalid_attribute___0____ERROR_, (Object)a.getName());
                JSPValidator.LocalizedMessage message = new JSPValidator.LocalizedMessage((JSPValidator)this, 2, msg, (IResource)file);
                ITextRegion region = attr.getValueRegion();
                int start = attr.getValueRegionStartOffset();
                int length = region != null ? region.getTextLength() : 0;
                int lineNo = document.getLineOfOffset(start);
                message.setLineNo(lineNo);
                message.setOffset(start);
                message.setLength(length);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message);
            }
            ++i;
        }
        return foundjspattribute;
    }

    public void cleanup(IReporter reporter) {
        super.cleanup(reporter);
        this.fTaglibPrefixes.clear();
    }

    private String getStartTagName(IStructuredDocumentRegion sdr) {
        ITextRegion subRegion;
        String name = new String();
        ITextRegionList subRegions = sdr.getRegions();
        if (subRegions.size() > 2 && (subRegion = subRegions.get(0)).getType() == "XML_TAG_OPEN" && (subRegion = subRegions.get(1)).getType() == "XML_TAG_NAME") {
            name = sdr.getText(subRegion);
        }
        return name;
    }

    private HashSet getTaglibPrefixes(IStructuredDocument document) {
        if (this.fTaglibPrefixes.isEmpty()) {
            this.fTaglibPrefixes.add("jsp");
            this.fTaglibPrefixes.add("jspx");
            this.fTaglibPrefixes.add("java");
            this.fTaglibPrefixes.add("javax");
            this.fTaglibPrefixes.add("servlet");
            this.fTaglibPrefixes.add("sun");
            this.fTaglibPrefixes.add("sunw");
            TLDCMDocumentManager manager = TaglibController.getTLDCMDocumentManager((IDocument)document);
            List trackers = manager.getTaglibTrackers();
            Iterator it = trackers.iterator();
            while (it.hasNext()) {
                TaglibTracker tracker = (TaglibTracker)it.next();
                String prefix = tracker.getPrefix();
                this.fTaglibPrefixes.add(prefix);
            }
        }
        return this.fTaglibPrefixes;
    }

    private boolean hasJSPRegion(ITextRegion container) {
        if (!(container instanceof ITextRegionContainer)) {
            return false;
        }
        ITextRegionList regions = ((ITextRegionContainer)container).getRegions();
        if (regions == null) {
            return false;
        }
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            String regionType;
            ITextRegion region = (ITextRegion)e.next();
            if (region == null || (regionType = region.getType()) != "XML_TAG_OPEN" && !this.isNestedTagName(regionType)) continue;
            return true;
        }
        return false;
    }

    private boolean isNestedTagName(String regionType) {
        boolean result = regionType.equals("JSP_SCRIPTLET_OPEN") || regionType.equals("JSP_EXPRESSION_OPEN") || regionType.equals("JSP_DECLARATION_OPEN") || regionType.equals("JSP_DIRECTIVE_OPEN");
        return result;
    }

    void performValidation(IFile f, IReporter reporter, IStructuredModel model) {
        this.fTaglibPrefixes.clear();
        int length = model.getStructuredDocument().getLength();
        this.performValidation(f, reporter, model, (IRegion)new Region(0, length));
    }

    protected void performValidation(IFile f, IReporter reporter, IStructuredModel model, IRegion validateRegion) {
        IStructuredDocument sDoc = model.getStructuredDocument();
        this.fIsELIgnored = this.isElIgnored(f.getFullPath(), model);
        IStructuredDocumentRegion region = sDoc.getRegionAtCharacterOffset(validateRegion.getOffset());
        while (region != null && !reporter.isCancelled() && region.getStartOffset() <= validateRegion.getOffset() + validateRegion.getLength()) {
            String tagName;
            int colonPosition;
            if (region.getType() == "JSP_DIRECTIVE_NAME") {
                this.processDirective(reporter, f, model, region);
                this.fTaglibPrefixes.clear();
            } else if (region.getType() == "XML_TAG_NAME" && (colonPosition = (tagName = this.getStartTagName(region)).indexOf(58)) > -1) {
                String prefix = tagName.substring(0, colonPosition);
                if (this.getTaglibPrefixes(sDoc).contains(prefix)) {
                    this.processDirective(reporter, f, model, region);
                }
            }
            region = region.getNext();
        }
    }

    private void processDirective(IReporter reporter, IFile file, IStructuredModel model, IStructuredDocumentRegion documentRegion) {
        IndexedRegion ir = model.getIndexedRegion(documentRegion.getStartOffset());
        if (ir instanceof IDOMElement) {
            CMNamedNodeMap cmAttributes;
            boolean foundjspattribute;
            CMElementDeclaration cmElement;
            IDOMElement element = (IDOMElement)ir;
            ModelQuery query = ModelQueryUtil.getModelQuery((IStructuredModel)model);
            if (query != null && (cmElement = query.getCMElementDeclaration((Element)element)) != null && !(foundjspattribute = this.checkUnknownAttributes(element, cmAttributes = cmElement.getAttributes(), reporter, file, model.getStructuredDocument(), documentRegion))) {
                this.checkRequiredAttributes(element, cmAttributes, reporter, file, model.getStructuredDocument(), documentRegion);
            }
        }
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        reporter.removeAllMessages((IValidator)this);
        super.validate(helper, reporter);
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile f, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 107->111)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

