/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import java.util.Hashtable;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;

public class ImageFactory {
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    public static final int BOTTOM_RIGHT = 4;
    protected static final int[][] OVERLAY_COORDINATE;
    protected static ImageFactory INSTANCE;
    protected Hashtable compositeImageTable = new Hashtable();

    static {
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[2];
        int[] nArray = new int[2];
        nArray[1] = 2;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 2;
        nArrayArray[2] = nArray2;
        nArrayArray[3] = new int[]{2, 2};
        OVERLAY_COORDINATE = nArrayArray;
        INSTANCE = new ImageFactory();
    }

    public Image getImage(String iconName) {
        ImageRegistry imageRegistry = XMLUIPlugin.getDefault().getImageRegistry();
        if (imageRegistry.get(iconName) != null) {
            return imageRegistry.get(iconName);
        }
        imageRegistry.put(iconName, ImageDescriptor.createFromFile(this.getClass(), (String)iconName));
        return imageRegistry.get(iconName);
    }

    public Image createCompositeImage(Image base, Image overlay, int overlayPosition) {
        String key = base + "*" + overlay + "*" + overlayPosition;
        Image result = (Image)this.compositeImageTable.get(key);
        if (result == null) {
            ImageDescriptor[][] overlays = new ImageDescriptor[3][3];
            int[] coord = OVERLAY_COORDINATE[overlayPosition];
            overlays[coord[1]][coord[0]] = new ImageBasedImageDescriptor(overlay);
            OverlayIcon icon = new OverlayIcon(new ImageBasedImageDescriptor(base), overlays, new Point(16, 16));
            result = icon.createImage();
            this.compositeImageTable.put(key, result);
        }
        return result;
    }

    public static ImageDescriptor createImageDescriptorWrapper(Image image) {
        return new ImageBasedImageDescriptor(image);
    }

    class OverlayIcon
    extends CompositeImageDescriptor {
        static final int DEFAULT_WIDTH = 22;
        static final int DEFAULT_HEIGHT = 16;
        private Point fSize = null;
        private ImageDescriptor fBase;
        private ImageDescriptor[][] fOverlays;

        public OverlayIcon(ImageDescriptor base, ImageDescriptor[][] overlays, Point size) {
            this.fBase = base;
            this.fOverlays = overlays;
            this.fSize = size;
        }

        protected void drawBottomLeft(ImageDescriptor[] overlays) {
            if (overlays == null) {
                return;
            }
            int length = overlays.length;
            int x = 0;
            int i = 0;
            while (i < 3) {
                if (i < length && overlays[i] != null) {
                    ImageData id = overlays[i].getImageData();
                    this.drawImage(id, x, this.getSize().y - id.height);
                    x += id.width;
                }
                ++i;
            }
        }

        protected void drawBottomRight(ImageDescriptor[] overlays) {
            if (overlays == null) {
                return;
            }
            int length = overlays.length;
            int x = this.getSize().x;
            int i = 2;
            while (i >= 0) {
                if (i < length && overlays[i] != null) {
                    ImageData id = overlays[i].getImageData();
                    this.drawImage(id, x -= id.width, this.getSize().y - id.height);
                }
                --i;
            }
        }

        protected void drawCompositeImage(int width, int height) {
            ImageData bg;
            if (this.fBase == null || (bg = this.fBase.getImageData()) == null) {
                bg = DEFAULT_IMAGE_DATA;
            }
            this.drawImage(bg, 0, 0);
            if (this.fOverlays != null) {
                if (this.fOverlays.length > 0) {
                    this.drawTopRight(this.fOverlays[0]);
                }
                if (this.fOverlays.length > 1) {
                    this.drawBottomRight(this.fOverlays[1]);
                }
                if (this.fOverlays.length > 2) {
                    this.drawBottomLeft(this.fOverlays[2]);
                }
                if (this.fOverlays.length > 3) {
                    this.drawTopLeft(this.fOverlays[3]);
                }
            }
        }

        protected void drawTopLeft(ImageDescriptor[] overlays) {
            if (overlays == null) {
                return;
            }
            int length = overlays.length;
            int x = 0;
            int i = 0;
            while (i < 3) {
                if (i < length && overlays[i] != null) {
                    ImageData id = overlays[i].getImageData();
                    this.drawImage(id, x, 0);
                    x += id.width;
                }
                ++i;
            }
        }

        protected void drawTopRight(ImageDescriptor[] overlays) {
            if (overlays == null) {
                return;
            }
            int length = overlays.length;
            int x = this.getSize().x;
            int i = 2;
            while (i >= 0) {
                if (i < length && overlays[i] != null) {
                    ImageData id = overlays[i].getImageData();
                    this.drawImage(id, x -= id.width, 0);
                }
                --i;
            }
        }

        protected Point getSize() {
            return this.fSize;
        }
    }

    static class ImageBasedImageDescriptor
    extends ImageDescriptor {
        protected Image image;

        public ImageBasedImageDescriptor(Image image) {
            this.image = image;
        }

        public ImageData getImageData() {
            return this.image.getImageData();
        }
    }
}

