/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.contentassist;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.ui.internal.contentassist.BeanInfoProvider;
import org.eclipse.jst.jsp.ui.internal.contentassist.IJavaPropertyDescriptor;
import org.eclipse.jst.jsp.ui.tests.util.FileUtil;
import org.eclipse.jst.jsp.ui.tests.util.ProjectUnzipUtility;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class BeanInfoProviderTest
extends TestCase {
    private IResource fResource;
    private BeanInfoProvider fProvider;
    private HashSet fAlreadyOpen = new HashSet();
    private ProjectUnzipUtility fProjUtil = null;
    private boolean fIsSetup = false;

    public BeanInfoProviderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.fIsSetup) {
            this.initializeResource();
            this.fIsSetup = true;
        }
    }

    private void initializeResource() throws Exception {
        this.fProjUtil = new ProjectUnzipUtility();
        Location platformLocation = Platform.getInstanceLocation();
        if (platformLocation != null) {
            File zipFile = FileUtil.makeFileFor("projecttestfiles", "beaninfo_tests.zip", "projecttestfiles");
            this.fProjUtil.unzipAndImport(zipFile, platformLocation.getURL().getPath());
            this.fProjUtil.initJavaProject("BEANINFO");
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String workspaceRelativeLocation = "/BEANINFO/BEAN_TESTS/beanInfo_test.jsp";
            this.fResource = root.getFile((IPath)new Path(workspaceRelativeLocation));
            IJavaProject javaProj = JavaCore.create((IProject)this.fResource.getProject());
            this.openPath(javaProj);
        }
    }

    protected File getSourceDirectory(String absoluteSourceDirectoryPath) {
        File sourceDirectory = new File(absoluteSourceDirectoryPath);
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private void openPath(IJavaProject javaProj) {
        try {
            IPackageFragmentRoot root;
            if (javaProj.exists() && !javaProj.isOpen()) {
                javaProj.open(null);
            }
            if (!(root = javaProj.getPackageFragmentRoot((IResource)this.fResource.getProject())).isOpen()) {
                root.open(null);
            }
            IPackageFragment frag = this.getPackageFragment(root, "BEAN_TESTS");
            this.openAll((IJavaElement)frag);
            frag = this.getPackageFragment(root, "org");
            if (frag != null && !frag.isOpen()) {
                this.openAll((IJavaElement)frag);
            }
            if ((frag = this.getPackageFragment(root, "org.eclipse")) != null && !frag.isOpen()) {
                this.openAll((IJavaElement)frag);
            }
            if ((frag = this.getPackageFragment(root, "org.eclipse.jst")) != null && !frag.isOpen()) {
                this.openAll((IJavaElement)frag);
            }
            if ((frag = this.getPackageFragment(root, "org.eclipse.jst.jsp")) != null && !frag.isOpen()) {
                this.openAll((IJavaElement)frag);
            }
            if ((frag = this.getPackageFragment(root, "org.eclipse.jst.jsp.ui")) != null && !frag.isOpen()) {
                this.openAll((IJavaElement)frag);
            }
            if ((frag = this.getPackageFragment(root, "org.eclipse.jst.jsp.ui.tests")) != null && !frag.isOpen()) {
                this.openAll((IJavaElement)frag);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private IPackageFragment getPackageFragment(IPackageFragmentRoot root, String fragmentName) throws JavaModelException {
        IPackageFragment frag = null;
        IJavaElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getElementName().equals(fragmentName)) {
                frag = (IPackageFragment)children[i];
                break;
            }
            ++i;
        }
        return frag;
    }

    private void openAll(IJavaElement javaElem) throws JavaModelException {
        if (javaElem instanceof IOpenable && !((IOpenable)javaElem).isOpen()) {
            ((IOpenable)javaElem).open(null);
        }
        if (javaElem instanceof IParent && ((IParent)javaElem).hasChildren()) {
            IJavaElement[] children = ((IParent)javaElem).getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.fAlreadyOpen.contains(children[i].getElementName())) {
                    this.fAlreadyOpen.add(children[i].getElementName());
                    this.openAll(children[i]);
                }
                ++i;
            }
        }
    }

    public void testAll() {
        this.beanOnClasspath();
        this.beanInProject();
    }

    private void beanOnClasspath() {
        IJavaPropertyDescriptor[] descriptors = this.getProvider().getRuntimeProperties(this.fResource, "javax.swing.JButton");
        BeanInfoProviderTest.assertNotNull((String)"descriptors shouldn't be null", (Object)descriptors);
    }

    private void beanInProject() {
        IJavaPropertyDescriptor[] descriptors = this.getProvider().getRuntimeProperties(this.fResource, "org.eclipse.jst.jsp.ui.tests.BaseAlbumCollectionBean");
        BeanInfoProviderTest.assertEquals((String)"Number of properties for BaseAlbumCollectionBean:", (int)4, (int)descriptors.length);
        ArrayList<IJavaPropertyDescriptor> getOnly = new ArrayList<IJavaPropertyDescriptor>();
        ArrayList<IJavaPropertyDescriptor> setOnly = new ArrayList<IJavaPropertyDescriptor>();
        ArrayList<IJavaPropertyDescriptor> both = new ArrayList<IJavaPropertyDescriptor>();
        IJavaPropertyDescriptor jpd = null;
        int i = 0;
        while (i < descriptors.length) {
            jpd = descriptors[i];
            if (jpd.getReadable() && jpd.getWriteable()) {
                both.add(jpd);
            } else if (jpd.getReadable() && !jpd.getWriteable()) {
                getOnly.add(jpd);
            } else {
                setOnly.add(jpd);
            }
            ++i;
        }
        BeanInfoProviderTest.assertEquals((String)"Number of getOnly properties:", (int)1, (int)getOnly.size());
        BeanInfoProviderTest.assertEquals((String)"Number of setOnly properties:", (int)1, (int)setOnly.size());
        BeanInfoProviderTest.assertEquals((String)"Number of get & set properties that:", (int)2, (int)both.size());
        jpd = (IJavaPropertyDescriptor)getOnly.get(0);
        BeanInfoProviderTest.assertEquals((String)"get readable for get only property: ", (boolean)true, (boolean)jpd.getReadable());
        BeanInfoProviderTest.assertEquals((String)"get writable for get only property:", (boolean)false, (boolean)jpd.getWriteable());
        BeanInfoProviderTest.assertEquals((String)"name for get only property", (String)"numCds", (String)jpd.getDisplayName());
        BeanInfoProviderTest.assertEquals((String)"type for get only property", (String)"int", (String)jpd.getDeclaredType());
        jpd = (IJavaPropertyDescriptor)setOnly.get(0);
        BeanInfoProviderTest.assertEquals((String)"get readable for set only property: ", (boolean)false, (boolean)jpd.getReadable());
        BeanInfoProviderTest.assertEquals((String)"get writable for set only property:", (boolean)true, (boolean)jpd.getWriteable());
        BeanInfoProviderTest.assertEquals((String)"name for set only property", (String)"cds", (String)jpd.getDisplayName());
        BeanInfoProviderTest.assertEquals((String)"type for set only property", (String)"String[]", (String)jpd.getDeclaredType());
        jpd = (IJavaPropertyDescriptor)both.get(0);
        BeanInfoProviderTest.assertEquals((String)"get readable for both property: ", (boolean)true, (boolean)jpd.getReadable());
        BeanInfoProviderTest.assertEquals((String)"get writable for both property:", (boolean)true, (boolean)jpd.getWriteable());
    }

    private BeanInfoProvider getProvider() {
        if (this.fProvider == null) {
            this.fProvider = new BeanInfoProvider();
        }
        return this.fProvider;
    }

    class OverwriteNone
    implements IOverwriteQuery {
        OverwriteNone() {
        }

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    }
}

