/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.environment.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.uri.IURI;
import org.eclipse.wst.common.environment.uri.IURIFactory;
import org.eclipse.wst.common.environment.uri.IURIFilter;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.IURIVisitor;
import org.eclipse.wst.common.environment.uri.URIException;

public class FileURITests
extends TestCase {
    private File tempFile;
    private File tempDir;
    static /* synthetic */ Class class$0;

    public FileURITests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            FileURITests.runAll();
        } else if (args.length == 1) {
            String methodToRun = args[0].trim();
            FileURITests.runOne(methodToRun);
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.environment.tests.FileURITests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected static void runAll() {
        TestRunner.run((Test)FileURITests.suite());
    }

    public static void runOne(String methodName) {
        TestSuite testSuite = new TestSuite();
        FileURITests test = new FileURITests(methodName);
        System.out.println("Calling FileURITests." + methodName);
        testSuite.addTest((Test)test);
        TestRunner.run((Test)testSuite);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tempFile = File.createTempFile("tmp", "tmp", null);
        this.tempDir = new File(this.tempFile.getParentFile(), "tmpDir");
        this.tempDir.mkdir();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.deleteFiles(this.tempDir);
        this.tempFile.delete();
    }

    private void deleteFiles(File directory) {
        File[] children;
        if (directory != null && (children = directory.listFiles()) != null) {
            int index = 0;
            while (index < children.length) {
                File child = children[index];
                if (child.isDirectory()) {
                    this.deleteFiles(child);
                }
                child.delete();
                ++index;
            }
        }
    }

    private String getTmpFileURL(String fileName) {
        File newFile = new File(this.tempDir, fileName);
        return "file:/" + newFile.getAbsolutePath();
    }

    public static Test getTest() {
        return new FileURITests("FileURITests");
    }

    public void testAvailable() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("FileURITests.testAvailable()");
        try {
            IURI uri2 = factory.newURI(this.getTmpFileURL("somefile"));
            IURI uri3 = factory.newURI("relativedirectory/relativefile");
            FileURITests.assertTrue((String)"Not available as URL", (boolean)uri2.isAvailableAsURL());
            FileURITests.assertTrue((String)"Available as URL", (!uri3.isAvailableAsURL() ? 1 : 0) != 0);
            FileURITests.assertTrue((String)"Not available as File", (boolean)uri2.isAvailableAsFile());
            FileURITests.assertTrue((String)"Available as File", (!uri3.isAvailableAsFile() ? 1 : 0) != 0);
            File file2 = uri2.asFile();
            URL url2 = uri2.asURL();
            uri2.touchLeaf();
            FileURITests.assertTrue((String)"Is a file", (boolean)file2.isFile());
            FileURITests.assertTrue((String)"Wrong protocol", (boolean)url2.getProtocol().equals("file"));
            FileURITests.assertTrue((uri2.asString().length() > 5 ? 1 : 0) != 0);
            FileURITests.assertTrue((uri2.toString().length() > 5 ? 1 : 0) != 0);
            uri2.erase();
        }
        catch (URIException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testTouchFolder() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("FileURITests.testTouchFolder()");
        try {
            File folderPath = new File(this.tempDir, "topFolder");
            File folderPath2 = new File(folderPath, "space folder");
            IURI uri = factory.newURI(folderPath.toURL().toString());
            IURI uri2 = factory.newURI(folderPath2.toURL().toString());
            FileURITests.assertTrue((String)"topFolder should not exist", (!uri.isPresent() ? 1 : 0) != 0);
            uri.touchFolder();
            FileURITests.assertTrue((String)"topFolder should exist", (boolean)uri.isPresent());
            File nestedPath = new File(new File(folderPath, "level1"), "level2");
            IURI nesteduri = factory.newURI(nestedPath.toURL().toString());
            FileURITests.assertTrue((String)"nestedFolder should not exist", (!nesteduri.isPresent() ? 1 : 0) != 0);
            nesteduri.touchFolder();
            FileURITests.assertTrue((String)"nestedFolder should exist", (boolean)nesteduri.isPresent());
            IURI child1 = uri2.append(factory.newURI("child1"));
            IURI child2 = uri2.append(factory.newURI("child2"));
            child1.touchLeaf();
            child2.touchLeaf();
            FileURITests.assertTrue((String)"Child 1 in blank folder should exist ", (boolean)child1.isPresent());
            FileURITests.assertTrue((String)"Child 2 in blank folder should exist ", (boolean)child2.isPresent());
        }
        catch (URIException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        catch (MalformedURLException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testList() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("FileURITests.testList()");
        try {
            File folderPath0 = new File(this.tempDir, "topFolder2");
            File folderPath1 = new File(new File(this.tempDir, "topFolder2"), "leaf1");
            File folderPath2 = new File(new File(this.tempDir, "topFolder2"), "leaf2");
            File folderPath3 = new File(new File(this.tempDir, "topFolder2"), "leaf3");
            IURI uri0 = factory.newURI(folderPath0.toURL().toString());
            IURI uri1 = factory.newURI(folderPath1.toURL().toString());
            IURI uri2 = factory.newURI(folderPath2.toURL().toString());
            IURI uri3 = factory.newURI(folderPath3.toURL().toString());
            uri1.touchFolder();
            uri2.touchFolder();
            uri3.touchFolder();
            IURI[] babies = uri0.list();
            FileURITests.assertTrue((String)"folder path should have 3 children", (babies.length == 3 ? 1 : 0) != 0);
            int index = 0;
            while (index < babies.length) {
                String folderName = babies[index].toString();
                String leafName = folderName.substring(folderName.length() - 5, folderName.length());
                boolean Ok = leafName.equals("leaf1") || leafName.equals("leaf2") || leafName.equals("leaf3");
                FileURITests.assertTrue((String)("Wrong leaf baby uri:" + folderName + "," + leafName), (boolean)Ok);
                ++index;
            }
            IURI[] babies2 = uri0.list(new IURIFilter(){

                public boolean accepts(IURI uri) {
                    return !uri.toString().endsWith("leaf2");
                }
            });
            FileURITests.assertTrue((String)"folder path should have 2 filtered children", (babies2.length == 2 ? 1 : 0) != 0);
            int index2 = 0;
            while (index2 < babies2.length) {
                String folderName = babies2[index2].toString();
                String leafName = folderName.substring(folderName.length() - 5, folderName.length());
                boolean Ok = leafName.equals("leaf1") || leafName.equals("leaf3");
                FileURITests.assertTrue((String)("Wrong leaf baby uri:" + folderName + "," + leafName), (boolean)Ok);
                ++index2;
            }
        }
        catch (URIException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        catch (MalformedURLException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testGetURIScheme() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        try {
            File folderPath0 = new File(this.tempDir, "testGetScheme");
            IURI uri0 = factory.newURI(folderPath0.toURL().toString());
            IURIScheme scheme = uri0.getURIScheme();
            FileURITests.assertTrue((String)"Scheme name is not file", (boolean)scheme.toString().equals("file"));
        }
        catch (URIException uRIException) {
            FileURITests.assertTrue((String)"Unexpected exception", (boolean)false);
        }
        catch (MalformedURLException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testAppend() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("FileURITests.testAppend()");
        try {
            File folderPath0 = new File(this.tempDir, "topFolder3");
            IURI uri0 = factory.newURI(folderPath0.toURL().toString());
            IURI uriRelative1 = factory.newURI("level1");
            IURI uriRelative2 = factory.newURI("level2");
            IURI newURI = uri0.append(uriRelative1).append(uriRelative2);
            FileURITests.assertTrue((String)"newURI should not exist", (!newURI.isPresent() ? 1 : 0) != 0);
            newURI.touchFolder();
            FileURITests.assertTrue((String)"newURI should exist", (boolean)newURI.isPresent());
            FileURITests.assertTrue((String)"newURI should not be a leaf", (!newURI.isLeaf() ? 1 : 0) != 0);
            try {
                IURI newURI2 = uri0.append(uri0);
                FileURITests.assertTrue((String)"Appending using a non-relative should throw and exception", (boolean)true);
                newURI2.asFile();
            }
            catch (URIException uRIException) {}
        }
        catch (URIException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        catch (MalformedURLException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTouchLeaf() {
        environment = EnvironmentService.getEclipseConsoleEnvironment();
        factory = environment.getURIFactory();
        System.out.println("FileURITests.testTouchLeaf()");
        try {
            block11: {
                folderPath0 = new File(this.tempDir, "topFolder4");
                uri0 = factory.newURI(folderPath0.toURL().toString());
                uriRelative1 = factory.newURI("level1");
                uriRelative2 = factory.newURI("leafFile.txt");
                newURI = uri0.append(uriRelative1).append(uriRelative2);
                FileURITests.assertTrue((String)"newURI should not exist", (boolean)(newURI.isPresent() == false));
                newURI.touchLeaf();
                FileURITests.assertTrue((String)"newURI should exist", (boolean)newURI.isPresent());
                FileURITests.assertTrue((String)"newURI should be a leaf", (boolean)newURI.isLeaf());
                stream = newURI.getInputStream();
                byteRead = 0;
                try {
                    try {
                        byteRead = stream.read();
                    }
                    catch (IOException exc) {
                        FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                    }
                }
                catch (Throwable var12_13) {
                    var11_14 = null;
                    try {
                        stream.close();
                        throw var12_13;
                    }
                    catch (IOException exc) {
                        FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                    }
                    throw var12_13;
                }
                {
                    var11_15 = null;
                }
                ** try [egrp 3[TRYBLOCK] [3 : 206->214)] { 
lbl34:
                // 1 sources

                stream.close();
                break block11;
lbl36:
                // 1 sources

                catch (IOException exc) {
                    FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                }
            }
            FileURITests.assertTrue((String)"There should be no bytes in this stream", (boolean)(byteRead == -1));
            return;
        }
        catch (URIException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
            return;
        }
        catch (MalformedURLException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testIOOperations() {
        block14: {
            environment = EnvironmentService.getEclipseConsoleEnvironment();
            factory = environment.getURIFactory();
            stream = null;
            writer = null;
            inputStream = null;
            reader = null;
            System.out.println("FileURITests.testIOOperations()");
            try {
                try {
                    folderPath0 = new File(this.tempDir, "topFolder5");
                    uri0 = factory.newURI(folderPath0.toURL().toString());
                    uriRelative1 = factory.newURI("level1");
                    uriRelative2 = factory.newURI("leafFile.txt");
                    newURI = uri0.append(uriRelative1).append(uriRelative2);
                    FileURITests.assertTrue((String)"newURI should not exist", (boolean)(newURI.isPresent() == false));
                    FileURITests.assertTrue((String)"newURI should not be readable", (boolean)(newURI.isReadable() == false));
                    FileURITests.assertTrue((String)"newURI should be writable", (boolean)(newURI.isWritable() == false));
                    stream = new OutputStreamWriter(newURI.getOutputStream());
                    writer = new PrintWriter(stream);
                    writer.println("This is line 1 of the file.");
                    writer.println("This is line 2 of the file.");
                    writer.println("This is the end of the file.");
                    writer.close();
                    stream.close();
                    writer = null;
                    stream = null;
                    FileURITests.assertTrue((String)"newURI should be readable", (boolean)newURI.isReadable());
                    FileURITests.assertTrue((String)"newURI should be writable", (boolean)newURI.isWritable());
                    inputStream = new InputStreamReader(newURI.getInputStream());
                    reader = new BufferedReader(inputStream);
                    FileURITests.assertTrue((String)"Bad first line of file", (boolean)reader.readLine().equals("This is line 1 of the file."));
                    FileURITests.assertTrue((String)"Bad second line of file", (boolean)reader.readLine().equals("This is line 2 of the file."));
                    FileURITests.assertTrue((String)"Bad last line of file", (boolean)reader.readLine().equals("This is the end of the file."));
                    FileURITests.assertTrue((String)"Extra lines found in file", (boolean)(reader.readLine() == null));
                    reader.close();
                    level1 = uri0.append(uriRelative1);
                    newLevel = uri0.append(factory.newURI("newLevel1"));
                    oldFile = newLevel.append(uriRelative2);
                    newFile = newLevel.append(factory.newURI("newFile"));
                    FileURITests.assertTrue((String)"URI is not present", (boolean)newURI.isPresent());
                    FileURITests.assertTrue((String)"URI is present", (boolean)(newLevel.append(uriRelative2).isPresent() == false));
                    level1.rename(newLevel);
                    FileURITests.assertTrue((String)"URI is present", (boolean)(newURI.isPresent() == false));
                    FileURITests.assertTrue((String)"URI is not present", (boolean)newLevel.append(uriRelative2).isPresent());
                    FileURITests.assertTrue((String)"URI is present", (boolean)(newFile.isPresent() == false));
                    FileURITests.assertTrue((String)"URI is not present", (boolean)oldFile.isPresent());
                    oldFile.rename(newFile);
                    FileURITests.assertTrue((String)"URI is not present", (boolean)newFile.isPresent());
                    FileURITests.assertTrue((String)"URI is present", (boolean)(oldFile.isPresent() == false));
                }
                catch (URIException exc) {
                    FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                }
                catch (IOException exc) {
                    FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                }
            }
            catch (Throwable var17_18) {
                var16_19 = null;
                if (stream != null) {
                    try {
                        writer.close();
                        stream.close();
                    }
                    catch (IOException exc) {
                        FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                    }
                }
                if (inputStream == null) throw var17_18;
                try {
                    inputStream.close();
                    reader.close();
                    throw var17_18;
                }
                catch (IOException exc) {
                    FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
                }
                throw var17_18;
            }
            {
                var16_20 = null;
                if (stream == null) break block14;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 660->672)] { 
lbl79:
            // 1 sources

            writer.close();
            stream.close();
            break block14;
lbl82:
            // 1 sources

            catch (IOException exc) {
                FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
            }
        }
        if (inputStream == null) return;
        try {}
        catch (IOException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
            return;
        }
        inputStream.close();
        reader.close();
    }

    public void testRelative() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("FileURITests.testRelative()");
        try {
            File folderPath0 = new File(this.tempDir, "relativeProj");
            IURI uri0 = factory.newURI(folderPath0.toURL().toString());
            IURI uriRelative1 = factory.newURI("level1");
            IURI level1URI = uri0.append(uriRelative1);
            FileURITests.assertTrue((String)"Uri is relative", (!uri0.isRelative() ? 1 : 0) != 0);
            FileURITests.assertTrue((String)"Uri is not relative", (boolean)uriRelative1.isRelative());
            FileURITests.assertTrue((String)"Uri is relative", (!level1URI.isRelative() ? 1 : 0) != 0);
            FileURITests.assertTrue((String)"Uri is not hierarchical", (boolean)uri0.isHierarchical());
            FileURITests.assertTrue((String)"Uri is not hierarchical", (boolean)uriRelative1.isHierarchical());
            FileURITests.assertTrue((String)"Uri is not hierarchical", (boolean)level1URI.isHierarchical());
        }
        catch (URIException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        catch (MalformedURLException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testErase1() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("FileURITests.testErase1()");
        try {
            File folderPath0 = new File(this.tempDir, "topFolder6");
            IURI uri0 = factory.newURI(folderPath0.toURL().toString());
            IURI uriRelative1 = factory.newURI("level1");
            IURI uriRelative2 = factory.newURI("leafFile.txt");
            IURI newURI = uri0.append(uriRelative1).append(uriRelative2);
            IURI level1URI = uri0.append(uriRelative1);
            FileURITests.assertTrue((String)"newURI should not exist", (!newURI.isPresent() ? 1 : 0) != 0);
            newURI.touchLeaf();
            FileURITests.assertTrue((String)"newURI should exist", (boolean)newURI.isPresent());
            newURI.erase();
            FileURITests.assertTrue((String)"newURI should not exist", (!newURI.isPresent() ? 1 : 0) != 0);
            FileURITests.assertTrue((String)"folder root should exist", (boolean)uri0.isPresent());
            FileURITests.assertTrue((String)"folder level1 should exist", (boolean)level1URI.isPresent());
            uri0.erase();
            FileURITests.assertTrue((String)"folder root should not exist", (!uri0.isPresent() ? 1 : 0) != 0);
            FileURITests.assertTrue((String)"folder level1 should not exist", (!level1URI.isPresent() ? 1 : 0) != 0);
        }
        catch (URIException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        catch (MalformedURLException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testIsLeaf() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        System.out.println("FileURITests.testIsLeaf()");
        try {
            File folderPath0 = new File(this.tempDir, "topFolder7");
            IURI uri0 = factory.newURI(folderPath0.toURL().toString());
            IURI uriRelative1 = factory.newURI("level1");
            IURI uriRelative2 = factory.newURI("leafFile.txt");
            IURI newURI = uri0.append(uriRelative1).append(uriRelative2);
            IURI parent = newURI.parent();
            FileURITests.assertTrue((String)"newURI should not exist", (!newURI.isPresent() ? 1 : 0) != 0);
            FileURITests.assertTrue((String)"parent should not exist", (!parent.isPresent() ? 1 : 0) != 0);
            FileURITests.assertTrue((String)"newURI should not be a leaf yet", (!newURI.isLeaf() ? 1 : 0) != 0);
            FileURITests.assertTrue((String)"parent should not be a leaf", (!parent.isLeaf() ? 1 : 0) != 0);
            newURI.touchLeaf();
            FileURITests.assertTrue((String)"newURI should exist", (boolean)newURI.isPresent());
            FileURITests.assertTrue((String)"parent should exist", (boolean)parent.isPresent());
            FileURITests.assertTrue((String)"newURI should be a leaf", (boolean)newURI.isLeaf());
            FileURITests.assertTrue((String)"parent should not be a leaf", (!parent.isLeaf() ? 1 : 0) != 0);
        }
        catch (URIException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        catch (MalformedURLException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    public void testVisit() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        IURIFactory factory = environment.getURIFactory();
        IURIScheme scheme = EnvironmentService.getFileScheme();
        System.out.println("FileURITests.testVisit()");
        try {
            File folderPath0 = new File(this.tempDir, "root");
            IURI uri0 = factory.newURI(folderPath0.toURL().toString());
            Hashtable table = this.buildTestEntries(scheme, uri0);
            uri0.visit((IURIVisitor)new TestVisitor(table));
            this.verifyTable(table);
            this.resetTableForTest2(table);
            uri0.visit((IURIVisitor)new TestVisitor(table));
            this.verifyTable(table);
            this.resetTable(table);
            uri0.visit((IURIVisitor)new TestVisitor(table), (IURIFilter)new TestFilter(table));
            this.verifyTable(table);
            this.resetTableForTest3(table);
            uri0.visit((IURIVisitor)new TestVisitor(table), (IURIFilter)new TestFilter(table));
            this.verifyTable(table);
        }
        catch (URIException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        catch (MalformedURLException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
    }

    private Hashtable buildTestEntries(IURIScheme scheme, IURI rootURI) {
        Hashtable<String, NodeEntry> table = new Hashtable<String, NodeEntry>();
        try {
            IURI rootc1 = rootURI.append(scheme.newURI("rootc1"));
            IURI rootc2 = rootURI.append(scheme.newURI("rootc2"));
            IURI rootc3 = rootURI.append(scheme.newURI("rootc3"));
            IURI rootc2c1 = rootc2.append(scheme.newURI("rootc2c1"));
            IURI rootc2c2 = rootc2.append(scheme.newURI("rootc2c2"));
            IURI rootc2c3 = rootc2.append(scheme.newURI("rootc2c3"));
            IURI rootc2c2c1 = rootc2c2.append(scheme.newURI("rootc2c2c1"));
            IURI rootc2c2c2 = rootc2c2.append(scheme.newURI("rootc2c2c2"));
            IURI rootc3c1 = rootc3.append(scheme.newURI("rootc3c1"));
            IURI rootc3c2 = rootc3.append(scheme.newURI("rootc3c2"));
            rootc3c1.touchLeaf();
            rootc3c2.touchLeaf();
            rootc2c2c1.touchLeaf();
            rootc2c2c2.touchLeaf();
            rootc2c1.touchLeaf();
            rootc2c3.touchLeaf();
            rootc1.touchFolder();
            table.put("root", new NodeEntry());
            table.put("rootc1", new NodeEntry());
            table.put("rootc2", new NodeEntry());
            table.put("rootc3", new NodeEntry());
            table.put("rootc2c1", new NodeEntry());
            table.put("rootc2c2", new NodeEntry());
            table.put("rootc2c3", new NodeEntry());
            table.put("rootc2c2c1", new NodeEntry());
            table.put("rootc2c2c2", new NodeEntry());
            table.put("rootc3c1", new NodeEntry());
            table.put("rootc3c2", new NodeEntry());
        }
        catch (URIException exc) {
            FileURITests.assertTrue((String)("Exception throw:" + exc.getMessage()), (boolean)false);
        }
        return table;
    }

    private String getName(IURI uri) {
        String fullName = uri.toString();
        int slash = fullName.lastIndexOf(47);
        if (slash == -1) {
            slash = fullName.lastIndexOf(92);
        }
        String name = fullName.substring(slash + 1, fullName.length());
        return name;
    }

    private void verifyTable(Hashtable table) {
        Iterator entries = table.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String key = (String)entry.getKey();
            NodeEntry node = (NodeEntry)entry.getValue();
            FileURITests.assertTrue((String)("Bad table result for key:" + key + " visited=" + node.wasVisited_ + " shouldbe=" + node.shouldBeVisited_), (node.wasVisited_ == node.shouldBeVisited_ ? 1 : 0) != 0);
        }
    }

    private void resetTableForTest2(Hashtable table) {
        this.resetTable(table);
        NodeEntry rootc2 = (NodeEntry)table.get("rootc2");
        rootc2.stopTraversing_ = true;
        NodeEntry rootc2c1 = (NodeEntry)table.get("rootc2c1");
        rootc2c1.shouldBeVisited_ = false;
        NodeEntry rootc2c2 = (NodeEntry)table.get("rootc2c2");
        rootc2c2.shouldBeVisited_ = false;
        NodeEntry rootc2c3 = (NodeEntry)table.get("rootc2c3");
        rootc2c3.shouldBeVisited_ = false;
        NodeEntry rootc2c2c1 = (NodeEntry)table.get("rootc2c2c1");
        rootc2c2c1.shouldBeVisited_ = false;
        NodeEntry rootc2c2c2 = (NodeEntry)table.get("rootc2c2c2");
        rootc2c2c2.shouldBeVisited_ = false;
    }

    private void resetTableForTest3(Hashtable table) {
        this.resetTable(table);
        NodeEntry rootc3 = (NodeEntry)table.get("rootc3");
        rootc3.visitNode_ = false;
        rootc3.shouldBeVisited_ = false;
        NodeEntry rootc2c2 = (NodeEntry)table.get("rootc2c2");
        rootc2c2.visitNode_ = false;
        rootc2c2.shouldBeVisited_ = false;
        NodeEntry rootc3c1 = (NodeEntry)table.get("rootc3c1");
        rootc3c1.visitNode_ = false;
        rootc3c1.shouldBeVisited_ = false;
    }

    private void resetTable(Hashtable table) {
        Iterator entries = table.values().iterator();
        while (entries.hasNext()) {
            NodeEntry entry = (NodeEntry)entries.next();
            entry.wasVisited_ = false;
            entry.shouldBeVisited_ = true;
            entry.stopTraversing_ = false;
            entry.visitNode_ = true;
        }
    }

    private class TestVisitor
    implements IURIVisitor {
        private Hashtable table_;

        public TestVisitor(Hashtable table) {
            this.table_ = table;
        }

        public boolean visit(IURI uri) {
            NodeEntry entry = (NodeEntry)this.table_.get(FileURITests.this.getName(uri));
            entry.wasVisited_ = true;
            return !entry.stopTraversing_;
        }
    }

    private class TestFilter
    implements IURIFilter {
        private Hashtable table_;

        public TestFilter(Hashtable table) {
            this.table_ = table;
        }

        public boolean accepts(IURI uri) {
            NodeEntry entry = (NodeEntry)this.table_.get(FileURITests.this.getName(uri));
            return entry.visitNode_;
        }
    }

    private class NodeEntry {
        public boolean visitNode_;
        public boolean stopTraversing_;
        public boolean wasVisited_;
        public boolean shouldBeVisited_;

        public NodeEntry() {
            this(true, false, true);
        }

        public NodeEntry(boolean visitNode, boolean stop, boolean shouldBeVisited) {
            this.visitNode_ = visitNode;
            this.stopTraversing_ = stop;
            this.shouldBeVisited_ = shouldBeVisited;
            this.wasVisited_ = false;
        }
    }
}

