/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

public class FocusTracker {
    private final Set<Control> trackedControls = new HashSet<Control>();
    private final Listener listener = event -> {
        switch (event.type) {
            case 12: {
                this.trackedControls.remove(event.widget);
                break;
            }
            case 15: 
            case 16: {
                if (!(event.widget instanceof Control)) break;
                this.lastFocusControl = (Control)event.widget;
                break;
            }
        }
    };
    private Control lastFocusControl;

    private void hookControl(@NonNull Control control) {
        control.addListener(12, this.listener);
        control.addListener(15, this.listener);
        control.addListener(16, this.listener);
    }

    private void unhookControl(@NonNull Control control) {
        control.removeListener(16, this.listener);
        control.removeListener(15, this.listener);
        control.removeListener(12, this.listener);
    }

    public void addToFocusTracking(@NonNull Control control) {
        if (this.trackedControls.add(control)) {
            this.hookControl(control);
        }
    }

    public void removeFromFocusTracking(Control control) {
        if (this.trackedControls.remove(control) && !control.isDisposed()) {
            this.unhookControl(control);
        }
    }

    public Control getLastFocusControl() {
        if (this.lastFocusControl != null && this.lastFocusControl.isDisposed()) {
            this.trackedControls.remove(this.lastFocusControl);
            this.lastFocusControl = null;
        }
        return this.lastFocusControl;
    }

    public void dispose() {
        for (Control tracked : this.trackedControls) {
            if (tracked.isDisposed()) continue;
            this.unhookControl(tracked);
        }
        this.trackedControls.clear();
        this.lastFocusControl = null;
    }
}

