/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.controls.BrowserComposite;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;

public class BrowserMessageDialog
extends Dialog {
    private static final String HTML_HEADER = "<html><head><style type=\"text/css\"> body { background-color: %bg_color%; font-size: 8pt; font-family: Verdana;Helvetica;} table { font-size: 8pt; font-family: Verdana;Helvetica;} h3 {font-size: 10pt;}</style></head><body>";
    private static final String HTML_FOOTER = "</body></html>";
    private final String m_title;
    private String m_htmlToShow;

    protected BrowserMessageDialog(Shell parentShell, String title) {
        super(parentShell);
        this.m_title = title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(area, 0);
        GridDataFactory.modify((Control)composite).grab().fill();
        composite.setLayout((Layout)new FillLayout());
        BrowserComposite browser = new BrowserComposite(composite, 0);
        browser.setText(this.m_htmlToShow);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return this.getParentShell().getSize();
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.getParentShell().getLocation();
    }

    public void setHTML(String html) {
        this.m_htmlToShow = String.valueOf(StringUtils.replace((String)HTML_HEADER, (String)"%bg_color%", (String)DesignerExceptionUtils.getColorWebString(IColorConstants.button))) + (this.m_title != null ? "<h3>" + this.m_title + "</h3>" : "") + html + HTML_FOOTER;
    }

    public static void openMessage(Shell shell, String title, String html) {
        BrowserMessageDialog dialog = new BrowserMessageDialog(shell, title);
        dialog.setHTML(html);
        dialog.open();
    }
}

