/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.xml.model.AbstractComponentInfo;
import org.eclipse.wb.internal.core.xml.model.TopBoundsSupport;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.xwt.support.CoordinateUtils;

public class CompositeTopBoundsSupport
extends TopBoundsSupport {
    public CompositeTopBoundsSupport(ControlInfo control) {
        super((AbstractComponentInfo)control);
    }

    public void apply() throws Exception {
        Control control = (Control)this.m_component.getComponentObject();
        Dimension size = this.getResourceSize();
        control.setSize(size.width, size.height);
        CompositeTopBoundsSupport.configureShellWrapper(control);
    }

    public void setSize(int width, int height) throws Exception {
        this.setResourceSize(width, height);
    }

    public boolean show() throws Exception {
        Control control = (Control)this.m_component.getObject();
        CompositeTopBoundsSupport.show(control);
        return true;
    }

    public static void show(Control control) throws Exception {
        CompositeTopBoundsSupport.showBefore();
        try {
            CompositeTopBoundsSupport.show0(control);
        }
        finally {
            CompositeTopBoundsSupport.showAfter();
        }
    }

    private static void showBefore() throws Exception {
        Shell eclipseShell = DesignerPlugin.getShell();
        if (EnvironmentUtils.IS_MAC) {
            eclipseShell.redraw();
            eclipseShell.update();
            eclipseShell.setRedraw(false);
        }
        eclipseShell.setEnabled(false);
    }

    private static void showAfter() throws Exception {
        Shell eclipseShell = DesignerPlugin.getShell();
        if (EnvironmentUtils.IS_MAC) {
            eclipseShell.setRedraw(true);
        }
        eclipseShell.setEnabled(true);
        eclipseShell.forceActive();
    }

    private static void show0(Control control) throws Exception {
        Shell shell = CompositeTopBoundsSupport.configureShellWrapper(control);
        Runnable clearESC = CompositeTopBoundsSupport.closeOnESC(shell);
        Rectangle monitorClientArea = DesignerPlugin.getShell().getMonitor().getClientArea();
        org.eclipse.wb.draw2d.geometry.Rectangle shellBounds = CoordinateUtils.getBounds((Control)shell);
        int x = monitorClientArea.x + (monitorClientArea.width - shellBounds.width) / 2;
        int y = monitorClientArea.y + (monitorClientArea.height - shellBounds.height) / 2;
        x = Math.max(x, monitorClientArea.x + 10);
        y = Math.max(y, monitorClientArea.y + 10);
        shell.setLocation(x, y);
        CompositeTopBoundsSupport.showShell(shell);
        clearESC.run();
    }

    private static Shell configureShellWrapper(Control control) throws Exception {
        Shell shell = control.getShell();
        if (control != shell) {
            shell.setText("Wrapper Shell");
            shell.setLayout((Layout)new FillLayout());
            org.eclipse.wb.draw2d.geometry.Rectangle controlBounds = CoordinateUtils.getBounds(control);
            Dimension trimSize = CoordinateUtils.computeTrimSize((Composite)shell, controlBounds.width, controlBounds.height);
            shell.setSize(trimSize.width, trimSize.height);
            shell.layout();
        }
        return shell;
    }

    private static void showShell(Shell shell) throws Exception {
        shell.setVisible(true);
        shell.setActive();
        Display display = shell.getDisplay();
        while (!shell.isDisposed() && shell.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private static Runnable closeOnESC(final Shell shell) {
        final Display display = DesignerPlugin.getStandardDisplay();
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 27) {
                    shell.close();
                    event.doit = false;
                }
            }
        };
        display.addFilter(1, listener);
        return new Runnable(){

            @Override
            public void run() {
                display.removeFilter(1, listener);
            }
        };
    }
}

