/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentObject;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentModelVisitor;
import org.eclipse.wb.internal.core.utils.xml.DocumentTextNode;
import org.eclipse.wb.internal.core.utils.xml.ModelChangedEvent;

public class DocumentElement
extends AbstractDocumentObject {
    public static final String P_XML_TAG_NAME = "P_XML_TAG_NAME";
    private String m_tag;
    private boolean m_closed;
    private int m_offset;
    private int m_length;
    private int m_openTagOffset;
    private int m_openTagLength;
    private int m_closeTagOffset;
    private int m_closeTagLength;
    private DocumentElement m_parent;
    final List<DocumentElement> m_children = new ArrayList<DocumentElement>();
    private DocumentTextNode m_textNode;
    private final Map<String, DocumentAttribute> m_attributes = new LinkedHashMap<String, DocumentAttribute>();

    public DocumentElement() {
    }

    public DocumentElement(String tag) {
        this.m_tag = tag;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.write(printWriter, "");
        return stringWriter.toString();
    }

    public String getTag() {
        return this.m_tag;
    }

    public String getTagLocal() {
        int index = this.m_tag.indexOf(":");
        if (index == -1) {
            return this.m_tag;
        }
        return this.m_tag.substring(index + 1);
    }

    public String getTagNS() {
        int index = this.m_tag.indexOf(":");
        if (index == -1) {
            return "";
        }
        return this.m_tag.substring(0, index + 1);
    }

    public void setTag(String tag) {
        if (!StringUtils.equals((CharSequence)this.m_tag, (CharSequence)tag)) {
            String oldValue = this.m_tag;
            this.m_tag = tag;
            this.firePropertyChanged(this, P_XML_TAG_NAME, oldValue, this.m_tag);
        }
    }

    public void setTagLocal(String localTag) {
        String tag = this.getTagNS() + localTag;
        this.setTag(tag);
    }

    public boolean isClosed() {
        return this.m_closed;
    }

    public void setClosed(boolean closed) {
        this.m_closed = closed;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public void setOffset(int offset) {
        this.m_offset = offset;
    }

    public int getLength() {
        return this.m_length;
    }

    public void setLength(int length) {
        this.m_length = length;
    }

    public int getOpenTagOffset() {
        return this.m_openTagOffset;
    }

    public void setOpenTagOffset(int openTagOffset) {
        this.m_openTagOffset = openTagOffset;
    }

    public int getOpenTagLength() {
        return this.m_openTagLength;
    }

    public void setOpenTagLength(int openTagLength) {
        this.m_openTagLength = openTagLength;
    }

    public int getCloseTagOffset() {
        return this.m_closeTagOffset;
    }

    public void setCloseTagOffset(int closeTagOffset) {
        this.m_closeTagOffset = closeTagOffset;
    }

    public int getCloseTagLength() {
        return this.m_closeTagLength;
    }

    public void setCloseTagLength(int closeTagLength) {
        this.m_closeTagLength = closeTagLength;
    }

    public void setParent(DocumentElement parent) {
        this.m_parent = parent;
    }

    public DocumentElement getParent() {
        return this.m_parent;
    }

    public DocumentElement getRoot() {
        if (this.m_parent == null) {
            return this;
        }
        return this.m_parent.getRoot();
    }

    public void addChild(DocumentElement child) {
        this.addChild(child, this.m_children.size());
    }

    public void addChild(DocumentElement child, int index) {
        this.m_children.add(index, child);
        child.setParent(this);
        child.setModel(this.getModel());
        this.fireStructureChanged(child, 1);
    }

    public void moveChild(DocumentElement child, int index) {
        if (index == -1) {
            index = this.m_children.size();
        }
        this.fireModelChanged(new ModelChangedEvent(2, child, "" + index, child.getParent(), this));
    }

    public void removeChild(DocumentElement child) {
        int index = this.m_children.indexOf(child);
        if (index != -1) {
            this.m_children.remove(index);
            this.fireStructureChanged(child, 3);
        }
    }

    public void remove() {
        this.m_parent.removeChild(this);
    }

    public void removeChildren() {
        while (!this.m_children.isEmpty()) {
            this.m_children.get(0).remove();
        }
    }

    public List<DocumentElement> getChildren() {
        return List.copyOf(this.m_children);
    }

    public final <T extends DocumentElement> List<T> getChildren(Class<T> elementClass) {
        ArrayList<DocumentElement> result = new ArrayList<DocumentElement>();
        for (DocumentElement child : this.getChildren()) {
            if (!elementClass.isInstance(child)) continue;
            result.add(child);
        }
        return result;
    }

    public DocumentElement getDirectChild(DocumentElement child) {
        while (child != null) {
            if (child.getParent() == this) {
                return child;
            }
            child = child.getParent();
        }
        return null;
    }

    public int indexOf(DocumentElement child) {
        return this.m_children.indexOf(child);
    }

    public DocumentElement getChildAt(int index) {
        return this.m_children.get(index);
    }

    public DocumentElement getChild(String tag, boolean ignoreCase) {
        for (DocumentElement child : this.m_children) {
            if (!(ignoreCase ? child.getTag().equalsIgnoreCase(tag) : child.getTag().equals(tag))) continue;
            return child;
        }
        return null;
    }

    public DocumentTextNode getTextNode() {
        return this.m_textNode;
    }

    public void setTextNode(DocumentTextNode textNode) {
        this.m_textNode = textNode;
        this.m_textNode.setEnclosingElement(this);
        this.m_textNode.setModel(this.getModel());
        this.fireStructureChanged(this.m_textNode, 1);
    }

    public void removeTextNode() {
        if (this.m_textNode != null) {
            DocumentTextNode textNode = this.m_textNode;
            this.m_textNode = null;
            this.fireStructureChanged(textNode, 3);
        }
    }

    public void setText(String text, boolean isCDATA) {
        if (text != null) {
            DocumentTextNode textNode = new DocumentTextNode(isCDATA);
            textNode.setText(text);
            this.setTextNode(textNode);
        } else {
            this.removeTextNode();
        }
    }

    public DocumentAttribute setAttribute(String name, String value) {
        DocumentAttribute attribute = this.getDocumentAttribute(name);
        if (value == null) {
            if (attribute != null) {
                this.removeDocumentAttribute(attribute);
            }
            return attribute;
        }
        if (attribute == null) {
            attribute = new DocumentAttribute();
            attribute.setModel(this.getModel());
            attribute.setName(name);
            attribute.setValue(value);
            attribute.setEnclosingElement(this);
            this.m_attributes.put(attribute.getName(), attribute);
            this.fireStructureChanged(attribute, 1);
            return attribute;
        }
        attribute.setValue(value);
        return attribute;
    }

    public String getAttribute(String name) {
        DocumentAttribute attribute = this.m_attributes.get(name);
        return attribute != null ? attribute.getValue() : null;
    }

    public DocumentAttribute getDocumentAttribute(String name) {
        return this.m_attributes.get(name);
    }

    public List<DocumentAttribute> getDocumentAttributes() {
        return List.copyOf(this.m_attributes.values());
    }

    public void removeDocumentAttribute(DocumentAttribute attribute) {
        this.m_attributes.remove(attribute.getName());
        this.fireStructureChanged(attribute, 3);
    }

    public void write(PrintWriter writer, String indent) {
        if (this.m_children.isEmpty()) {
            writer.print(indent);
            writer.print("<");
            writer.print(this.m_tag);
            this.writeAttributes(writer);
            if (this.m_textNode == null) {
                writer.print("/>\n");
            } else {
                writer.print(">");
                writer.print(this.m_textNode.getRawText());
                writer.print("</");
                writer.print(this.m_tag);
                writer.print(">\n");
            }
        } else {
            writer.print(indent);
            writer.print("<");
            writer.print(this.m_tag);
            this.writeAttributes(writer);
            writer.print(">\n");
            String childrenIndent = indent + "\t";
            for (DocumentElement child : this.m_children) {
                child.write(writer, childrenIndent);
            }
            writer.print(indent);
            writer.print("</");
            writer.print(this.m_tag);
            writer.print(">\n");
        }
    }

    public void writeShort(PrintWriter writer) {
        writer.print("<");
        writer.print(this.m_tag);
        this.writeAttributes(writer);
        writer.print(">");
    }

    private void writeAttributes(PrintWriter writer) {
        for (DocumentAttribute attribute : this.getDocumentAttributes()) {
            writer.print(" ");
            attribute.write(writer);
        }
    }

    public final void accept(DocumentModelVisitor visitor) {
        if (visitor.visit(this)) {
            for (DocumentAttribute attribute : this.getDocumentAttributes()) {
                visitor.visit(attribute);
            }
            if (this.m_textNode != null) {
                visitor.visit(this.m_textNode);
            }
            for (DocumentElement child : this.getChildren()) {
                child.accept(visitor);
            }
            visitor.endVisit(this);
        }
    }
}

