/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;

public class Label
extends Figure {
    private String m_text = "";
    private Dimension m_preferredSize;

    public Label() {
    }

    public Label(String text) {
        this.setText(text);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.m_preferredSize == null) {
            this.m_preferredSize = FigureUtils.calculateTextSize(this.m_text, this.getFont());
            Insets insets = this.getInsets();
            this.m_preferredSize.expand(insets.getWidth(), insets.getHeight());
        }
        return this.m_preferredSize;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!this.m_text.equals(text)) {
            this.m_text = text;
            if (this.isVisible()) {
                this.revalidate();
                this.repaint();
            }
        }
    }

    public void invalidate() {
        this.m_preferredSize = null;
        super.invalidate();
    }

    @Override
    protected void paintClientArea(Graphics graphics) {
        graphics.drawText(this.m_text, 0, 0);
    }
}

