/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.accessor;

import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JPanel;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IAccessibleExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IExposableExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.SetterAccessor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class SetterAccessorTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getGetter() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        SetterAccessor accessor = (SetterAccessor)SetterAccessorTest.getGenericPropertyAccessors(property).get(0);
        Method getter = accessor.getGetter();
        SetterAccessorTest.assertNotNull((Object)getter);
        SetterAccessorTest.assertEquals((Object)"isEnabled", (Object)getter.getName());
    }

    @Test
    public void test_setGetter() throws Exception {
        Method setter = ReflectionUtils.getMethodBySignature(JPanel.class, (String)"setEnabled(boolean)");
        Method getter = ReflectionUtils.getMethodBySignature(JPanel.class, (String)"isEnabled()");
        SetterAccessorTest.assertNotNull((Object)setter);
        SetterAccessorTest.assertNotNull((Object)getter);
        SetterAccessor accessor = new SetterAccessor(setter, getter);
        SetterAccessorTest.assertSame((Object)setter, (Object)accessor.getSetter());
        SetterAccessorTest.assertSame((Object)getter, (Object)accessor.getGetter());
        Method newGetter = ReflectionUtils.getMethodBySignature(JPanel.class, (String)"isVisible()");
        SetterAccessorTest.assertNotNull((Object)newGetter);
        accessor.setGetter(newGetter);
        SetterAccessorTest.assertSame((Object)newGetter, (Object)accessor.getGetter());
    }

    @Test
    public void test_IAccessibleExpressionAccessor() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        SetterAccessor accessor = (SetterAccessor)SetterAccessorTest.getGenericPropertyAccessors(property).get(0);
        IAccessibleExpressionAccessor accessibleAccessor = (IAccessibleExpressionAccessor)accessor.getAdapter(IAccessibleExpressionAccessor.class);
        SetterAccessorTest.assertNotNull((Object)accessibleAccessor);
        SetterAccessorTest.assertNotNull((Object)ReflectionUtils.getFieldByName(accessibleAccessor.getClass(), (String)"val$method"));
    }

    @Test
    public void test_PropertyTooltipProvider() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        SetterAccessor accessor = (SetterAccessor)SetterAccessorTest.getGenericPropertyAccessors(property).get(0);
        SetterAccessorTest.assertNull((Object)accessor.getAdapter(null));
        PropertyTooltipProvider tooltipProvider = (PropertyTooltipProvider)accessor.getAdapter(PropertyTooltipProvider.class);
        SetterAccessorTest.assertNotNull((Object)tooltipProvider);
        SetterAccessorTest.assertNotNull((Object)ReflectionUtils.getFieldByName(tooltipProvider.getClass(), (String)"val$method"));
    }

    @Test
    public void test_setExpression_remove() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        SetterAccessor accessor = (SetterAccessor)SetterAccessorTest.getGenericPropertyAccessors(property).get(0);
        SetterAccessorTest.assertFalse((boolean)((BooleanLiteral)accessor.getExpression((JavaInfo)panel)).booleanValue());
        accessor.setExpression((JavaInfo)panel, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setExpression_sameSource() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        ExpressionAccessor setterAccessor = SetterAccessorTest.getGenericPropertyAccessors(property).get(0);
        SetterAccessorTest.assertFalse((boolean)((BooleanLiteral)setterAccessor.getExpression((JavaInfo)panel)).booleanValue());
        setterAccessor.setExpression((JavaInfo)panel, "false");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_setExpression_newSource() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        ExpressionAccessor setterAccessor = SetterAccessorTest.getGenericPropertyAccessors(property).get(0);
        SetterAccessorTest.assertTrue((boolean)((BooleanLiteral)setterAccessor.getExpression((JavaInfo)panel)).booleanValue());
        setterAccessor.setExpression((JavaInfo)panel, "false");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_setExpression_newInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        ExpressionAccessor setterAccessor = SetterAccessorTest.getGenericPropertyAccessors(property).get(0);
        SetterAccessorTest.assertNull((Object)setterAccessor.getExpression((JavaInfo)panel));
        setterAccessor.setExpression((JavaInfo)panel, "false");
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_setExpression_replaceComponent() throws Exception {
        SetterAccessorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(String o) {", "  }", "}"));
        SetterAccessorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  public Test() {", "    setFoo(button_1.getName());", "    add(button_1);", "    add(button_2);", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)SetterAccessorTest.getJavaInfoByName("button_1");
        ComponentInfo button_2 = (ComponentInfo)SetterAccessorTest.getJavaInfoByName("button_2");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("foo");
        SetterAccessorTest.assertNotNull((Object)property);
        ExpressionAccessor setterAccessor = SetterAccessorTest.getGenericPropertyAccessors(property).get(0);
        MethodInvocation invocation = (MethodInvocation)setterAccessor.getExpression((JavaInfo)panel);
        SetterAccessorTest.assertTrue((boolean)button_1.isRepresentedBy((ASTNode)invocation.getExpression()));
        String source = TemplateUtils.format((String)"{0}.getName()", (Object[])new Object[]{button_2});
        setterAccessor.setExpression((JavaInfo)panel, source);
        this.assertEditor("public class Test extends MyPanel {", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  public Test() {", "    setFoo(button_2.getName());", "    add(button_1);", "    add(button_2);", "  }", "}");
    }

    @Test
    public void test_exposable() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        SetterAccessor setterAccessor = (SetterAccessor)SetterAccessorTest.getGenericPropertyAccessors(property).get(0);
        IExposableExpressionAccessor exposableAccessor = (IExposableExpressionAccessor)setterAccessor.getAdapter(IExposableExpressionAccessor.class);
        SetterAccessorTest.assertSame(Boolean.TYPE, (Object)exposableAccessor.getValueClass((JavaInfo)panel));
        SetterAccessorTest.assertEquals((Object)"isEnabled()", (Object)exposableAccessor.getGetterCode((JavaInfo)panel));
        SetterAccessorTest.assertEquals((Object)"setEnabled(true)", (Object)exposableAccessor.getSetterCode((JavaInfo)panel, "true"));
        property = (GenericProperty)panel.getPropertyByTitle("alignmentX");
        setterAccessor = (SetterAccessor)SetterAccessorTest.getGenericPropertyAccessors(property).get(0);
        exposableAccessor = (IExposableExpressionAccessor)setterAccessor.getAdapter(IExposableExpressionAccessor.class);
        SetterAccessorTest.assertSame(Float.TYPE, (Object)exposableAccessor.getValueClass((JavaInfo)panel));
        SetterAccessorTest.assertEquals((Object)"getAlignmentX()", (Object)exposableAccessor.getGetterCode((JavaInfo)panel));
        SetterAccessorTest.assertEquals((Object)"setAlignmentX(1.0)", (Object)exposableAccessor.getSetterCode((JavaInfo)panel, "1.0"));
    }

    @Test
    public void test_defaultValue() throws Exception {
        SetterAccessorTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(String s) {", "    setText(s);", "  }", "}"));
        SetterAccessorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton('A'));", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property constructorTextProperty = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/s");
        Property textProperty = button.getPropertyByTitle("text");
        SetterAccessorTest.assertEquals((Object)"A", (Object)constructorTextProperty.getValue());
        SetterAccessorTest.assertEquals((Object)"A", (Object)textProperty.getValue());
        constructorTextProperty.setValue((Object)"B");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton('B'));", "  }", "}");
        SetterAccessorTest.assertEquals((Object)"B", (Object)constructorTextProperty.getValue());
        SetterAccessorTest.assertEquals((Object)"B", (Object)textProperty.getValue());
    }

    @Test
    public void test_noDefaultValue() throws Exception {
        SetterAccessorTest.setFileContentSrc("test/MyComponent.java", this.getTestSource("public class MyComponent extends JComponent {", "  public MyComponent() {", "  }", "}"));
        SetterAccessorTest.setFileContentSrc("test/MyComponent.wbp-component.xml", SetterAccessorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property-tag name='enabled' tag='noDefaultValue' value='true'/>", "</component>"));
        SetterAccessorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyComponent());", "  }", "}");
        ComponentInfo myComponent = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("enabled");
        List<ExpressionAccessor> accessors = SetterAccessorTest.getGenericPropertyAccessors(property);
        SetterAccessorTest.assertEquals((long)1L, (long)accessors.size());
        SetterAccessor setterAccessor = (SetterAccessor)accessors.get(0);
        SetterAccessorTest.assertEquals((Object)Boolean.TRUE, (Object)setterAccessor.getDefaultValue((JavaInfo)panel));
        property = (GenericProperty)myComponent.getPropertyByTitle("enabled");
        accessors = SetterAccessorTest.getGenericPropertyAccessors(property);
        SetterAccessorTest.assertEquals((long)1L, (long)accessors.size());
        setterAccessor = (SetterAccessor)accessors.get(0);
        SetterAccessorTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)setterAccessor.getDefaultValue((JavaInfo)myComponent));
    }

    @Test
    public void test_noDefaultValuesForThis() throws Exception {
        SetterAccessorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JComponent {", "  public int getFoo() {", "    return 555;", "  }", "  public void setFoo(int foo) {", "  }", "}"));
        SetterAccessorTest.setFileContentSrc("test/MyPanel.wbp-component.xml", SetterAccessorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='noDefaultValuesForThis'>true</parameter>", "  </parameters>", "</component>"));
        SetterAccessorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        SetterAccessorTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)panel.getPropertyByTitle("foo").getValue());
    }

    @Test
    public void test_exceptionInDefaultValue() throws Exception {
        SetterAccessorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public int getFoo() {", "    throw new Error();", "  }", "  public void setFoo(int foo) {", "  }", "}"));
        SetterAccessorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        SetterAccessorTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)panel.getPropertyByTitle("foo").getValue());
    }
}

