/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.keyboard.SWTKeyboardStrategy;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.matchers.WithText;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.utils.Traverse;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRootMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.wb.core.controls.CTableCombo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.StringPropertyInfo;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.SourceComposite;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.tests.designer.core.nls.ui.AbstractDialogTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.eclipse.wb.tests.utils.SWTBotCTableCombo;
import org.eclipse.wb.tests.utils.SWTBotEditableSource;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SourceCompositeTest
extends AbstractDialogTest {
    private static String SWTBOT_KEYBOARD_STRATEGY;
    private static String SWTBOT_KEYBOARD_LAYOUT;

    @BeforeClass
    public static void setUpAll() {
        SWTBOT_KEYBOARD_STRATEGY = SWTBotPreferences.KEYBOARD_STRATEGY;
        SWTBotPreferences.KEYBOARD_STRATEGY = SWTKeyboardStrategy.class.getName();
        SWTBOT_KEYBOARD_LAYOUT = SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
    }

    @AfterClass
    public static void tearDownAll() {
        SWTBotPreferences.KEYBOARD_STRATEGY = SWTBOT_KEYBOARD_STRATEGY;
        SWTBotPreferences.KEYBOARD_LAYOUT = SWTBOT_KEYBOARD_LAYOUT;
    }

    @Test
    public void test_ITableTooltipProvider() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Externalize strings").bot();
                SourceCompositeTest.assertItems(shell, "test.messages", "Properties");
                SourceCompositeTest.assertTrue((boolean)shell.tabItem("test.messages").isActive());
                SWTBotTable table = shell.table();
                SourceCompositeTest.assertItems(table, {"frame.name", "My name"}, {"frame.title", "My JFrame"});
                Throwable throwable = null;
                Object var6_7 = null;
                try (SWTBotTableTooltipProvider provider = SourceCompositeTest.getTableToolTipProvider(shell);){
                    Control control = provider.createTooltipControl(table.getTableItem(1), 1);
                    SourceCompositeTest.assertNull((Object)control);
                    control = provider.createTooltipControl(table.getTableItem(0), 0);
                    SourceCompositeTest.assertNull((Object)control);
                    control = provider.createTooltipControl(table.getTableItem(1), 0);
                    SourceCompositeTest.assertNotNull((Object)control);
                    SourceCompositeTest.assertTrue((provider.getChildren().length > 0 ? 1 : 0) != 0);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        });
    }

    @Test
    public void test_contextMenu_removeLocale() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceCompositeTest.setFileContentSrc("test/messages_it.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame IT", "frame.name=My name IT"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Externalize strings").bot();
                SourceCompositeTest.assertItems(shell, "test.messages", "Properties");
                SourceCompositeTest.assertTrue((boolean)shell.tabItem("test.messages").isActive());
                SWTBotTable table = shell.table();
                table.getTableItem(0).click(2);
                SWTBotRootMenu tableMenu = new SWTBotRootMenu((Menu)UIThreadRunnable.syncExec(() -> {
                    Menu menu = ((Table)sWTBotTable.widget).getMenu();
                    menu.setVisible(true);
                    return menu;
                }));
                final SWTBotMenu removeLocaleItem = tableMenu.menu(new String[]{"Remove locale..."});
                context.execute(new FailableRunnable<Exception>(){

                    public void run() {
                        removeLocaleItem.click();
                    }
                });
                bot.waitUntil((ICondition)Conditions.waitForShell((Matcher)WithText.withText((String)"Confirm")));
                bot.shell("Confirm").bot().button("Cancel").click();
                SourceCompositeTest.assertItems(table, {"frame.name", "My name", "My name IT"}, {"frame.title", "My JFrame", "My JFrame IT"});
                context.execute(new FailableRunnable<Exception>(){

                    public void run() {
                        removeLocaleItem.click();
                    }
                });
                bot.waitUntil((ICondition)Conditions.waitForShell((Matcher)WithText.withText((String)"Confirm")));
                bot.shell("Confirm").bot().button("OK").click();
                SourceCompositeTest.assertItems(table, {"frame.name", "My name"}, {"frame.title", "My JFrame"});
                shell.button("OK").click();
            }
        });
        SourceCompositeTest.assertFalse((boolean)SourceCompositeTest.getFileSrc("test/messages_it.properties").exists());
    }

    @Test
    public void test_contextMenu_internalizeKey() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Externalize strings").bot();
                SourceCompositeTest.assertItems(shell, "test.messages", "Properties");
                SourceCompositeTest.assertTrue((boolean)shell.tabItem("test.messages").isActive());
                SWTBotTable table = shell.table();
                SWTBotRootMenu tableMenu = table.getTableItem(0).contextMenu();
                final SWTBotMenu internalizeItem = tableMenu.contextMenu("Internalize key...");
                context.execute(new FailableRunnable<Exception>(){

                    public void run() {
                        internalizeItem.click();
                    }
                });
                bot.shell("Confirm").bot().button("Cancel").click();
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}});
                context.execute(new FailableRunnable<Exception>(){

                    public void run() {
                        internalizeItem.click();
                    }
                });
                bot.shell("Confirm").bot().button("OK").click();
                SourceCompositeTest.assertItems(table, new String[0][]);
                shell.button("OK").click();
            }
        });
        this.assertEditor("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(\"My JFrame\");\n\t}\n}");
        SourceCompositeTest.assertFalse((boolean)SourceCompositeTest.getFileContentSrc("test/messages.properties").contains("frame.title"));
    }

    @Test
    public void test_contextMenu_addLocale() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Externalize strings").bot();
                SourceCompositeTest.assertItems(shell, "test.messages", "Properties");
                SourceCompositeTest.assertTrue((boolean)shell.tabItem("test.messages").isActive());
                SWTBotTable table = shell.table();
                SWTBotRootMenu tableMenu = table.getTableItem(0).click().contextMenu();
                final SWTBotMenu addLocaleItem = tableMenu.menu(new String[]{"Add locale..."});
                context.execute(new FailableRunnable<Exception>(){

                    public void run() {
                        addLocaleItem.click();
                    }
                });
                SWTBot shell2 = bot.shell("Choose Locale").bot();
                SWTBotCTableCombo languagesCombo = SourceCompositeTest.getLanguageCombo(shell2);
                int i = 0;
                while (i < languagesCombo.getItemCount()) {
                    String item = languagesCombo.getItem(i);
                    if (item.startsWith("it - ")) {
                        languagesCombo.select(i);
                        break;
                    }
                    ++i;
                }
                shell2.button("OK").click();
                SourceCompositeTest.assertColumns(table, "Key", "(default)", "it");
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame", "My JFrame"}});
                shell.button("OK").click();
            }
        });
        SourceCompositeTest.assertTrue((boolean)SourceCompositeTest.getFileSrc("test/messages_it.properties").exists());
    }

    @Test
    public void test_contextMenu_addLocaleWithButton() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                final SWTBot shell = bot.shell("Externalize strings").bot();
                context.execute(new FailableRunnable<Exception>(){

                    public void run() {
                        shell.button("New locale...").click();
                    }
                });
                bot.shell("Choose Locale").bot().button("Cancel").click();
            }
        });
    }

    @Test
    public void test_SourceComposite_edit() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame"));
        SourceCompositeTest.setFileContentSrc("test/messages_it.properties", SourceCompositeTest.getSourceDQ(""));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Externalize strings").bot();
                SourceCompositeTest.assertItems(shell, "test.messages", "Properties");
                SourceCompositeTest.assertTrue((boolean)shell.tabItem("test.messages").isActive());
                SWTBotEditableSource editableSource = SourceCompositeTest.getEditableSource(shell);
                SWTBotTable table = shell.table();
                SourceCompositeTest.assertColumns(table, "Key", "(default)", "it");
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame", ""}});
                table.click(0, 1);
                SWTBotText text = shell.text();
                text.setText("New title");
                text.pressShortcut(new KeyStroke[]{Keystrokes.CR});
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertTrue((boolean)editableSource.getKeys().contains("frame.title"));
                SourceCompositeTest.assertEquals((Object)"New title", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.title"));
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "New title", ""}});
                table.click(0, 0);
                text = shell.text();
                text.setText("frame.title2");
                text.pressShortcut(new KeyStroke[]{Keystrokes.CR});
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertFalse((boolean)editableSource.getKeys().contains("frame.title"));
                SourceCompositeTest.assertTrue((boolean)editableSource.getKeys().contains("frame.title2"));
                SourceCompositeTest.assertEquals((Object)"New title", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.title2"));
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title2", "New title", ""}});
                LocaleInfo localeInfo = new LocaleInfo(Locale.ITALIAN);
                SourceCompositeTest.assertNull((Object)editableSource.getValue(localeInfo, "frame.title2"));
                table.click(0, 2);
                SWTBotText text2 = shell.text();
                text2.setText("title IT");
                text2.pressShortcut(new KeyStroke[]{Keystrokes.CR});
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertEquals((Object)"title IT", (Object)editableSource.getValue(localeInfo, "frame.title2"));
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title2", "New title", "title IT"}});
                shell.button("OK").click();
            }
        });
    }

    @Test
    public void test_SourceComposite_update_externalize() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t\tsetName(\"My name\");\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Externalize strings").bot();
                SourceCompositeTest.assertItems(shell, "test.messages", "Properties");
                SourceCompositeTest.assertTrue((boolean)shell.tabItem("test.messages").isActive());
                SWTBotEditableSource editableSource = SourceCompositeTest.getEditableSource(shell);
                SWTBotTable table = shell.table();
                SourceCompositeTest.assertColumns(table, "Key", "(default)");
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}});
                GenericProperty nameProperty = (GenericProperty)SourceCompositeTest.this.m_contentJavaInfo.getPropertyByTitle("name");
                editableSource.externalize(new StringPropertyInfo(nameProperty), true);
                SourceCompositeTest.assertColumns(table, "Key", "(default)");
                SourceCompositeTest.assertItems(table, {"frame.title", "My JFrame"}, {"Test.this.name", "My name"});
            }
        });
    }

    @Test
    public void test_SourceComposite_update_renameOver() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t\tsetName(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.name\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Externalize strings").bot();
                SourceCompositeTest.assertItems(shell, "test.messages", "Properties");
                SourceCompositeTest.assertTrue((boolean)shell.tabItem("test.messages").isActive());
                SWTBotEditableSource editableSource = SourceCompositeTest.getEditableSource(shell);
                SWTBotTable table = shell.table();
                SourceCompositeTest.assertColumns(table, "Key", "(default)");
                SourceCompositeTest.assertItems(table, {"frame.name", "My name"}, {"frame.title", "My JFrame"});
                editableSource.renameKey("frame.name", "frame.title");
                bot.shell("Confirm").bot().button("Yes, keep existing value").click();
                SourceCompositeTest.assertColumns(table, "Key", "(default)");
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}});
            }
        });
    }

    @Test
    public void test_SourceComposite_onlyCurrentForm() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\tsetTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) {
                SWTBot shell = bot.shell("Externalize strings").bot();
                SourceCompositeTest.assertItems(shell, "test.messages", "Properties");
                SourceCompositeTest.assertTrue((boolean)shell.tabItem("test.messages").isActive());
                SWTBotTable table = shell.table();
                SourceCompositeTest.assertItems(table, {"frame.name", "My name"}, {"frame.title", "My JFrame"});
                SWTBotCheckBox onlyFormButton = shell.checkBox("Show strings only for current form");
                onlyFormButton.click();
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}});
            }
        });
    }

    @Test
    public void test_SourceComposite_navigation() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("#Direct ResourceBundle", "key.1=1 1", "key.2=2 1"));
        SourceCompositeTest.setFileContentSrc("test/messages_it.properties", SourceCompositeTest.getSourceDQ("#Direct ResourceBundle", "key.1=1 2", "key.2=2 2"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        this.openDialogNLS(initialSource, new FailableBiConsumer<UiContext, SWTBot, Exception>(){

            public void accept(UiContext context, SWTBot bot) throws InterruptedException {
                SWTBot shell = bot.shell("Externalize strings").bot();
                SourceCompositeTest.assertItems(shell, "test.messages", "Properties");
                SourceCompositeTest.assertFalse((boolean)shell.tabItem("test.messages").isActive());
                shell.tabItem("test.messages").activate();
                SWTBotTable table = shell.table();
                SourceCompositeTest.assertItems(table, {"key.1", "1 1", "1 2"}, {"key.2", "2 1", "2 2"});
                table.click(0, 1);
                shell.text().traverse(Traverse.TAB_NEXT);
                SWTBotText text = shell.text();
                text.setText("a b");
                text.pressShortcut(new KeyStroke[]{Keystrokes.CR});
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertItems(table, {"key.1", "1 1", "a b"}, {"key.2", "2 1", "2 2"});
                table.click(0, 2);
                shell.text().pressShortcut(new KeyStroke[]{Keystrokes.DOWN});
                SourceCompositeTest.waitEventLoop(10);
                text = shell.text();
                text.setText("b b");
                text.pressShortcut(new KeyStroke[]{Keystrokes.CR});
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertItems(table, {"key.1", "1 1", "a b"}, {"key.2", "2 1", "b b"});
                table.click(1, 2);
                shell.text().pressShortcut(131072, '\t');
                SourceCompositeTest.waitEventLoop(10);
                shell.text().setText("b a");
                shell.text().pressShortcut(new KeyStroke[]{Keystrokes.UP});
                SourceCompositeTest.waitEventLoop(10);
                text = shell.text();
                text.setText("a a");
                text.pressShortcut(new KeyStroke[]{Keystrokes.CR});
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertItems(table, {"key.1", "a a", "a b"}, {"key.2", "b a", "b b"});
            }
        });
    }

    private static SWTBotEditableSource getEditableSource(SWTBot shell) throws Exception {
        SourceComposite composite = (SourceComposite)shell.getFinder().findControls(WidgetOfType.widgetOfType(SourceComposite.class)).get(0);
        IEditableSource editableSource = (IEditableSource)ReflectionUtils.getFieldObject((Object)composite, (String)"m_source");
        return new SWTBotEditableSource(editableSource);
    }

    private static SWTBotCTableCombo getLanguageCombo(SWTBot shell) {
        CTableCombo widget = (CTableCombo)shell.getFinder().findControls(WidgetOfType.widgetOfType(CTableCombo.class)).get(0);
        if (widget == null) {
            return null;
        }
        return new SWTBotCTableCombo(widget);
    }

    private static SWTBotTableTooltipProvider getTableToolTipProvider(SWTBot shell) throws Exception {
        return new SWTBotTableTooltipProvider(shell);
    }

    protected static void waitEventLoop(int time) {
        UIThreadRunnable.syncExec(() -> SourceCompositeTest.waitEventLoop(time, 0L));
    }

    private static class SWTBotTableTooltipProvider
    extends SWTBot
    implements Closeable {
        private final Shell shell;
        private final UiUtils.ITableTooltipProvider provider;

        public SWTBotTableTooltipProvider(SWTBot parent) throws Exception {
            SourceComposite composite = (SourceComposite)parent.getFinder().findControls(WidgetOfType.widgetOfType(SourceComposite.class)).get(0);
            this.provider = (UiUtils.ITableTooltipProvider)ReflectionUtils.invokeMethod((Object)composite, (String)"createTooltipProvider()", (Object[])new Object[0]);
            this.shell = (Shell)UIThreadRunnable.syncExec(Shell::new);
        }

        public Control createTooltipControl(SWTBotTableItem tableItem, int column) {
            return (Control)UIThreadRunnable.syncExec(() -> this.provider.createTooltipControl((TableItem)sWTBotTableItem.widget, (Composite)this.shell, column));
        }

        public Control[] getChildren() {
            return (Control[])UIThreadRunnable.syncExec(() -> ((Shell)this.shell).getChildren());
        }

        @Override
        public void close() throws IOException {
            UIThreadRunnable.syncExec(() -> ((Shell)this.shell).dispose());
        }
    }
}

