/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.ui;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.internal.core.utils.ui.IActionSingleton;
import org.eclipse.wb.internal.core.utils.ui.MenuIntersector;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class MenuIntersectorTest
extends DesignerTestCase {
    @Test
    public void test() throws Exception {
        Action deleteAction = new Action("Delete"){};
        Action copyAction = new Action("Copy"){};
        Action pasteAction = new Action("Paste"){};
        IMenuManager manager1 = MenuIntersectorTest.createMenu(deleteAction, copyAction, pasteAction);
        MenuIntersectorTest.fillMenu1(manager1);
        IMenuManager manager2 = MenuIntersectorTest.createMenu(deleteAction, copyAction, pasteAction);
        MenuIntersectorTest.fillMenu2(manager2);
        ArrayList<IMenuManager> menus = new ArrayList<IMenuManager>();
        menus.add(manager1);
        menus.add(manager2);
        MenuManager main = new MenuManager();
        MenuIntersector.merge((IMenuManager)main, menus);
        IContributionItem[] items = main.getItems();
        MenuIntersectorTest.assertEquals((long)8L, (long)items.length);
        MenuIntersectorTest.assertInstanceOf(ActionContributionItem.class, (Object)items[0]);
        MenuIntersectorTest.assertSame((Object)copyAction.getText(), (Object)((ActionContributionItem)items[0]).getAction().getText());
        MenuIntersectorTest.assertInstanceOf(ActionContributionItem.class, (Object)items[1]);
        MenuIntersectorTest.assertSame((Object)pasteAction.getText(), (Object)((ActionContributionItem)items[1]).getAction().getText());
        MenuIntersectorTest.assertTrue((boolean)items[2].isSeparator());
        MenuIntersectorTest.assertInstanceOf(ActionContributionItem.class, (Object)items[3]);
        MenuIntersectorTest.assertSame((Object)deleteAction.getText(), (Object)((ActionContributionItem)items[3]).getAction().getText());
        MenuIntersectorTest.assertTrue((boolean)items[4].isSeparator());
        MenuIntersectorTest.assertInstanceOf(ActionContributionItem.class, (Object)items[5]);
        MenuIntersectorTest.assertEquals((Object)"Test", (Object)((ActionContributionItem)items[5]).getAction().getText());
        MenuIntersectorTest.assertInstanceOf(MenuManager.class, (Object)items[6]);
        MenuManager sub = (MenuManager)items[6];
        MenuIntersectorTest.assertEquals((Object)"layout", (Object)sub.getMenuText());
        IContributionItem[] subItems = sub.getItems();
        MenuIntersectorTest.assertEquals((long)1L, (long)subItems.length);
        MenuIntersectorTest.assertEquals((Object)"clear", (Object)((ActionContributionItem)subItems[0]).getAction().getText());
    }

    @Test
    public void test_2() throws Exception {
        Action deleteAction = new Action("Delete"){};
        Action copyAction = new Action("Copy"){};
        Action pasteAction = new Action("Paste"){};
        IMenuManager manager1 = MenuIntersectorTest.createMenu(deleteAction, copyAction, pasteAction);
        MenuIntersectorTest.fillMenu1(manager1);
        IMenuManager manager2 = MenuIntersectorTest.createMenu(deleteAction, copyAction, pasteAction);
        MenuIntersectorTest.fillMenu2(manager2);
        IMenuManager manager3 = MenuIntersectorTest.createMenu(deleteAction, copyAction, pasteAction);
        ArrayList<IMenuManager> menus = new ArrayList<IMenuManager>();
        menus.add(manager1);
        menus.add(manager2);
        menus.add(manager3);
        MenuManager main = new MenuManager();
        MenuIntersector.merge((IMenuManager)main, menus);
        IContributionItem[] items = main.getItems();
        MenuIntersectorTest.assertEquals((long)6L, (long)items.length);
        MenuIntersectorTest.assertInstanceOf(ActionContributionItem.class, (Object)items[0]);
        MenuIntersectorTest.assertSame((Object)copyAction.getText(), (Object)((ActionContributionItem)items[0]).getAction().getText());
        MenuIntersectorTest.assertInstanceOf(ActionContributionItem.class, (Object)items[1]);
        MenuIntersectorTest.assertSame((Object)pasteAction.getText(), (Object)((ActionContributionItem)items[1]).getAction().getText());
        MenuIntersectorTest.assertTrue((boolean)items[2].isSeparator());
        MenuIntersectorTest.assertInstanceOf(ActionContributionItem.class, (Object)items[3]);
        MenuIntersectorTest.assertSame((Object)deleteAction.getText(), (Object)((ActionContributionItem)items[3]).getAction().getText());
    }

    @Test
    public void test_runWithEvent_run() throws Exception {
        final boolean[] runExecuted_1 = new boolean[1];
        final boolean[] runExecuted_2 = new boolean[1];
        Action action_1 = new Action("The action"){

            public void run() {
                runExecuted_1[0] = true;
            }
        };
        Action action_2 = new Action("The action"){

            public void run() {
                runExecuted_2[0] = true;
            }
        };
        MenuManager manager_1 = new MenuManager();
        MenuManager manager_2 = new MenuManager();
        manager_1.add((IAction)action_1);
        manager_2.add((IAction)action_2);
        MenuManager main = new MenuManager();
        MenuIntersector.merge((IMenuManager)main, List.of(manager_1, manager_2));
        Object[] items = main.getItems();
        Assertions.assertThat((Object[])items).hasSize(1);
        IAction wrapperAction = ((ActionContributionItem)items[0]).getAction();
        runExecuted_1[0] = false;
        runExecuted_2[0] = false;
        wrapperAction.runWithEvent(null);
        MenuIntersectorTest.assertTrue((String)"action_1 executed", (boolean)runExecuted_1[0]);
        MenuIntersectorTest.assertTrue((String)"action_2 executed", (boolean)runExecuted_2[0]);
        runExecuted_1[0] = false;
        runExecuted_2[0] = false;
        wrapperAction.run();
        MenuIntersectorTest.assertTrue((String)"action_1 executed", (boolean)runExecuted_1[0]);
        MenuIntersectorTest.assertTrue((String)"action_2 executed", (boolean)runExecuted_2[0]);
    }

    @Test
    public void test_IActionSingleton() throws Exception {
        boolean[] runExecuted_1 = new boolean[1];
        boolean[] runExecuted_2 = new boolean[1];
        class MyAction
        extends Action
        implements IActionSingleton {
            private final boolean[] m_runFlag;

            public MyAction(String text, boolean[] runFlag) {
                super(text);
                this.m_runFlag = runFlag;
            }

            public void run() {
                this.m_runFlag[0] = true;
            }
        }
        MyAction action_1 = new MyAction("The action", runExecuted_1);
        MyAction action_2 = new MyAction("The action", runExecuted_2);
        MenuManager manager_1 = new MenuManager();
        MenuManager manager_2 = new MenuManager();
        manager_1.add((IAction)action_1);
        manager_2.add((IAction)action_2);
        MenuManager main = new MenuManager();
        MenuIntersector.merge((IMenuManager)main, List.of(manager_1, manager_2));
        Object[] items = main.getItems();
        Assertions.assertThat((Object[])items).hasSize(1);
        IAction wrapperAction = ((ActionContributionItem)items[0]).getAction();
        runExecuted_1[0] = false;
        runExecuted_2[0] = false;
        wrapperAction.run();
        MenuIntersectorTest.assertTrue((String)"action_1 executed", (boolean)runExecuted_1[0]);
        MenuIntersectorTest.assertFalse((String)"action_2 executed", (boolean)runExecuted_2[0]);
    }

    private static IMenuManager createMenu(Action deleteAction, Action copyAction, Action pasteAction) {
        MenuManager manager = new MenuManager();
        manager.add((IAction)copyAction);
        manager.add((IAction)pasteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)deleteAction);
        manager.add((IContributionItem)new Separator());
        return manager;
    }

    private static void fillMenu1(IMenuManager manager) {
        manager.add((IAction)new Action("Test"){});
        MenuManager sub = new MenuManager("layout");
        manager.add((IContributionItem)sub);
        sub.add((IAction)new Action("clear"){});
        sub.add((IAction)new Action("default"){});
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action("Default"){});
    }

    private static void fillMenu2(IMenuManager manager) {
        manager.add((IAction)new Action("Test"){});
        MenuManager sub = new MenuManager("layout");
        manager.add((IContributionItem)sub);
        sub.add((IAction)new Action("clear"){});
        sub.add((IAction)new Action("Default"){});
        manager.add((IContributionItem)new Separator());
        MenuManager sub2 = new MenuManager("Old");
        manager.add((IContributionItem)sub2);
        sub2.add((IAction)new Action("fill"){});
    }
}

