/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Ignore;
import org.junit.Test;

public class CutActionTest
extends SwingGefTest {
    @Test
    public void test_noSelection() throws Exception {
        this.openContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        IAction cutAction = this.getCutAction();
        this.canvas.select(new Object[0]);
        CutActionTest.assertFalse((boolean)cutAction.isEnabled());
    }

    @Test
    public void test_thisSelection() throws Exception {
        ContainerInfo panel = this.openContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        IAction cutAction = this.getCutAction();
        this.canvas.select(panel);
        CutActionTest.assertFalse((boolean)cutAction.isEnabled());
    }

    @Ignore
    @Test
    public void test_cutSingle() throws Exception {
        ContainerInfo panel = this.openContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tJButton button = new JButton(\"0\");\n\t\tadd(button);\n\t}\n}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.select(button);
        IAction cutAction = this.getCutAction();
        CutActionTest.assertTrue((boolean)cutAction.isEnabled());
        cutAction.run();
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        IAction pasteAction = this.getPasteAction();
        CutActionTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton(\"0\");\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
    }
}

