/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing;

import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class CustomizeTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noCustomizer() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tJButton button = new JButton(\"button\");\n\t\tadd(button);\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNull((Object)action);
    }

    @Test
    public void test_customizer() throws Exception {
        CustomizeTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class MyButton extends JButton {\n}"));
        CustomizeTest.setFileContentSrc("test/MyCustomizer.java", this.getTestSource("import java.beans.Customizer;\nimport java.beans.PropertyChangeListener;\npublic class MyCustomizer extends JPanel implements Customizer {\n\tpublic MyCustomizer() {\n\t\tSystem.setProperty(\"wbp.test.isDesignTime\",\n\t\t\tBoolean.toString(java.beans.Beans.isDesignTime()));\n\t}\n\tpublic void setObject(Object bean) {\n\t}\n\tpublic void addPropertyChangeListener(PropertyChangeListener listener) {\n\t}\n\tpublic void removePropertyChangeListener(PropertyChangeListener listener) {\n\t}\n}"));
        CustomizeTest.waitForAutoBuild();
        CustomizeTest.setFileContentSrc("test/MyButtonBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;\nimport java.beans.BeanDescriptor;\nimport java.beans.Introspector;\nimport java.beans.SimpleBeanInfo;\npublic class MyButtonBeanInfo extends SimpleBeanInfo {\n\tprivate BeanDescriptor m_descriptor;\n\tpublic MyButtonBeanInfo() {\n\t\tm_descriptor = new BeanDescriptor(MyButton.class, MyCustomizer.class);\n\t}\n\tpublic BeanDescriptor getBeanDescriptor() {\n\t\treturn m_descriptor;\n\t}\n\tpublic BeanInfo[] getAdditionalBeanInfo() {\n\t\ttry {\n\t\t\tBeanInfo info = Introspector.getBeanInfo(JButton.class);\n\t\t\treturn new BeanInfo[] {info};\n\t\t} catch (Throwable e) {\n\t\t}\n\t\treturn null;\n\t}\n}"));
        CustomizeTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tadd(button);\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                action.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Customize").bot();
                shell.button("OK").click();
            }
        });
        String value = System.clearProperty("wbp.test.isDesignTime");
        CustomizeTest.assertEquals((Object)"true", (Object)value);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tadd(button);\n\t}\n}");
    }

    @Test
    public void test_customizer_cursor() throws Exception {
        CustomizeTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {\n}"));
        CustomizeTest.setFileContentSrc("test/MyCustomizer.java", this.getTestSource("import java.beans.Customizer;\nimport java.awt.Cursor;\npublic class MyCustomizer extends JPanel implements Customizer {\n\tpublic void setObject(Object bean) {\n\t\tMyButton b = (MyButton) bean;\n\t\tCursor c = Cursor.getPredefinedCursor(Cursor.HAND_CURSOR);\n\t\tb.setCursor(c);\n\t}\n}"));
        CustomizeTest.waitForAutoBuild();
        CustomizeTest.setFileContentSrc("test/MyButtonBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;\nimport java.beans.BeanDescriptor;\nimport java.beans.Introspector;\nimport java.beans.SimpleBeanInfo;\npublic class MyButtonBeanInfo extends SimpleBeanInfo {\n\tprivate BeanDescriptor m_descriptor;\n\tpublic MyButtonBeanInfo() {\n\t\tm_descriptor = new BeanDescriptor(MyButton.class, MyCustomizer.class);\n\t}\n\tpublic BeanDescriptor getBeanDescriptor() {\n\t\treturn m_descriptor;\n\t}\n\tpublic BeanInfo[] getAdditionalBeanInfo() {\n\t\ttry {\n\t\t\tBeanInfo info = Introspector.getBeanInfo(JButton.class);\n\t\t\treturn new BeanInfo[] {info};\n\t\t} catch (Throwable e) {\n\t\t}\n\t\treturn null;\n\t}\n}"));
        CustomizeTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tadd(button);\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{buttonInfo});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                action.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Customize").bot();
                shell.button("OK").click();
            }
        });
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tbutton.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));\n\t\tadd(button);\n\t}\n}");
    }

    @Test
    public void test_customizer_orientation() throws Exception {
        CustomizeTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {\n}"));
        CustomizeTest.setFileContentSrc("test/MyCustomizer.java", this.getTestSource("import java.beans.Customizer;\nimport java.awt.ComponentOrientation;\npublic class MyCustomizer extends JPanel implements Customizer {\n\tpublic void setObject(Object bean) {\n\t\tMyButton b = (MyButton) bean;\n\t\tb.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);\n\t}\n}"));
        CustomizeTest.waitForAutoBuild();
        CustomizeTest.setFileContentSrc("test/MyButtonBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;\nimport java.beans.BeanDescriptor;\nimport java.beans.Introspector;\nimport java.beans.SimpleBeanInfo;\npublic class MyButtonBeanInfo extends SimpleBeanInfo {\n\tprivate BeanDescriptor m_descriptor;\n\tpublic MyButtonBeanInfo() {\n\t\tm_descriptor = new BeanDescriptor(MyButton.class, MyCustomizer.class);\n\t}\n\tpublic BeanDescriptor getBeanDescriptor() {\n\t\treturn m_descriptor;\n\t}\n\tpublic BeanInfo[] getAdditionalBeanInfo() {\n\t\ttry {\n\t\t\tBeanInfo info = Introspector.getBeanInfo(JButton.class);\n\t\t\treturn new BeanInfo[] {info};\n\t\t} catch (Throwable e) {\n\t\t}\n\t\treturn null;\n\t}\n}"));
        CustomizeTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tadd(button);\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{buttonInfo});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                action.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Customize").bot();
                shell.button("OK").click();
            }
        });
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tbutton.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);\n\t\tadd(button);\n\t}\n}");
    }

    @Test
    public void test_customizer_font() throws Exception {
        CustomizeTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {\n}"));
        CustomizeTest.setFileContentSrc("test/MyCustomizer.java", this.getTestSource("import java.beans.Customizer;\nimport java.awt.Font;\npublic class MyCustomizer extends JPanel implements Customizer {\n\tpublic void setObject(Object bean) {\n\t\tMyButton b = (MyButton) bean;\n\t\tb.setFont(new Font(Font.MONOSPACED, Font.BOLD, 12));\n\t}\n}"));
        CustomizeTest.waitForAutoBuild();
        CustomizeTest.setFileContentSrc("test/MyButtonBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;\nimport java.beans.BeanDescriptor;\nimport java.beans.Introspector;\nimport java.beans.SimpleBeanInfo;\npublic class MyButtonBeanInfo extends SimpleBeanInfo {\n\tprivate BeanDescriptor m_descriptor;\n\tpublic MyButtonBeanInfo() {\n\t\tm_descriptor = new BeanDescriptor(MyButton.class, MyCustomizer.class);\n\t}\n\tpublic BeanDescriptor getBeanDescriptor() {\n\t\treturn m_descriptor;\n\t}\n\tpublic BeanInfo[] getAdditionalBeanInfo() {\n\t\ttry {\n\t\t\tBeanInfo info = Introspector.getBeanInfo(JButton.class);\n\t\t\treturn new BeanInfo[] {info};\n\t\t} catch (Throwable e) {\n\t\t}\n\t\treturn null;\n\t}\n}"));
        CustomizeTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tadd(button);\n\t}\n}");
        panel.refresh();
        ComponentInfo buttonInfo = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{buttonInfo});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                action.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Customize").bot();
                shell.button("OK").click();
            }
        });
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tbutton.setFont(new Font(\"Monospaced\", Font.BOLD, 12));\n\t\tadd(button);\n\t}\n}");
    }

    @Test
    public void test_customizer_chageProperties_OK() throws Exception {
        this.prepare_customizer_changeProperties();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tadd(button);\n\t}\n}");
        panel.refresh();
        final ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                action.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Customize").bot();
                Object object = button.getObject();
                Object customizer = ReflectionUtils.getFieldObject((Object)object, (String)"customizer");
                ReflectionUtils.invokeMethod((Object)customizer, (String)"doBeanChanges()", (Object[])new Object[0]);
                shell.button("OK").click();
            }
        });
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tbutton.setTitle('New title');\n\t\tbutton.setFreeze(true);\n\t\tadd(button);\n\t}\n}");
    }

    @Test
    public void test_customizer_chageProperties_Cancel() throws Exception {
        this.prepare_customizer_changeProperties();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tbutton.setTitle('Old title');\n\t\tadd(button);\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final Object buttonObject = button.getObject();
        CustomizeTest.assertEquals((Object)"Old title", (Object)ScriptUtils.evaluate((String)"getTitle()", (Object)buttonObject));
        CustomizeTest.assertEquals((Object)false, (Object)ScriptUtils.evaluate((String)"isFreeze()", (Object)buttonObject));
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                action.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Customize").bot();
                Object customizer = ReflectionUtils.getFieldObject((Object)buttonObject, (String)"customizer");
                ReflectionUtils.invokeMethod((Object)customizer, (String)"doBeanChanges()", (Object[])new Object[0]);
                shell.button("Cancel").click();
            }
        });
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tbutton.setTitle('Old title');\n\t\tadd(button);\n\t}\n}");
        CustomizeTest.assertEquals((Object)"Old title", (Object)ScriptUtils.evaluate((String)"getTitle()", (Object)buttonObject));
        CustomizeTest.assertEquals((Object)false, (Object)ScriptUtils.evaluate((String)"isFreeze()", (Object)buttonObject));
    }

    private void prepare_customizer_changeProperties() throws Exception {
        CustomizeTest.setFileContentSrc("test/MyCustomizer.java", this.getTestSource("import java.beans.Customizer;\nimport java.beans.PropertyChangeListener;\npublic class MyCustomizer extends JPanel implements Customizer {\n\tprivate MyButton button;\n\t\tpublic void setObject(Object bean) {\n\t\t\tbutton = (MyButton) bean;\n\t\t\tbutton.customizer = this;\n\t\t}\n\t\tpublic void doBeanChanges() {\n\t\t\tbutton.setTitle('New title');\n\t\t\tfirePropertyChange('title', null, 'New title');\n\t\t\tbutton.setFreeze(true);\n\t\tfirePropertyChange('freeze', null, true);\n\t}\n}"));
        CustomizeTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {\n\tpublic Object customizer;\n\tprivate String m_title;\n\tpublic String getTitle() {\n\t\treturn m_title;\n\t}\n\tpublic void setTitle(String title) {\n\t\tm_title = title;\n\t}\n\tprivate boolean m_freeze;\n\tpublic boolean isFreeze() {\n\t\treturn m_freeze;\n\t}\n\tpublic void setFreeze(boolean freeze) {\n\t\tm_freeze = freeze;\n\t}\n}"));
        CustomizeTest.setFileContentSrc("test/MyButtonBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;\nimport java.beans.BeanDescriptor;\nimport java.beans.Introspector;\nimport java.beans.SimpleBeanInfo;\nimport java.beans.PropertyDescriptor;\npublic class MyButtonBeanInfo extends SimpleBeanInfo {\n\tprivate BeanDescriptor m_descriptor;\n\tprivate PropertyDescriptor[] m_properties;\n\tpublic MyButtonBeanInfo() {\n\t\tm_descriptor = new BeanDescriptor(MyButton.class, MyCustomizer.class);\n\t\ttry {\n\t\t\tm_properties = new PropertyDescriptor[2];\n\t\t\tm_properties[0] = new PropertyDescriptor(\"title\", MyButton.class, \"getTitle\", \"setTitle\");\n\t\t\tm_properties[1] = new PropertyDescriptor(\"freeze\", MyButton.class, \"isFreeze\", \"setFreeze\");\n\t\t} catch(Throwable e) {\n\t\t}\n\t}\n\tpublic BeanDescriptor getBeanDescriptor() {\n\t\treturn m_descriptor;\n\t}\n\tpublic PropertyDescriptor[] getPropertyDescriptors() {\n\t\treturn m_properties;\n\t}\n\tpublic BeanInfo[] getAdditionalBeanInfo() {\n\t\ttry {\n\t\t\tBeanInfo info = Introspector.getBeanInfo(JButton.class);\n\t\t\treturn new BeanInfo[] {info};\n\t\t} catch (Throwable e) {\n\t\t}\n\t\treturn null;\n\t}\n}"));
        CustomizeTest.waitForAutoBuild();
    }

    @Test
    public void test_customizer_EXPLICIT_PROPERTY_CHANGE() throws Exception {
        CustomizeTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {\n\tprivate String m_title;\n\tpublic String getTitle() {\n\t\treturn m_title;\n\t}\n\tpublic void setTitle(String title) {\n\t\tm_title = title;\n\t}\n\tprivate boolean m_freeze;\n\tpublic boolean isFreeze() {\n\t\treturn m_freeze;\n\t}\n\tpublic void setFreeze(boolean freeze) {\n\t\tm_freeze = freeze;\n\t}\n\tpublic Object customizer;\n}"));
        CustomizeTest.setFileContentSrc("test/MyCustomizer.java", this.getTestSource("import java.beans.Customizer;\nimport java.beans.PropertyChangeListener;\npublic class MyCustomizer extends JPanel implements Customizer {\n\tpublic void setObject(Object bean) {\n\t\tMyButton button = (MyButton)bean;\n\t\tbutton.customizer = this;\n\t}\n\n\t@Override\n\t// Make public for reflective access\n\tpublic void firePropertyChange(String propertyName, Object oldValue, Object newValue) {\n\t\tsuper.firePropertyChange(propertyName, oldValue, newValue);\n\t}\n}"));
        CustomizeTest.setFileContentSrc("test/MyButtonBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;\nimport java.beans.BeanDescriptor;\nimport java.beans.Introspector;\nimport java.beans.SimpleBeanInfo;\nimport java.beans.PropertyDescriptor;\npublic class MyButtonBeanInfo extends SimpleBeanInfo {\n\tprivate BeanDescriptor m_descriptor;\n\tprivate PropertyDescriptor[] m_properties;\n\tpublic MyButtonBeanInfo() {\n\t\tm_descriptor = new BeanDescriptor(MyButton.class, MyCustomizer.class);\n\t\tm_descriptor.setValue(\"EXPLICIT_PROPERTY_CHANGE\", Boolean.TRUE);\n\t\ttry {\n\t\t\tm_properties = new PropertyDescriptor[2];\n\t\t\tm_properties[0] = new PropertyDescriptor(\"title\", MyButton.class, \"getTitle\", \"setTitle\");\n\t\t\tm_properties[1] = new PropertyDescriptor(\"freeze\", MyButton.class, \"isFreeze\", \"setFreeze\");\n\t\t} catch(Throwable e) {\n\t\t}\n\t}\n\tpublic BeanDescriptor getBeanDescriptor() {\n\t\treturn m_descriptor;\n\t}\n\tpublic PropertyDescriptor[] getPropertyDescriptors() {\n\t\treturn m_properties;\n\t}\n\tpublic BeanInfo[] getAdditionalBeanInfo() {\n\t\ttry {\n\t\t\tBeanInfo info = Introspector.getBeanInfo(JButton.class);\n\t\t\treturn new BeanInfo[] {info};\n\t\t\t} catch (Throwable e) {\n\t\t}\n\t\treturn null;\n\t}\n}"));
        CustomizeTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tadd(button);\n\t}\n}");
        panel.refresh();
        final ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() {
                action.run();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) throws Exception {
                SWTBot shell = bot.shell("Customize").bot();
                Object object = button.getObject();
                ReflectionUtils.invokeMethod((Object)object, (String)"setTitle(java.lang.String)", (Object[])new Object[]{"test"});
                ReflectionUtils.invokeMethod((Object)object, (String)"setFreeze(boolean)", (Object[])new Object[]{true});
                Object customizer = ReflectionUtils.getFieldObject((Object)object, (String)"customizer");
                ReflectionUtils.invokeMethod((Object)customizer, (String)"firePropertyChange(java.lang.String,java.lang.Object,java.lang.Object)", (Object[])new Object[]{"title", null, "test"});
                shell.button("OK").click();
            }
        });
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tMyButton button = new MyButton();\n\t\tbutton.setTitle(\"test\");\n\t\tadd(button);\n\t}\n}");
    }

    @Test
    public void test_useInheritedCustomizer() throws Exception {
        CustomizeTest.setFileContentSrc("test/BeanA.java", this.getTestSource("public class BeanA extends JButton {\n\tprivate static final long serialVersionUID = 0L;\n}"));
        CustomizeTest.setFileContentSrc("test/BeanABeanInfo.java", this.getTestSource("import java.beans.*;\npublic class BeanABeanInfo extends SimpleBeanInfo {\n\tprivate final static Class<?> beanClass = BeanA.class;\n\tprivate final static Class<?> customizerClass = BeanCustomizer.class;\n\t@Override\n\tpublic BeanDescriptor getBeanDescriptor() {\n\t\treturn new BeanDescriptor(beanClass, customizerClass);\n\t}\n}"));
        CustomizeTest.setFileContentSrc("test/BeanCustomizer.java", this.getTestSource("import java.beans.*;\npublic class BeanCustomizer extends JPanel implements Customizer {\n\tprivate static final long serialVersionUID = 0L;\n\tpublic void setObject(Object bean) {\n\t}\n}"));
        CustomizeTest.setFileContentSrc("test/BeanB.java", this.getTestSource("public class BeanB extends BeanA {\n\tprivate static final long serialVersionUID = 0L;\n}"));
        CustomizeTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tBeanB bean = new BeanB();\n\t\tadd(bean);\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
    }
}

