/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.MigLayout;

import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.Before;

public abstract class AbstractMigLayoutTest
extends AbstractLayoutTest {
    protected boolean m_includeMigImports = true;

    @Override
    protected void configureNewProject() throws Exception {
        super.configureNewProject();
        AbstractMigLayoutTest.do_configureNewProject();
    }

    static void do_configureNewProject() throws Exception {
        m_testProject.addPlugin("com.miglayout.core");
        m_testProject.addPlugin("com.miglayout.swing");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AbstractMigLayoutTest.setFileContentSrc("test/IConstants.java", AbstractMigLayoutTest.getSourceDQ("package test;", "public interface IConstants {", "  String C_1 = '1';", "  String C_2 = '2';", "  String C_3 = '3';", "  String C_4 = '4';", "  String C_5 = '5';", "  String C_6 = '6';", "  String C_7 = '7';", "  String C_8 = '8';", "}"));
        AbstractMigLayoutTest.waitForAutoBuild();
    }

    @Override
    public String getTestSource(String ... lines) {
        if (this.m_includeMigImports) {
            try {
                if (m_javaProject.findType("net.miginfocom.swing.MigLayout") != null) {
                    lines = CodeUtils.join((String[])new String[]{"import net.miginfocom.layout.*;", "import net.miginfocom.swing.*;"}, (String[])lines);
                }
            }
            catch (Throwable e) {
                throw ReflectionUtils.propagate((Throwable)e);
            }
        }
        return super.getTestSource(lines);
    }

    protected static void assertCellBounds(ComponentInfo component, int expectedX, int expectedY, int expectedWidth, int expectedHeight) {
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)component);
        AbstractMigLayoutTest.assertEquals((long)expectedX, (long)constraints.getX());
        AbstractMigLayoutTest.assertEquals((long)expectedY, (long)constraints.getY());
        AbstractMigLayoutTest.assertEquals((long)expectedWidth, (long)constraints.getWidth());
        AbstractMigLayoutTest.assertEquals((long)expectedHeight, (long)constraints.getHeight());
    }
}

