/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.draw2d;

import java.util.Arrays;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.wb.tests.gef.TestLogger;

public class DebugGraphics
extends SWTGraphics {
    private final TestLogger m_logger;

    public DebugGraphics(GC gc, TestLogger logger) {
        super(gc);
        this.m_logger = logger;
    }

    public void clipRect(Rectangle rectangle) {
        this.m_logger.log("clipRect(" + String.valueOf(rectangle) + ")");
        super.clipRect(rectangle);
    }

    public void drawArc(int x, int y, int width, int height, int offset, int length) {
        this.m_logger.log("drawArc(" + x + ", " + y + ", " + width + ", " + height + ", " + offset + ", " + length + ")");
        super.drawArc(x, y, width, height, offset, length);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.m_logger.log("drawFocus(" + x + ", " + y + ", " + w + ", " + h + ")");
        super.drawFocus(x, y, w, h);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        ImageData data = srcImage.getImageData();
        this.m_logger.log("drawImage(" + data.width + "x" + data.height + "x" + data.depth + ", " + x1 + ", " + y1 + ", " + w1 + ", " + h1 + ", " + x2 + ", " + y2 + ", " + w2 + ", " + h2 + ")");
        super.drawImage(srcImage, x1, y1, w1, h1, x2, y2, w2, h2);
    }

    public void drawImage(Image srcImage, int x, int y) {
        ImageData data = srcImage.getImageData();
        this.m_logger.log("drawImage(" + data.width + "x" + data.height + "x" + data.depth + ", " + x + ", " + y + ")");
        super.drawImage(srcImage, x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.m_logger.log("drawLine(" + x1 + ", " + y1 + ", " + x2 + ", " + y2);
        super.drawLine(x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.m_logger.log("drawOval(" + x + ", " + y + ", " + width + ", " + height);
        super.drawOval(x, y, width, height);
    }

    public void drawPolygon(PointList points) {
        this.m_logger.log("drawPolygon(" + Arrays.toString(points.getCopy().toIntArray()) + ")");
        super.drawPolygon(points);
    }

    public void drawPolyline(PointList points) {
        this.m_logger.log("drawPolyline(" + Arrays.toString(points.getCopy().toIntArray()) + ")");
        super.drawPolyline(points);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.m_logger.log("drawRectangle(" + x + ", " + y + ", " + width + ", " + height + ")");
        super.drawRectangle(x, y, width, height);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.m_logger.log("drawRoundRectangle(" + String.valueOf(r) + ", " + arcWidth + ", " + arcHeight + ")");
        super.drawRoundRectangle(r, arcWidth, arcHeight);
    }

    public void drawString(String s, int x, int y) {
        this.m_logger.log("drawString(|" + s + "|, " + x + ", " + y + ")");
        super.drawString(s, x, y);
    }

    public void drawText(String s, int x, int y) {
        this.m_logger.log("drawText(|" + s + "|, " + x + ", " + y + ")");
        super.drawText(s, x, y);
    }

    public void fillArc(int x, int y, int width, int height, int offset, int length) {
        this.m_logger.log("fillArc(" + x + ", " + y + ", " + width + ", " + height + ", " + offset + ", " + length + ")");
        super.fillArc(x, y, width, height, offset, length);
    }

    public void fillGradient(int x, int y, int width, int height, boolean vertical) {
        this.m_logger.log("fillGradient(" + x + ", " + y + ", " + width + ", " + height + ", " + vertical + ")");
        super.fillGradient(x, y, width, height, vertical);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.m_logger.log("fillOval(" + x + ", " + y + ", " + w + ", " + h + ")");
        super.fillOval(x, y, w, h);
    }

    public void fillPolygon(PointList points) {
        this.m_logger.log("fillPolygon(" + Arrays.toString(points.getCopy().toIntArray()) + ")");
        super.fillPolygon(points);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.m_logger.log("fillRectangle(" + x + ", " + y + ", " + width + ", " + height + ")");
        super.fillRectangle(x, y, width, height);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.m_logger.log("fillRoundRectangle(" + String.valueOf(r) + ", " + arcWidth + ", " + arcHeight + ")");
        super.fillRoundRectangle(r, arcWidth, arcHeight);
    }

    public void fillString(String s, int x, int y) {
        this.m_logger.log("fillString(|" + s + "|, " + x + ", " + y + ")");
        super.fillString(s, x, y);
    }

    public void fillText(String s, int x, int y) {
        this.m_logger.log("fillText(|" + s + "|, " + x + ", " + y + ")");
        super.fillText(s, x, y);
    }

    public void popState() {
        this.m_logger.log("popState()");
        super.popState();
    }

    public void pushState() {
        this.m_logger.log("pushState()");
        super.pushState();
    }

    public void restoreState() {
        this.m_logger.log("restoreState()");
        super.restoreState();
    }

    public void setBackgroundColor(Color color) {
        this.m_logger.log("setBackgroundColor(" + String.valueOf(color) + ")");
        super.setBackgroundColor(color);
    }

    public void setFont(Font f) {
        this.m_logger.log("setFont(" + Arrays.toString(f.getFontData()) + ")");
        super.setFont(f);
    }

    public void setForegroundColor(Color color) {
        this.m_logger.log("setForegroundColor(" + String.valueOf(color) + ")");
        super.setForegroundColor(color);
    }

    public void setLineStyle(int style) {
        this.m_logger.log("setLineStyle(" + style + ")");
        super.setLineStyle(style);
    }

    public void setLineWidth(int width) {
        this.m_logger.log("setLineWidth(" + width + ")");
        super.setLineWidth(width);
    }

    public void setXORMode(boolean b) {
        this.m_logger.log("setXORMode(" + b + ")");
        super.setXORMode(b);
    }

    public void translate(int dx, int dy) {
        this.m_logger.log("translate(" + dx + ", " + dy + ")");
        super.translate(dx, dy);
    }
}

