/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding.ui;

import java.beans.PropertyChangeEvent;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingContext;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingHelper;
import org.eclipse.xwt.tools.ui.designer.databinding.DataContext;
import org.eclipse.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.xwt.tools.ui.designer.databinding.Observable;
import org.eclipse.xwt.tools.ui.designer.databinding.ObservableUtil;
import org.eclipse.xwt.tools.ui.designer.databinding.Property;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.ObserveGroup;
import org.eclipse.xwt.tools.ui.designer.parts.ViewerEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.WidgetEditPart;

public class ObserveModelGroup
extends ObserveGroup {
    public ObserveModelGroup(BindingContext bindingContext, EditPart rootEditPart) {
        super(bindingContext, rootEditPart);
    }

    protected String computeMessage() {
        String message = "Model:";
        BindingContext bc = this.getBindingContext();
        IObservable model = bc.getModel();
        Property modelProperty = bc.getModelProperty();
        if (model != null) {
            message = String.valueOf(message) + model.getDisplayName();
            if (modelProperty != null) {
                message = String.valueOf(message) + "." + modelProperty;
            }
        } else {
            message = String.valueOf(message) + "<empty>";
        }
        return message;
    }

    protected void handleSelection(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        BindingContext bindingContext = this.getBindingContext();
        if (element == null) {
            bindingContext.setModel(null);
            bindingContext.setModelProperty(null);
        } else if (element instanceof IObservable) {
            bindingContext.setModel((IObservable)element);
            bindingContext.setModelProperty(null);
        } else if (element instanceof Property) {
            bindingContext.setModelProperty((Property)element);
        }
    }

    protected void selectAndReveal(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if ("model".equals(evt.getPropertyName())) {
            TreeViewer treeViewer = this.observableList.getTreeViewer();
            treeViewer.setSelection((ISelection)this.createSelection(newValue), true);
        } else if ("modelProperty".equals(evt.getPropertyName())) {
            this.propertiesTree.setSelection((ISelection)this.createSelection(newValue), true);
        }
    }

    protected IObservable[] computeObservables(EditPart rootEditPart) {
        if (rootEditPart == null) {
            return new IObservable[0];
        }
        Widget root = null;
        if (rootEditPart instanceof WidgetEditPart) {
            root = ((WidgetEditPart)rootEditPart).getWidget();
        } else if (rootEditPart instanceof ViewerEditPart) {
            root = ((ViewerEditPart)rootEditPart).getViewer();
        }
        if (root == null) {
            return new IObservable[0];
        }
        DataContext dataContext = BindingHelper.getDataContext(root);
        Observable widgets = ObservableUtil.getObservable(root);
        if (dataContext == null) {
            return new IObservable[]{widgets};
        }
        IObservable[] models = new IObservable[]{widgets, ObservableUtil.getObservable(dataContext)};
        return models;
    }
}

