/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.w3c.dom.Node;

public abstract class AbstractEventHandlerDialog {
    protected Operation operation = Operation.Cancel;
    protected String inputHandler = "";
    protected String oldHandler;
    protected String attrValue;
    protected String[] handlers;
    protected StructuredTextViewer textViewer;
    protected int count;

    public AbstractEventHandlerDialog(StructuredTextViewer textViewer, String oldHandler, String attrValue, String[] handlers) {
        this.textViewer = textViewer;
        this.oldHandler = oldHandler;
        this.attrValue = attrValue;
        this.handlers = handlers;
    }

    public void run(Shell parentShell, String title, Point position) {
        Shell shell = new Shell(parentShell, 0);
        shell.setText(title);
        this.createContents(shell);
        shell.setLocation(position);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group((Composite)shell, 16384);
        group.setText("Handler Operations");
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        final Button rbt1 = new Button((Composite)group, 16);
        rbt1.setText("New Handler");
        rbt1.setSelection(true);
        GridData gridData1 = new GridData(768);
        gridData1.horizontalSpan = 2;
        rbt1.setLayoutData((Object)gridData1);
        RBSelectionAdapter rbSelectionAdapter1 = new RBSelectionAdapter(1);
        rbt1.addSelectionListener((SelectionListener)rbSelectionAdapter1);
        rbt1.setToolTipText("New Handler");
        rbt1.setForeground(rbt1.getDisplay().getSystemColor(10));
        final Button rbt2 = new Button((Composite)group, 16);
        rbt2.setText("Rename Handler");
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        rbt2.setLayoutData((Object)gridData2);
        RBSelectionAdapter rbSelectionAdapter2 = new RBSelectionAdapter(2);
        rbt2.addSelectionListener((SelectionListener)rbSelectionAdapter2);
        rbt2.setToolTipText("Rename Handler");
        rbt2.setForeground(rbt2.getDisplay().getSystemColor(10));
        rbt2.setEnabled(this.oldHandler != null && this.oldHandler.length() > 0);
        final Button rbt3 = new Button((Composite)group, 16);
        rbt3.setText("Select Existing Handler");
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 2;
        rbt3.setLayoutData((Object)gridData3);
        RBSelectionAdapter rbSelectionAdapter3 = new RBSelectionAdapter(3);
        rbt3.addSelectionListener((SelectionListener)rbSelectionAdapter3);
        rbt3.setToolTipText("Select an existing handler");
        rbt3.setForeground(rbt3.getDisplay().getSystemColor(10));
        rbt3.setEnabled(this.handlers != null && this.handlers.length > 0);
        Label hNameLabel = new Label((Composite)shell, 16384);
        hNameLabel.setText("Handler Name");
        final Text nameText = new Text((Composite)shell, 2048);
        nameText.setText(this.attrValue);
        GridData gridData4 = new GridData();
        gridData4.widthHint = 100;
        nameText.setLayoutData((Object)gridData4);
        rbSelectionAdapter1.setText(nameText);
        rbSelectionAdapter2.setText(nameText);
        rbSelectionAdapter3.setText(nameText);
        Label selectHandlerLabel = new Label((Composite)shell, 16384);
        selectHandlerLabel.setText("Select handler");
        GridData gridData5 = new GridData(768);
        selectHandlerLabel.setLayoutData((Object)gridData5);
        final Combo handlersCombo = new Combo((Composite)shell, 12);
        if (this.handlers != null && this.handlers.length != 0) {
            handlersCombo.setItems(this.handlers);
            handlersCombo.setText(this.handlers[0]);
        }
        handlersCombo.setEnabled(false);
        GridData gridData6 = new GridData(768);
        gridData6.horizontalAlignment = 16384;
        handlersCombo.setLayoutData((Object)gridData6);
        rbSelectionAdapter1.setCombo(handlersCombo);
        rbSelectionAdapter2.setCombo(handlersCombo);
        rbSelectionAdapter3.setCombo(handlersCombo);
        Button okButton = new Button((Composite)shell, 13);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean exists = false;
                if (!rbt3.getSelection()) {
                    if (nameText.getText().trim().equals("")) {
                        MessageDialog.openInformation((Shell)shell, (String)"Dialog", (String)"Handler Name is null");
                        nameText.forceFocus();
                        return;
                    }
                    exists = this.handlerExists(nameText.getText(), AbstractEventHandlerDialog.this.handlers);
                    if (exists) {
                        int length = nameText.getText().length();
                        nameText.setSelection(0, length);
                        nameText.forceFocus();
                        return;
                    }
                }
                if (rbt1.getSelection()) {
                    AbstractEventHandlerDialog.this.operation = Operation.New;
                    AbstractEventHandlerDialog.this.inputHandler = nameText.getText();
                } else if (rbt2.getSelection()) {
                    String message;
                    boolean confirm;
                    AbstractEventHandlerDialog.this.inputHandler = nameText.getText();
                    Node rootNode = (Node)ContentAssistUtils.getNodeAt((ITextViewer)AbstractEventHandlerDialog.this.textViewer, (int)0);
                    AbstractEventHandlerDialog.this.count = 0;
                    boolean usedByOther = AbstractEventHandlerDialog.this.usedByOther(rootNode, AbstractEventHandlerDialog.this.oldHandler);
                    if (usedByOther && !(confirm = MessageDialog.openConfirm((Shell)shell, (String)"Dialog", (String)(message = NLS.bind((String)"Refactor", (Object)AbstractEventHandlerDialog.this.oldHandler))))) {
                        int length = nameText.getText().length();
                        nameText.setSelection(0, length);
                        nameText.forceFocus();
                        return;
                    }
                    AbstractEventHandlerDialog.this.operation = Operation.Rename;
                } else if (rbt3.getSelection()) {
                    AbstractEventHandlerDialog.this.operation = Operation.Select;
                    AbstractEventHandlerDialog.this.inputHandler = handlersCombo.getText();
                }
                if (!exists) {
                    shell.dispose();
                }
            }

            private boolean handlerExists(String handlerName, String[] handlers) {
                int i = 0;
                while (i < handlers.length) {
                    if (handlerName != null && handlerName.equals(handlers[i])) {
                        MessageDialog.openInformation((Shell)shell, (String)"Dialog", (String)"Handler is existed.");
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
        okButton.setText("OK");
        GridData okData = new GridData();
        okData.horizontalAlignment = 2;
        okButton.setLayoutData((Object)okData);
        Button cancelButton = new Button((Composite)shell, 8);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.dispose();
            }
        });
        cancelButton.setText("Cancel");
        GridData cancelData = new GridData();
        cancelData.horizontalAlignment = 2;
        cancelData.grabExcessHorizontalSpace = true;
        shell.setDefaultButton(okButton);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getInputHandler() {
        return this.inputHandler;
    }

    protected abstract boolean usedByOther(Node var1, String var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        Cancel,
        New,
        Select,
        Rename;

    }

    private static class RBSelectionAdapter
    extends SelectionAdapter {
        private Text text;
        private Combo combo;
        private int number;

        protected RBSelectionAdapter(int number) {
            this.number = number;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.number == 3) {
                this.text.setEnabled(false);
                this.combo.setEnabled(true);
            } else {
                this.text.setEnabled(true);
                this.combo.setEnabled(false);
            }
        }

        protected void setText(Text text) {
            this.text = text;
        }

        protected void setCombo(Combo combo) {
            this.combo = combo;
        }
    }
}

