/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xwt.tools.ui.designer.core.DesignerPlugin;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.osgi.framework.Bundle;

public class ModelCacheUtility {
    protected static final IPath VISUAL_EDITOR_MODEL_CACHE_ROOT = DesignerPlugin.VE_CACHE_ROOT_NAME.append("emfmodel");
    private static final Map XML_CACHE_SAVE_OPTIONS = new HashMap(4);

    static {
        XML_CACHE_SAVE_OPTIONS.put("ENCODING", "UTF-8");
        XML_CACHE_SAVE_OPTIONS.put("PROCESS_DANGLING_HREF", "RECORD");
        XML_CACHE_SAVE_OPTIONS.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
    }

    protected static IPath getEMFModelCacheDestination(IProject p) {
        DesignerPlugin plugin = DesignerPlugin.getDefault();
        Bundle bundle = plugin.getBundle();
        String symbolicName = bundle.getSymbolicName();
        IPath workingLocation = p.getWorkingLocation(symbolicName);
        return workingLocation.append(VISUAL_EDITOR_MODEL_CACHE_ROOT);
    }

    public static IPath getCacheDirectory(IFile f) {
        IProject p = f.getProject();
        IPath projectCachePath = ModelCacheUtility.getEMFModelCacheDestination(p);
        File dir = projectCachePath.toFile();
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                return projectCachePath;
            }
            return null;
        }
        return projectCachePath;
    }

    protected static IPath getCachedPath(IFile f) {
        IPath savedPath = ModelCacheUtility.getCacheDirectory(f).append(f.getProjectRelativePath());
        return savedPath.removeFileExtension().addFileExtension("xmi");
    }

    public static URI getCacheURI(IFile f) {
        return URI.createFileURI((String)ModelCacheUtility.getCachedPath(f).toString());
    }

    public static XamlDocument doLoadFromCache(IFile input, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.subTask("Loading from cache: " + input.getName());
        if (ModelCacheUtility.isValidCache(input)) {
            monitor.worked(1);
            try {
                URI uri = ModelCacheUtility.getCacheURI(input);
                ResourceSetImpl rs = new ResourceSetImpl();
                Resource resource = rs.getResource(uri, true);
                XamlDocument xamlDocument = (XamlDocument)resource.getContents().get(0);
                return xamlDocument;
            }
            catch (Exception e) {
                ModelCacheUtility.removeCache(input);
            }
            finally {
                monitor.worked(1);
            }
        }
        return null;
    }

    public static void doSaveCache(XamlDocument document, IFile input, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Save model to cache", 4);
        monitor.worked(1);
        if (document != null) {
            try {
                monitor.worked(1);
                Resource resource = document.eResource();
                URI cacheURI = ModelCacheUtility.getCacheURI(input);
                if (resource == null) {
                    ResourceSetImpl rs = new ResourceSetImpl();
                    resource = rs.createResource(cacheURI);
                    resource.getContents().add((Object)document);
                }
                if (resource.getURI().equals(cacheURI)) {
                    monitor.worked(1);
                    resource.save(XML_CACHE_SAVE_OPTIONS);
                } else {
                    File f = ModelCacheUtility.getCachedPath(input).toFile();
                    monitor.worked(1);
                    monitor.subTask("Save model to cache" + f.getName());
                    FileOutputStream os = new FileOutputStream(f);
                    resource.save((OutputStream)os, XML_CACHE_SAVE_OPTIONS);
                    os.close();
                }
            }
            catch (RuntimeException resource) {
            }
            catch (IOException e) {
                ModelCacheUtility.removeCache(input);
            }
        }
        monitor.done();
    }

    public static void removeCache(IFile file) {
        try {
            if (file != null) {
                ModelCacheUtility.getCachedPath(file).toFile().delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isValidCache(IFile f) {
        File dest = ModelCacheUtility.getCachedPath(f).toFile();
        return dest.canRead() && dest.lastModified() > f.getLocalTimeStamp();
    }
}

