/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.tools.ui.designer.core.figures.ContentPaneFigure;
import org.eclipse.xwt.tools.ui.designer.core.visuals.IVisualInfo;
import org.eclipse.xwt.tools.ui.designer.core.visuals.swt.CompositeInfo;
import org.eclipse.xwt.tools.ui.designer.editor.sash.SashFormChildResizableEditPolicy;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.xwt.tools.ui.designer.parts.ControlEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.SashFormEditPart;
import org.eclipse.xwt.tools.ui.designer.policies.layout.ILayoutEditPolicy;
import org.eclipse.xwt.tools.ui.designer.policies.layout.LayoutEditPolicyFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class CompositeEditPart
extends ControlEditPart {
    static final int WIDTH = 10;
    private ILayoutEditPolicy layoutEditPolicy;

    public CompositeEditPart(Composite composite, XamlNode model) {
        super((Control)composite, model);
        this.setUseBorder(true);
    }

    protected IFigure createFigure() {
        ContentPaneFigure cf = (ContentPaneFigure)super.createFigure();
        cf.getContentPane().setLayoutManager((LayoutManager)new XYLayout());
        return cf;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.layoutEditPolicy = LayoutEditPolicyFactory.getLayoutEditPolicy(this);
        this.installEditPolicy("LayoutEditPolicy", this.layoutEditPolicy);
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    public void refresh() {
        super.refresh();
        ILayoutEditPolicy policy = LayoutEditPolicyFactory.getLayoutEditPolicy(this);
        if (this.layoutEditPolicy != null && this.layoutEditPolicy.getType() != policy.getType()) {
            this.removeEditPolicy("LayoutEditPolicy");
            this.layoutEditPolicy = policy;
            this.installEditPolicy("LayoutEditPolicy", this.layoutEditPolicy);
        }
        if (this.layoutEditPolicy != null) {
            this.layoutEditPolicy.refresh();
        }
    }

    public Layout getLayout() {
        Widget widget = this.getWidget();
        if (widget == null || widget.isDisposed() || !(widget instanceof Composite)) {
            return null;
        }
        return ((Composite)widget).getLayout();
    }

    public XamlElement getLayoutModel() {
        XamlElement model = (XamlElement)this.getModel();
        XamlAttribute attribute = model.getAttribute("layout");
        if (attribute == null) {
            return null;
        }
        EList childNodes = attribute.getChildNodes();
        if (childNodes.size() == 1) {
            return (XamlElement)childNodes.get(0);
        }
        return null;
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class && ((Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")).booleanValue()) {
            if (this.layoutEditPolicy != null && this.layoutEditPolicy.getType() == LayoutType.NullLayout) {
                return new SnapToGeometry((GraphicalEditPart)this);
            }
        } else if (key == ILayoutEditPolicy.class) {
            return this.layoutEditPolicy;
        }
        return super.getAdapter(key);
    }

    public IVisualInfo createVisualInfo() {
        return new CompositeInfo((Object)((Composite)this.getWidget()), this.isRoot());
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart editPart;
        if (this.getParent() instanceof SashFormEditPart && (editPart = SashFormChildResizableEditPolicy.getTargetEditPart(request, (GraphicalEditPart)this)) != null) {
            return editPart;
        }
        return super.getTargetEditPart(request);
    }
}

