/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.xwt.ui.editor.dnd.DnDAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWTDropTargetListener
implements DropTargetListener {
    private List<DnDAdapter> dndAdapters = new ArrayList<DnDAdapter>();
    private DnDAdapter acceptAdapter;

    public void dragOver(DropTargetEvent event) {
        this.updateAcceptAdapter();
        if (this.acceptAdapter != null) {
            this.acceptAdapter.dragOver(event);
        }
    }

    private void updateAcceptAdapter() {
        for (DnDAdapter dnd : this.dndAdapters) {
            if (!dnd.isAccept()) continue;
            this.acceptAdapter = dnd;
            break;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (this.acceptAdapter != null) {
            this.acceptAdapter.dropAccept(event);
        }
    }

    public void drop(DropTargetEvent event) {
        if (this.acceptAdapter != null) {
            this.acceptAdapter.drop(event);
        }
    }

    public void dragEnter(DropTargetEvent event) {
        this.updateAcceptAdapter();
        if (this.acceptAdapter != null) {
            this.acceptAdapter.dragEnter(event);
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.updateAcceptAdapter();
        if (this.acceptAdapter != null) {
            this.acceptAdapter.dragOperationChanged(event);
        }
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.acceptAdapter != null) {
            this.acceptAdapter.dragLeave(event);
        }
    }

    public void addDnDAdapter(DnDAdapter adapter) {
        this.dndAdapters.add(adapter);
    }

    public void setDndAdapters(List<DnDAdapter> dndAdapters) {
        this.dndAdapters = dndAdapters;
    }

    public List<DnDAdapter> getDndAdapters() {
        return this.dndAdapters;
    }
}

