/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.editor.dnd;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.xwt.ui.editor.XWTEditor;
import org.eclipse.xwt.ui.editor.dnd.DnDAdapterImpl;
import org.eclipse.xwt.vex.VEXTextEditorHelper;
import org.eclipse.xwt.vex.toolpalette.ContextType;
import org.eclipse.xwt.vex.toolpalette.Entry;

public class PaletteDnDAdapter
extends DnDAdapterImpl {
    private Map<String, String> name2content = new HashMap<String, String>();
    private Entry entry;

    public PaletteDnDAdapter(XWTEditor editor) {
        super(editor);
    }

    protected Template createTemplate(Object selection) {
        return new Template(this.entry.getName(), "", this.getContextType().getName(), this.entry.getContent(), true);
    }

    public ContextType getContextType() {
        return this.entry.getContext();
    }

    public String getScope() {
        return this.entry.getScope();
    }

    public void dropAccept(DropTargetEvent event) {
        if (this.isAccept()) {
            this.updateLayoutEntry(this.entry, event.x, event.y);
            this.updateLayoutDataEntry(this.entry, event.x, event.y);
        }
    }

    protected void updateLayoutEntry(Entry entry, int x, int y) {
        StructuredTextEditor textEditor = this.getEditor().getTextEditor();
        StructuredTextViewer textViewer = textEditor.getTextViewer();
        int cursor = VEXTextEditorHelper.getOffsetAtPoint((ITextViewer)textViewer, (Point)new Point(x, y));
        Object node = VEXTextEditorHelper.getNode((ITextViewer)textViewer, (int)cursor);
        while (node.getNodeType() == 3) {
            node = node.getParentNode();
        }
        String nodeName = node.getNodeName();
        String name = entry.getName();
        if (nodeName != null && name.toLowerCase().endsWith("layout")) {
            String content = this.name2content.get(name);
            if (content == null) {
                content = entry.getContent();
                this.name2content.put(name, content);
            }
            String source = "Composite";
            StringTokenizer stk = new StringTokenizer(content, "<>");
            while (stk.hasMoreTokens()) {
                String nextToken = stk.nextToken();
                if (!nextToken.endsWith(".layout")) continue;
                source = nextToken.substring(0, nextToken.lastIndexOf("."));
                break;
            }
            String newContent = content.replace(source, nodeName);
            entry.setContent(newContent);
        }
    }

    protected void updateLayoutDataEntry(Entry entry, int x, int y) {
        StructuredTextEditor textEditor = this.getEditor().getTextEditor();
        StructuredTextViewer textViewer = textEditor.getTextViewer();
        int cursor = VEXTextEditorHelper.getOffsetAtPoint((ITextViewer)textViewer, (Point)new Point(x, y));
        Object node = VEXTextEditorHelper.getNode((ITextViewer)textViewer, (int)cursor);
        while (node.getNodeType() == 3) {
            node = node.getParentNode();
        }
        String nodeName = node.getNodeName();
        String name = entry.getName();
        String tagName = null;
        if (nodeName != null && name.toLowerCase().endsWith("data")) {
            tagName = nodeName.indexOf(":") != -1 ? nodeName.substring(nodeName.lastIndexOf(":") + 1) : nodeName;
            String content = this.name2content.get(name);
            if (content == null) {
                content = entry.getContent();
                this.name2content.put(name, content);
            }
            String newContent = content.replace("Control", tagName);
            entry.setContent(newContent);
        }
    }

    public boolean isAccept(Object obj) {
        if (obj instanceof Entry) {
            this.entry = (Entry)obj;
            return true;
        }
        return false;
    }
}

