/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.document;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jface.text.IDocument;

public class DocumentReader
extends Reader {
    private IDocument fDocument = null;
    private int mark = 0;
    private int position = 0;

    public DocumentReader() {
    }

    public DocumentReader(IDocument document) {
        this(document, 0);
    }

    public DocumentReader(IDocument document, int initialPosition) {
        this.fDocument = document;
        this.position = initialPosition;
    }

    @Override
    public void close() throws IOException {
        this.fDocument = null;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.mark = this.position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        char[] readChars;
        block4: {
            if (this.fDocument == null) {
                return -1;
            }
            readChars = null;
            try {
                if (this.position < this.fDocument.getLength()) break block4;
                return -1;
            }
            catch (Exception e) {
                throw new IOException("Exception while reading from IDocument: " + e);
            }
        }
        readChars = this.position + len > this.fDocument.getLength() ? this.fDocument.get(this.position, this.fDocument.getLength() - this.position).toCharArray() : this.fDocument.get(this.position, len).toCharArray();
        System.arraycopy(readChars, 0, cbuf, off, readChars.length);
        this.position += readChars.length;
        return readChars.length;
    }

    @Override
    public void reset() throws IOException {
        this.position = this.mark;
    }

    public void reset(IDocument document, int initialPosition) {
        this.fDocument = document;
        this.position = initialPosition;
    }

    public void reset(int pos) throws IOException {
        this.position = pos;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.fDocument == null) {
            return 0L;
        }
        long skipped = n;
        if ((long)this.position + n > (long)this.fDocument.getLength()) {
            skipped = this.fDocument.getLength() - this.position;
            this.position = this.fDocument.getLength();
        } else {
            this.position = (int)((long)this.position + n);
        }
        return skipped;
    }
}

