/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.attrprofile;

import eu.unicore.samly2.attrprofile.ParsedAttribute;
import eu.unicore.samly2.attrprofile.SAMLAttributeProfile;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;

public class SAMLDefaultAttributeProfile
implements SAMLAttributeProfile {
    @Override
    public int isSupported(AttributeType xmlAttr) {
        XmlObject[] xmlVals = xmlAttr.getAttributeValueArray();
        if (xmlVals == null || xmlVals.length == 0) {
            return 0;
        }
        if (xmlVals[0] instanceof XmlAnySimpleType) {
            return 0;
        }
        return -1;
    }

    @Override
    public int isSupported(ParsedAttribute attr) {
        return 0;
    }

    @Override
    public ParsedAttribute map(AttributeType xmlAttr) {
        ParsedAttribute ret = new ParsedAttribute(xmlAttr.getName());
        String shortDesc = xmlAttr.getFriendlyName();
        ret.setDescription(shortDesc);
        XmlObject[] xmlVals = xmlAttr.getAttributeValueArray();
        if (xmlVals == null || xmlVals.length == 0) {
            ArrayList<String> empty = new ArrayList<String>(0);
            ret.setValues(empty, empty);
            return ret;
        }
        ArrayList<String> values = new ArrayList<String>(xmlVals.length);
        for (int i = 0; i < xmlVals.length; ++i) {
            values.add(this.mapAttrValue2APIAttr(xmlVals[i]));
        }
        ret.setValues(values, values);
        return ret;
    }

    private String mapAttrValue2APIAttr(XmlObject value) {
        if (value instanceof XmlAnySimpleType) {
            return ((XmlAnySimpleType)value).getStringValue();
        }
        throw new IllegalArgumentException("Unknown type of attribute value received for DefaultSAMLProfile, likely its a BUG, value " + value.xmlText());
    }

    @Override
    public AttributeType map(ParsedAttribute attr) throws SAMLValidationException {
        List<String> values;
        AttributeType ret = AttributeType.Factory.newInstance();
        ret.setName(attr.getName());
        if (attr.getDescription() != null) {
            ret.setFriendlyName(attr.getDescription());
        }
        if ((values = attr.getStringValues()).size() == 0) {
            return ret;
        }
        XmlString[] xmlVals = new XmlString[values.size()];
        int i = 0;
        for (String value : values) {
            xmlVals[i] = XmlString.Factory.newInstance();
            xmlVals[i].setStringValue(value);
            ++i;
        }
        ret.setAttributeValueArray((XmlObject[])xmlVals);
        return ret;
    }
}

