/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security;

import java.io.Serializable;

public class Role
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ROLE_ANONYMOUS = "anonymous";
    private String name;
    private String description;
    private String[] validRoles;

    public Role() {
        this.name = ROLE_ANONYMOUS;
        this.description = "No role information available";
    }

    public Role(String n, String d) {
        this.name = n;
        this.description = d;
        this.validRoles = new String[]{this.name};
    }

    public Role(String n, String d, String[] valid) {
        this.name = n;
        this.description = d;
        this.validRoles = valid;
        if (!this.isValid(n)) {
            throw new IllegalArgumentException("Selected role must be one of valid roles");
        }
    }

    public Role(String[] valid) {
        this.name = valid[0];
        this.description = "";
        this.validRoles = valid;
    }

    public String getName() {
        if (this.validRoles == null) {
            return ROLE_ANONYMOUS;
        }
        return this.name != null ? this.name : this.validRoles[0];
    }

    public String toString() {
        return this.name + ": " + this.description;
    }

    public String[] getValidRoles() {
        return this.validRoles;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("Role description can not be null");
        }
        this.description = description;
    }

    public void setName(String name) {
        if (!this.isValid(name)) {
            throw new IllegalArgumentException("Selected role must be one of valid roles");
        }
        this.name = name;
    }

    public boolean isValid(String preferredRole) {
        if (preferredRole == null) {
            return true;
        }
        if (this.validRoles == null) {
            return false;
        }
        for (String s : this.validRoles) {
            if (!preferredRole.equals(s)) continue;
            return true;
        }
        return false;
    }
}

