/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.component.xml;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.utils.component.xml.Component;
import org.wso2.carbon.utils.component.xml.ComponentConstants;
import org.wso2.carbon.utils.component.xml.builder.ComponentConfigBuilder;
import org.wso2.carbon.utils.component.xml.builder.DeployerConfigBuilder;
import org.wso2.carbon.utils.component.xml.builder.HTTPGetRequestProcessorConfigBuilder;
import org.wso2.carbon.utils.component.xml.builder.ManagementPermissionsBuilder;
import org.wso2.carbon.utils.component.xml.config.ComponentConfig;

public class ComponentConfigFactory
implements ComponentConstants {
    private static Log log = LogFactory.getLog(ComponentConfigFactory.class);
    private static Map<String, ComponentConfigBuilder> defaultConfigBuilderMap = new ConcurrentHashMap<String, ComponentConfigBuilder>();

    private ComponentConfigFactory() {
    }

    public static void addComponentBuilder(String configKey, ComponentConfigBuilder componentConfigBuilder) {
        defaultConfigBuilderMap.put(configKey, componentConfigBuilder);
    }

    public static Component build(InputStream xmlStream) throws CarbonException {
        Component component;
        if (xmlStream == null) {
            throw new CarbonException("component.xml stream is null..");
        }
        StAXOMBuilder builder = null;
        try {
            builder = new StAXOMBuilder(xmlStream);
            OMElement document = builder.getDocumentElement();
            OMElement compBuilderEle = document.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "componentBuilders"));
            if (compBuilderEle != null) {
                ComponentConfigFactory.processCustomBuilders(compBuilderEle);
            }
            component = new Component();
            Iterator itr = document.getChildElements();
            while (itr.hasNext()) {
                ComponentConfig[] componentConfig;
                OMElement configElement = (OMElement)itr.next();
                String configKey = configElement.getLocalName();
                ComponentConfigBuilder configBuilder = defaultConfigBuilderMap.get(configKey);
                if (configBuilder == null || (componentConfig = configBuilder.build(configElement)) == null) continue;
                component.addComponentConfig(configKey, componentConfig);
            }
        }
        catch (Exception e) {
            String msg = "Failed to build component configuration.";
            log.error((Object)msg, (Throwable)e);
            throw new CarbonException(msg, e);
        }
        return component;
    }

    private static void processCustomBuilders(OMElement buildersElement) throws CarbonException {
        Iterator iterator = buildersElement.getChildrenWithName(new QName("http://products.wso2.org/carbon", "componentBuilder"));
        while (iterator.hasNext()) {
            OMElement builderElement = (OMElement)iterator.next();
            OMElement classElement = builderElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "class"));
            String classString = null;
            if (classElement != null) {
                classString = classElement.getText().trim();
            }
            if (classString == null) {
                throw new CarbonException("Mandatory attribute custom component builder/name entry does not exist or is empty in the component.xml");
            }
            Class<?> deployerClass = null;
            try {
                deployerClass = Class.forName(classString);
                ComponentConfigBuilder configBuilder = (ComponentConfigBuilder)deployerClass.newInstance();
                defaultConfigBuilderMap.put(configBuilder.getLocalNameOfComponentConfigElement(), configBuilder);
            }
            catch (Exception e) {
                throw new CarbonException(e);
            }
        }
    }

    static {
        DeployerConfigBuilder deployerBuilder = new DeployerConfigBuilder();
        HTTPGetRequestProcessorConfigBuilder httpBuilder = new HTTPGetRequestProcessorConfigBuilder();
        ManagementPermissionsBuilder permisisonBuilder = new ManagementPermissionsBuilder();
        defaultConfigBuilderMap.put(deployerBuilder.getLocalNameOfComponentConfigElement(), deployerBuilder);
        defaultConfigBuilderMap.put(httpBuilder.getLocalNameOfComponentConfigElement(), httpBuilder);
        defaultConfigBuilderMap.put(permisisonBuilder.getLocalNameOfComponentConfigElement(), permisisonBuilder);
    }
}

